/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.normalizer;

import java.util.regex.Pattern;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.NormalizerDefinition;
import org.iplass.mtp.entity.definition.normalizers.NewlineNormalizer;
import org.iplass.mtp.entity.definition.normalizers.NewlineType;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.normalizer.MetaNormalizer;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaNewlineNormalizer
extends MetaNormalizer {
    private static final long serialVersionUID = -10976021022360335L;
    private static Pattern NEWLINE_PATTERN = Pattern.compile("\\r\\n|\\r|\\n");
    private static String CRLF_REPLACE = "\r\n";
    private static String LF_REPLACE = "\n";
    private NewlineType type;

    public NewlineType getType() {
        return this.type;
    }

    public void setType(NewlineType type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaNewlineNormalizer other = (MetaNewlineNormalizer)obj;
        return this.type == other.type;
    }

    @Override
    public MetaNewlineNormalizer copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(NormalizerDefinition definition) {
        this.type = ((NewlineNormalizer)definition).getType();
    }

    @Override
    public NewlineNormalizer currentConfig(EntityContext context) {
        return new NewlineNormalizer(this.type);
    }

    @Override
    public MetaNormalizer.NormalizerRuntime createRuntime(MetaEntity entity, MetaProperty property) {
        return new NewlineNormalizerRuntime(this, property);
    }

    public class NewlineNormalizerRuntime
    extends MetaNormalizer.NormalizerRuntime {
        private String replacement;

        NewlineNormalizerRuntime(MetaNewlineNormalizer this$0, MetaProperty property) {
            super(this$0);
            if (this$0.type == null) {
                throw new NullPointerException(property.getName() + "'s NewlineNormalizer type must specified");
            }
            switch (this$0.type) {
                case CRLF: {
                    this.replacement = CRLF_REPLACE;
                    break;
                }
                case LF: {
                    this.replacement = LF_REPLACE;
                    break;
                }
            }
        }

        @Override
        public Object normalize(Object value, ValidationContext context) {
            if (value == null) {
                return null;
            }
            return NEWLINE_PATTERN.matcher(value.toString()).replaceAll(this.replacement);
        }
    }
}

