/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.normalizer;

import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.NormalizerDefinition;
import org.iplass.mtp.entity.definition.normalizers.ScriptingNormalizer;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.normalizer.MetaNormalizer;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaScriptingNormalizer
extends MetaNormalizer {
    private static final long serialVersionUID = 767053580735072850L;
    public static final String ENTITY_BINDING_NAME = "entity";
    public static final String PROPERTY_NAME_BINDING_NAME = "propertyName";
    public static final String VALUE_BINDING_NAME = "value";
    public static final String CONTEXT_BINDING_NAME = "context";
    private String script;
    private boolean asArray = false;

    public boolean isAsArray() {
        return this.asArray;
    }

    public void setAsArray(boolean asArray) {
        this.asArray = asArray;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public MetaScriptingNormalizer copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.asArray ? 1231 : 1237);
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaScriptingNormalizer other = (MetaScriptingNormalizer)obj;
        if (this.asArray != other.asArray) {
            return false;
        }
        return !(this.script == null ? other.script != null : !this.script.equals(other.script));
    }

    @Override
    public void applyConfig(NormalizerDefinition definition) {
        ScriptingNormalizer d = (ScriptingNormalizer)definition;
        this.script = d.getScript();
        this.asArray = d.isAsArray();
    }

    @Override
    public ScriptingNormalizer currentConfig(EntityContext context) {
        ScriptingNormalizer d = new ScriptingNormalizer();
        d.setScript(this.script);
        d.setAsArray(this.asArray);
        return d;
    }

    @Override
    public MetaNormalizer.NormalizerRuntime createRuntime(MetaEntity entity, MetaProperty property) {
        return new ScriptingNormalizerRuntime(entity, property);
    }

    public class ScriptingNormalizerRuntime
    extends MetaNormalizer.NormalizerRuntime {
        private static final String SCRIPT_PREFIX = "ScriptingNormalizer_script";
        private Script compiledScript;
        private ScriptEngine scriptEngine;

        ScriptingNormalizerRuntime(MetaEntity entity, MetaProperty property) {
            super(MetaScriptingNormalizer.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            String scriptName = null;
            for (int i = 0; i < property.getNormalizers().size(); ++i) {
                if (MetaScriptingNormalizer.this != property.getNormalizers().get(i)) continue;
                scriptName = "ScriptingNormalizer_script_" + entity.getId() + "_" + property.getId() + "_" + i;
                break;
            }
            this.compiledScript = this.scriptEngine.createScript(MetaScriptingNormalizer.this.script, scriptName);
        }

        @Override
        public Object normalize(Object value, ValidationContext context) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute(MetaScriptingNormalizer.ENTITY_BINDING_NAME, context.getEntity());
            sc.setAttribute(MetaScriptingNormalizer.PROPERTY_NAME_BINDING_NAME, context.getPropertyName());
            sc.setAttribute(MetaScriptingNormalizer.VALUE_BINDING_NAME, value);
            sc.setAttribute(MetaScriptingNormalizer.CONTEXT_BINDING_NAME, context);
            return this.compiledScript.eval(sc);
        }

        @Override
        public Object normalizeArray(Object[] values, ValidationContext context) {
            if (MetaScriptingNormalizer.this.asArray) {
                return this.normalize(values, context);
            }
            return super.normalizeArray(values, context);
        }
    }
}

