/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.property;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceType;
import org.iplass.mtp.entity.definition.properties.VersionControlReferenceType;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferenceSortSpec;
import org.iplass.mtp.impl.metadata.MetaDataIllegalStateException;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QueryServiceHolder;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaReferenceProperty
extends MetaProperty {
    private static final long serialVersionUID = -5316413329202006700L;
    private String referenceEntityMetaDataId;
    private String mappedByPropertyMetaDataId;
    private ReferenceType referenceType;
    private List<ReferenceSortSpec> orderBy;
    private VersionControlReferenceType versionControlType;
    private String versionControlAsOfExpression;
    private boolean auditLogMappedBy;

    public MetaReferenceProperty() {
        this.setIndexType(IndexType.NON_INDEXED);
    }

    @Override
    public IndexType getIndexType() {
        return IndexType.NON_INDEXED;
    }

    @Override
    public void setIndexType(IndexType indexType) {
    }

    public String getVersionControlAsOfExpression() {
        return this.versionControlAsOfExpression;
    }

    public void setVersionControlAsOfExpression(String versionControlAsOfExpression) {
        this.versionControlAsOfExpression = versionControlAsOfExpression;
    }

    public VersionControlReferenceType getVersionControlType() {
        return this.versionControlType;
    }

    public void setVersionControlType(VersionControlReferenceType versionControlType) {
        this.versionControlType = versionControlType;
    }

    public List<ReferenceSortSpec> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<ReferenceSortSpec> orderBy) {
        this.orderBy = orderBy;
    }

    public String getReferenceEntityMetaDataId() {
        return this.referenceEntityMetaDataId;
    }

    public void setReferenceEntityMetaDataId(String referenceEntityMetaDataId) {
        this.referenceEntityMetaDataId = referenceEntityMetaDataId;
    }

    public String getMappedByPropertyMetaDataId() {
        return this.mappedByPropertyMetaDataId;
    }

    public void setMappedByPropertyMetaDataId(String mappedByPropertyMetaDataId) {
        this.mappedByPropertyMetaDataId = mappedByPropertyMetaDataId;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public boolean isAuditLogMappedBy() {
        return this.auditLogMappedBy;
    }

    public void setAuditLogMappedBy(boolean auditLogMappedBy) {
        this.auditLogMappedBy = auditLogMappedBy;
    }

    @Override
    public void applyConfig(PropertyDefinition pDef, EntityContext ectx) {
        if (!(pDef instanceof ReferenceProperty)) {
            throw new EntityRuntimeException("Illegal Type Convert. ReferenceProperty to PrimitiveProperty cannot support.");
        }
        this.fillFrom(pDef, ectx);
        ReferenceProperty refDef = (ReferenceProperty)pDef;
        EntityHandler refEntity = ectx.getHandlerByName(refDef.getObjectDefinitionName());
        if (refEntity == null) {
            throw new EntityRuntimeException(refDef.getObjectDefinitionName() + " is undefined.");
        }
        this.referenceEntityMetaDataId = refEntity.getMetaData().getId();
        if (refDef.getMappedBy() != null) {
            MetaProperty rh = refEntity.getMetaData().getDeclaredProperty(refDef.getMappedBy());
            if (rh == null) {
                throw new EntityRuntimeException(refDef.getObjectDefinitionName() + "." + refDef.getMappedBy() + " is undefined.");
            }
            if (!(rh instanceof MetaReferenceProperty)) {
                throw new EntityRuntimeException(refDef.getObjectDefinitionName() + "." + refDef.getMappedBy() + " is not reference property.");
            }
            this.mappedByPropertyMetaDataId = rh.getId();
        } else {
            this.mappedByPropertyMetaDataId = null;
        }
        this.referenceType = refDef.getReferenceType();
        if (refDef.getOrderBy() != null) {
            OrderBy q;
            try {
                q = (OrderBy)QueryServiceHolder.getInstance().getQueryParser().parse("order by " + refDef.getOrderBy(), OrderBySyntax.class);
            }
            catch (ParseException e) {
                throw new QueryException(e.getMessage(), e);
            }
            if (q.getSortSpecList() != null && q.getSortSpecList().size() > 0) {
                ArrayList<ReferenceSortSpec> sList = new ArrayList<ReferenceSortSpec>();
                for (SortSpec ss : q.getSortSpecList()) {
                    if (!(ss.getSortKey() instanceof EntityField)) {
                        throw new EntityRuntimeException("sort key must EntityField:" + String.valueOf(ss.getSortKey()));
                    }
                    String sortPropName = ((EntityField)ss.getSortKey()).getPropertyName();
                    MetaProperty ph = refEntity.getMetaData().getDeclaredProperty(sortPropName);
                    if (ph == null) {
                        EntityHandler superEh = refEntity.getSuperDataModelHandler(ectx);
                        ph = superEh.getMetaData().getDeclaredProperty(sortPropName);
                    }
                    if (ph == null) {
                        throw new EntityRuntimeException("sort key " + String.valueOf(ss.getSortKey()) + " is not defined at " + refDef.getObjectDefinitionName());
                    }
                    if (ph instanceof MetaReferenceProperty) {
                        throw new EntityRuntimeException("sort key must PrimitiveProperty:" + String.valueOf(ss.getSortKey()));
                    }
                    if (ss.getType() == SortSpec.SortType.DESC) {
                        sList.add(new ReferenceSortSpec(ph.getId(), ReferenceSortSpec.SortType.DESC));
                        continue;
                    }
                    sList.add(new ReferenceSortSpec(ph.getId(), ReferenceSortSpec.SortType.ASC));
                }
                this.orderBy = sList;
            }
        } else {
            this.orderBy = null;
        }
        this.versionControlType = refDef.getVersionControlType();
        this.versionControlAsOfExpression = refDef.getVersionControlAsOfExpression();
        this.auditLogMappedBy = refDef.isAuditLogMappedBy();
    }

    @Override
    public MetaReferenceProperty copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public PropertyDefinition currentConfig(EntityContext ectx) {
        ReferenceProperty pd = new ReferenceProperty();
        this.fillTo(pd, ectx);
        pd.setVersionControlType(this.versionControlType);
        pd.setVersionControlAsOfExpression(this.versionControlAsOfExpression);
        EntityHandler refEntity = ectx.getHandlerById(this.referenceEntityMetaDataId);
        if (refEntity != null) {
            block13: {
                pd.setObjectDefinitionName(refEntity.getMetaData().getName());
                if (this.mappedByPropertyMetaDataId != null) {
                    try {
                        ReferencePropertyHandler rh = (ReferencePropertyHandler)refEntity.getDeclaredPropertyById(this.mappedByPropertyMetaDataId);
                        if (rh == null) {
                            return null;
                        }
                        pd.setMappedBy(rh.getName());
                    }
                    catch (MetaDataIllegalStateException e) {
                        MetaEntity metaRefEntity = refEntity.getMetaData();
                        MetaProperty metaProp = metaRefEntity.getDeclaredPropertyById(this.mappedByPropertyMetaDataId);
                        if (metaProp == null) break block13;
                        pd.setMappedBy(metaProp.getName());
                    }
                }
            }
            pd.setReferenceType(this.referenceType);
            if (this.orderBy != null && this.orderBy.size() > 0) {
                OrderBy q = new OrderBy();
                for (ReferenceSortSpec rss : this.orderBy) {
                    try {
                        PropertyHandler ph = refEntity.getPropertyById(rss.getSortPropertyMetaDataId(), ectx);
                        if (ph == null || ph instanceof ReferencePropertyHandler) continue;
                        if (rss.getSortType() == ReferenceSortSpec.SortType.DESC) {
                            q.add(new SortSpec(ph.getName(), SortSpec.SortType.DESC));
                            continue;
                        }
                        q.add(new SortSpec(ph.getName(), SortSpec.SortType.ASC));
                    }
                    catch (MetaDataIllegalStateException e) {
                        MetaProperty ph = refEntity.getMetaData().getDeclaredPropertyById(rss.getSortPropertyMetaDataId());
                        if (ph == null && refEntity.getMetaData().getInheritedEntityMetaDataId() != null) {
                            EntityHandler superEh = refEntity.getSuperDataModelHandler(ectx);
                            ph = superEh.getMetaData().getDeclaredPropertyById(rss.getSortPropertyMetaDataId());
                        }
                        if (ph == null || ph instanceof MetaReferenceProperty) continue;
                        if (rss.getSortType() == ReferenceSortSpec.SortType.DESC) {
                            q.add(new SortSpec(ph.getName(), SortSpec.SortType.DESC));
                            continue;
                        }
                        q.add(new SortSpec(ph.getName(), SortSpec.SortType.ASC));
                    }
                }
                if (q.getSortSpecList() != null && q.getSortSpecList().size() > 0) {
                    pd.setOrderBy(q.toString().substring("order by".length()));
                }
            }
            pd.setAuditLogMappedBy(this.auditLogMappedBy);
            return pd;
        }
        return null;
    }

    @Override
    public ReferencePropertyHandler createRuntime(MetaEntity metaEntity) {
        return new ReferencePropertyHandler(this, metaEntity);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.auditLogMappedBy ? 1231 : 1237);
        result = 31 * result + (this.mappedByPropertyMetaDataId == null ? 0 : this.mappedByPropertyMetaDataId.hashCode());
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (this.referenceEntityMetaDataId == null ? 0 : this.referenceEntityMetaDataId.hashCode());
        result = 31 * result + (this.referenceType == null ? 0 : this.referenceType.hashCode());
        result = 31 * result + (this.versionControlAsOfExpression == null ? 0 : this.versionControlAsOfExpression.hashCode());
        result = 31 * result + (this.versionControlType == null ? 0 : this.versionControlType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaReferenceProperty other = (MetaReferenceProperty)obj;
        if (this.auditLogMappedBy != other.auditLogMappedBy) {
            return false;
        }
        if (this.mappedByPropertyMetaDataId == null ? other.mappedByPropertyMetaDataId != null : !this.mappedByPropertyMetaDataId.equals(other.mappedByPropertyMetaDataId)) {
            return false;
        }
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        if (this.referenceEntityMetaDataId == null ? other.referenceEntityMetaDataId != null : !this.referenceEntityMetaDataId.equals(other.referenceEntityMetaDataId)) {
            return false;
        }
        if (this.referenceType != other.referenceType) {
            return false;
        }
        if (this.versionControlAsOfExpression == null ? other.versionControlAsOfExpression != null : !this.versionControlAsOfExpression.equals(other.versionControlAsOfExpression)) {
            return false;
        }
        return this.versionControlType == other.versionControlType;
    }
}

