/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.versioning;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityApplicationException;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.properties.VersionControlReferenceType;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformerSupport;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.hint.FetchSizeHint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.aggregate.Max;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.DeleteTarget;
import org.iplass.mtp.impl.entity.versioning.VersionController;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;

public class NumberbaseVersionController
implements VersionController {
    static final Long VER_ZERO = 0L;

    @Override
    public void normalizeForInsert(Entity entity, InsertOption option, EntityContext entityContext) {
        if (option.isVersionSpecified()) {
            Long ver = entity.getVersion();
            if (ver != null) {
                entity.setVersion(ver);
            } else {
                entity.setVersion(0L);
            }
        } else {
            entity.setVersion(0L);
        }
    }

    @Override
    public Entity[] normalizeRefEntity(Entity[] refEntity, ReferencePropertyHandler rph, EntityContext context) {
        if (refEntity == null) {
            return null;
        }
        if (rph.getMetaData().getVersionControlType() == VersionControlReferenceType.AS_OF_EXPRESSION_BASE) {
            for (Entity e : refEntity) {
                if (e == null || e.getVersion() != null) continue;
                e.setVersion(VER_ZERO);
            }
            return refEntity;
        }
        ArrayList<ValueExpression> oids = new ArrayList<ValueExpression>();
        for (Entity e : refEntity) {
            if (e == null || e.getVersion() != null) continue;
            oids.add(new Literal(e.getOid()));
        }
        if (oids.size() == 0) {
            return refEntity;
        }
        EntityHandler targetEh = rph.getReferenceEntityHandler(context);
        Query q = new Query();
        q.select("oid", "version");
        q.from(targetEh.getMetaData().getName());
        q.where(new In((ValueExpression)new EntityField("oid"), oids));
        final HashMap res = new HashMap();
        targetEh.searchEntity(q, false, null, new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                res.put(dataModel.getOid(), dataModel.getVersion());
                return true;
            }
        });
        for (Entity e : refEntity) {
            if (e == null || e.getVersion() != null) continue;
            Long ver = (Long)res.get(e.getOid());
            if (ver != null) {
                e.setVersion(ver);
                continue;
            }
            e.setVersion(VER_ZERO);
        }
        return refEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getCurrentMaxVersionNo(String oid, EntityHandler eh, EntityContext entityContext) {
        Query q = new Query();
        Max val = new Max("version");
        q.select().add((Object)val);
        q.from(eh.getMetaData().getName());
        q.where(new Equals("oid", oid));
        q.select().addHint(new FetchSizeHint(1));
        try (SearchResultIterator it = eh.getStrategy().search(entityContext, q, eh);){
            if (it.next()) {
                Long l = (Long)it.getValue(0);
                return l;
            }
            Long l = null;
            return l;
        }
    }

    private Entity merge(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        Entity before = (Entity)new EntityLoadInvocationImpl(entity.getOid(), entity.getVersion(), new LoadOption(true, false).versioned(), false, eh.getService().getInterceptors(), eh).proceed();
        if (before == null) {
            throw new EntityConcurrentUpdateException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.alreadyOperated", eh.getLocalizedDisplayName()));
        }
        if (option.isCheckTimestamp() && !before.getUpdateDate().equals(entity.getUpdateDate())) {
            throw new EntityConcurrentUpdateException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.alreadyOperated", eh.getLocalizedDisplayName()));
        }
        if (option.getUpdateProperties() != null) {
            for (String propName : option.getUpdateProperties()) {
                PropertyHandler ph = eh.getProperty(propName, entityContext);
                if (!ph.getMetaData().isUpdatable()) continue;
                before.setValue(propName, entity.getValue(propName));
            }
        }
        return before;
    }

    @Override
    public void update(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        for (String propName : option.getUpdateProperties()) {
            IndexType it = eh.getProperty(propName, entityContext).getMetaData().getIndexType();
            if (it != IndexType.UNIQUE && it != IndexType.UNIQUE_WITHOUT_NULL) continue;
            throw new EntityApplicationException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.notChange", eh.getProperty(propName, entityContext).getLocalizedDisplayName()));
        }
        switch (option.getTargetVersion()) {
            case SPECIFIC: {
                if (entity.getVersion() == null) {
                    throw new EntityRuntimeException("must specify version when TargetVersion.SPECIFIC");
                }
                eh.updateDirect(entity, option, entityContext);
                break;
            }
            case NEW: {
                Entity merged = this.merge(entity, option, eh, entityContext);
                Long version = this.getCurrentMaxVersionNo(entity.getOid(), eh, entityContext);
                if (version == null) {
                    throw new EntityConcurrentUpdateException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.alreadyOperated", eh.getLocalizedDisplayName()));
                }
                Long newVersion = version + 1L;
                merged.setVersion(newVersion);
                merged.setCreateBy(entity.getUpdateBy());
                merged.setUpdateBy(entity.getUpdateBy());
                merged.setUpdateDate(null);
                eh.insertDirect(merged, entityContext);
                entity.setVersion(newVersion);
                break;
            }
            case CURRENT_VALID: {
                Entity before = (Entity)new EntityLoadInvocationImpl(entity.getOid(), null, new LoadOption(true, false), false, eh.getService().getInterceptors(), eh).proceed();
                if (before == null || option.isCheckTimestamp() && !before.getUpdateDate().equals(entity.getUpdateDate())) {
                    throw new EntityConcurrentUpdateException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.alreadyOperated", eh.getLocalizedDisplayName()));
                }
                entity.setVersion(before.getVersion());
                eh.updateDirect(entity, option, entityContext);
                break;
            }
            default: {
                throw new EntityRuntimeException("must specify tergetVersion option.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTarget[] getDeleteTarget(Entity entity, DeleteOption option, EntityHandler eh, EntityContext entityContext) {
        Entity before;
        if (option.getTargetVersion() == DeleteTargetVersion.SPECIFIC) {
            return new DeleteTarget[]{new DeleteTarget(entity.getOid(), entity.getVersion(), entity.getUpdateDate())};
        }
        if (option.isCheckTimestamp() && ((before = (Entity)new EntityLoadInvocationImpl(entity.getOid(), null, new LoadOption(true, false), false, eh.getService().getInterceptors(), eh).proceed()) == null || !before.getUpdateDate().equals(entity.getUpdateDate()))) {
            throw new EntityConcurrentUpdateException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.alreadyOperated", eh.getLocalizedDisplayName()));
        }
        Query q = new Query();
        EntityField version = new EntityField("version");
        EntityField updateDate = new EntityField("updateDate");
        q.select().add(version, updateDate);
        q.from(eh.getMetaData().getName());
        q.where(new Equals("oid", entity.getOid()));
        ArrayList<DeleteTarget> res = new ArrayList<DeleteTarget>();
        try (SearchResultIterator it = eh.getStrategy().search(entityContext, q, eh);){
            while (it.next()) {
                res.add(new DeleteTarget(entity.getOid(), (Long)it.getValue(0), (Timestamp)it.getValue(1)));
            }
        }
        if (res.size() == 0) {
            throw new EntityConcurrentUpdateException(NumberbaseVersionController.resourceString("impl.core.versioning.NumberbaseVersionController.alreadyOperated", eh.getLocalizedDisplayName()));
        }
        return res.toArray(new DeleteTarget[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCascadeDeleteTarget(Entity entity, EntityHandler eh, ReferencePropertyHandler rph, EntityContext entityContext) {
        Query q = new Query();
        EntityField refOid = new EntityField(rph.getName() + ".oid");
        q.selectDistinct(refOid);
        q.from(eh.getMetaData().getName());
        q.where(new Equals("oid", entity.getOid()));
        q.versioned(true);
        ArrayList<String> res = new ArrayList<String>();
        try (SearchResultIterator it = eh.getStrategy().search(entityContext, q, eh);){
            while (it.next()) {
                res.add((String)it.getValue(0));
            }
        }
        if (res.size() == 0) {
            return null;
        }
        return res.toArray(new String[res.size()]);
    }

    protected AsOf judgeAsOf(String refPropPath, ReferencePropertyHandler rph, AsOf asOf) {
        if (asOf == null) {
            if (rph.getMetaData().getVersionControlType() == VersionControlReferenceType.RECORD_BASE) {
                return new AsOf(AsOf.AsOfSpec.UPDATE_TIME);
            }
            if (rph.getMetaData().getVersionControlType() == VersionControlReferenceType.AS_OF_EXPRESSION_BASE) {
                ValueExpression ve = rph.getAsOfExpression();
                if (ve == null) {
                    throw new IllegalStateException("no versionControlAsOfExpression specified.");
                }
                String prefixRefPath = null;
                int index = refPropPath.lastIndexOf(46);
                if (index >= 0) {
                    prefixRefPath = refPropPath.substring(0, index);
                }
                return new AsOf((ValueExpression)ve.accept(new RefAdder(prefixRefPath)));
            }
            return new AsOf(AsOf.AsOfSpec.NOW);
        }
        return asOf;
    }

    @Override
    public Condition refEntityQueryCondition(String refPropPath, ReferencePropertyHandler rph, AsOf asOf, EntityContext context) {
        asOf = this.judgeAsOf(refPropPath, rph, asOf);
        switch (asOf.getSpec()) {
            case UPDATE_TIME: {
                return null;
            }
            case NOW: {
                In in = new In(new String[]{refPropPath + ".oid", refPropPath + ".version"}, new SubQuery(new Query().select(new EntityField("oid"), new Max("version")).from(rph.getReferenceEntityHandler(context).getMetaData().getName()).where(new Equals("state", "V")).groupBy("oid")).on(refPropPath, "this"));
                return in;
            }
            case SPEC_VALUE: {
                ValueExpression asOfVal = asOf.getValue();
                if (asOfVal != null) {
                    asOfVal = (ValueExpression)asOfVal.accept(new PropertyUnnester());
                }
                In in2 = new In(new String[]{refPropPath + ".oid", refPropPath + ".version"}, new SubQuery(new Query().select(new EntityField("oid"), new EntityField("version")).from(rph.getReferenceEntityHandler(context).getMetaData().getName()).where(new Equals("state", "V"))).on(new And(new Equals(new EntityField("." + refPropPath), new EntityField("this")), new Equals("version", (Object)asOfVal))));
                return in2;
            }
        }
        return null;
    }

    @Override
    public Condition mainQueryCondition(EntityHandler eh, AsOf asOf, EntityContext context) {
        if (asOf == null || asOf.getSpec() != AsOf.AsOfSpec.SPEC_VALUE) {
            return new Equals("version", (Object)new ScalarSubQuery(new Query().select(new Max("version")).from(eh.getMetaData().getName()).where(new Equals("state", "V"))).on("this", "this"));
        }
        ValueExpression asOfVal = asOf.getValue();
        if (asOfVal != null) {
            asOfVal = (ValueExpression)asOfVal.accept(new PropertyUnnester());
        }
        return new Equals("version", (Object)new ScalarSubQuery(new Query().select(new EntityField("version")).from(eh.getMetaData().getName()).where(new Equals("state", "V"))).on(new And(new Equals(new EntityField(".this"), new EntityField("this")), new Equals("version", (Object)asOfVal))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entity[] getCascadeDeleteTargetForUpdate(Entity[] refEntity, Entity[] beforeRefEntity, ReferencePropertyHandler rph, Entity beforeEntity, EntityHandler eh, EntityContext entityContext) {
        ArrayList<Entity> potentialTarget = new ArrayList<Entity>();
        for (Entity e : beforeRefEntity) {
            if (e == null) continue;
            if (refEntity == null) {
                potentialTarget.add(e);
                continue;
            }
            boolean match = false;
            for (Entity newE : refEntity) {
                if (newE == null || !newE.getOid().equals(e.getOid())) continue;
                match = true;
                break;
            }
            if (match) continue;
            potentialTarget.add(e);
        }
        if (potentialTarget.size() == 0) {
            return null;
        }
        Query q = new Query();
        EntityField refOid = new EntityField(rph.getName() + ".oid");
        q.selectDistinct(refOid);
        q.from(eh.getMetaData().getName());
        q.where(new Equals("oid", beforeEntity.getOid()));
        q.versioned(true);
        ArrayList<String> searched = new ArrayList<String>();
        try (SearchResultIterator it = eh.getStrategy().search(entityContext, q, eh);){
            while (it.next()) {
                String rov = (String)it.getValue(0);
                if (rov == null) continue;
                searched.add(rov);
            }
        }
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity e : potentialTarget) {
            boolean isMatch = false;
            for (String soid : searched) {
                if (!soid.equals(e.getOid())) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            ret.add(e);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret.toArray(new Entity[ret.size()]);
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    static class RefAdder
    extends ASTTransformerSupport {
        private String prefixRefPath;
        private RefAdder parent;

        public RefAdder(String prefixRefPath) {
            this.prefixRefPath = prefixRefPath;
        }

        @Override
        public ASTNode visit(EntityField entityField) {
            if (this.parent != null) {
                int unnestCount = entityField.unnestCount();
                RefAdder target = this;
                for (int i = 0; i < unnestCount; ++i) {
                    target = target.parent;
                    if (target != null) continue;
                    throw new QueryException("can't correlate outer query on :" + String.valueOf(entityField));
                }
                if (target.parent == null) {
                    if (this.prefixRefPath == null) {
                        return new EntityField(entityField.getPropertyName());
                    }
                    if ("this".equalsIgnoreCase(entityField.getPropertyName())) {
                        return new EntityField(this.prefixRefPath);
                    }
                    return new EntityField(this.prefixRefPath + "." + entityField.getPropertyName());
                }
                return new EntityField(entityField.getPropertyName());
            }
            if (this.prefixRefPath == null) {
                return new EntityField(entityField.getPropertyName());
            }
            return new EntityField(this.prefixRefPath + "." + entityField.getPropertyName());
        }

        @Override
        public ASTNode visit(SubQuery subQuery) {
            Query q = subQuery.getQuery().copy();
            Condition on = null;
            if (subQuery.getOn() != null) {
                RefAdder sub = new RefAdder(this.prefixRefPath);
                sub.parent = this;
                on = (Condition)subQuery.getOn().accept(sub);
            }
            return new SubQuery(q, on);
        }
    }

    static class PropertyUnnester
    extends ASTTransformerSupport {
        private PropertyUnnester parent;

        PropertyUnnester() {
        }

        @Override
        public ASTNode visit(EntityField entityField) {
            if (this.parent != null) {
                int unnestCount = entityField.unnestCount();
                PropertyUnnester target = this;
                for (int i = 0; i < unnestCount; ++i) {
                    target = target.parent;
                    if (target != null) continue;
                    throw new QueryException("can't correlate outer query on :" + String.valueOf(entityField));
                }
                if (target.parent == null) {
                    return new EntityField("." + entityField.getPropertyName());
                }
                return new EntityField(entityField.getPropertyName());
            }
            return new EntityField("." + entityField.getPropertyName());
        }

        @Override
        public ASTNode visit(SubQuery subQuery) {
            Query q = subQuery.getQuery().copy();
            Condition on = null;
            if (subQuery.getOn() != null) {
                PropertyUnnester sub = new PropertyUnnester();
                sub.parent = this;
                on = (Condition)subQuery.getOn().accept(sub);
            }
            return new SubQuery(q, on);
        }
    }
}

