/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.versioning;

import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.interceptor.EntityUpdateAllInvocationImpl;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.NumberbaseVersionController;

public class StatebaseVersionController
extends NumberbaseVersionController {
    @Override
    public void update(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        boolean needStateUpdate = this.needStateUpdate(entity, option, eh, entityContext);
        super.update(entity, option, eh, entityContext);
        if (needStateUpdate) {
            UpdateCondition uc = new UpdateCondition(eh.getMetaData().getName()).value("state", new SelectValue("I")).where(new And().and(new Equals("oid", entity.getOid())).and(new NotEquals("version", entity.getVersion())).and(new Equals("state", new SelectValue("V"))));
            new EntityUpdateAllInvocationImpl(uc, eh.getService().getInterceptors(), eh).proceed();
        }
    }

    private boolean needStateUpdate(Entity entity, UpdateOption option, EntityHandler eh, EntityContext entityContext) {
        if (option.getTargetVersion() == TargetVersion.NEW) {
            return true;
        }
        return option.getUpdateProperties() != null && option.getUpdateProperties().contains("state") && entity.getState() != null && "V".equals(entity.getState().getValue());
    }

    @Override
    public Condition refEntityQueryCondition(String refPropPath, ReferencePropertyHandler rph, AsOf asOf, EntityContext context) {
        asOf = this.judgeAsOf(refPropPath, rph, asOf);
        switch (asOf.getSpec()) {
            case UPDATE_TIME: {
                return null;
            }
            case NOW: {
                return new Equals(refPropPath + ".state", "V");
            }
            case SPEC_VALUE: {
                ValueExpression asOfVal = asOf.getValue();
                return new Equals(refPropPath + ".version", (Object)asOfVal);
            }
        }
        return null;
    }

    @Override
    public Condition mainQueryCondition(EntityHandler eh, AsOf asOf, EntityContext context) {
        if (asOf == null || asOf.getSpec() != AsOf.AsOfSpec.SPEC_VALUE) {
            return new Equals("state", "V");
        }
        ValueExpression asOfVal = asOf.getValue();
        return new Equals("version", (Object)asOfVal);
    }
}

