/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.versioning;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformerSupport;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.VersionController;

public class VersionedQueryNormalizer
extends ASTTransformerSupport {
    private VersionController vc;
    private EntityHandler eh;
    private EntityContext context;
    private boolean isVersionSpecify;
    private boolean isConditonNode;
    private Map<String, VersionInfo> refs;
    private VersionedQueryNormalizer parent;

    public VersionedQueryNormalizer(VersionController vc, EntityHandler eh, EntityContext context, VersionedQueryNormalizer parent) {
        this.vc = vc;
        this.eh = eh;
        this.context = context;
        this.isVersionSpecify = false;
        this.isConditonNode = false;
        this.refs = new HashMap<String, VersionInfo>();
        this.parent = parent;
    }

    @Override
    public ASTNode visit(Where where) {
        this.isConditonNode = true;
        ASTNode node = super.visit(where);
        this.isConditonNode = false;
        return node;
    }

    @Override
    public ASTNode visit(EntityField entityField) {
        String propName = entityField.getPropertyName();
        VersionedQueryNormalizer target = this;
        int unnestCount = entityField.unnestCount();
        if (unnestCount > 0) {
            propName = propName.substring(unnestCount);
            for (int i = 0; i < unnestCount; ++i) {
                target = target.parent;
                if (target != null) continue;
                throw new QueryException("can't correlate outer query on :" + String.valueOf(entityField));
            }
        }
        if (propName.contains(".")) {
            String[] propPath = propName.split("[.]");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < propPath.length - 1; ++i) {
                if (i != 0) {
                    sb.append('.');
                }
                sb.append(propPath[i]);
                String refPropName = sb.toString();
                VersionInfo vi = target.getVi(refPropName);
                if (i != propPath.length - 2 || !target.isConditonNode || !VersionedQueryNormalizer.isVersionProperty(propPath[propPath.length - 1])) continue;
                vi.isVersionSpecify = true;
            }
        } else if (target.isConditonNode && VersionedQueryNormalizer.isVersionProperty(propName)) {
            target.isVersionSpecify = true;
        }
        return super.visit(entityField);
    }

    private VersionInfo getVi(String refPropName) {
        VersionInfo vi = this.refs.get(refPropName);
        if (vi == null) {
            PropertyHandler ph = this.eh.getPropertyCascade(refPropName, this.context);
            if (ph == null || !(ph instanceof ReferencePropertyHandler)) {
                throw new EntityRuntimeException(this.eh.getMetaData().getName() + "." + refPropName + " is not ReferenceProperty.");
            }
            vi = new VersionInfo(this, (ReferencePropertyHandler)ph);
            this.refs.put(refPropName, vi);
        }
        return vi;
    }

    public static boolean isVersionProperty(String propName) {
        return propName.equals("version") || propName.equals("state") || propName.equals("startDate") || propName.equals("endDate");
    }

    @Override
    public ASTNode visit(Query query) {
        Query q = (Query)super.visit(query);
        And and = new And();
        if (q.getWhere() != null && q.getWhere().getCondition() != null) {
            and.addExpression(new Paren(q.getWhere().getCondition()));
        }
        if (!this.isVersionSpecify && !q.isVersioned()) {
            and.addExpression(this.vc.mainQueryCondition(this.eh, q.getFrom().getAsOf(), this.context));
        }
        if (this.refs.size() != 0) {
            for (Map.Entry<String, VersionInfo> e : this.refs.entrySet()) {
                VersionController refVc;
                Condition refEntityCond;
                if (e.getValue().isVersionSpecify || (refEntityCond = (refVc = this.eh.getService().getVersionController(e.getValue().rph.getReferenceEntityHandler(this.context))).refEntityQueryCondition(e.getKey(), e.getValue().rph, e.getValue().asOf, this.context)) == null) continue;
                Refer r = q.refer(e.getKey());
                if (r.getCondition() == null) {
                    r.setCondition(refEntityCond);
                    continue;
                }
                r.setCondition(new And(r.getCondition(), refEntityCond));
            }
        }
        if (and.getChildExpressions() != null) {
            if (and.getChildExpressions().size() > 1) {
                q.where(and);
            } else if (and.getChildExpressions().size() > 0) {
                q.where(and.getChildExpressions().get(0));
            }
        }
        q.setVersioned(true);
        return q;
    }

    @Override
    public ASTNode visit(SubQuery subQuery) {
        Query query = null;
        Condition on = null;
        if (subQuery.getQuery() != null) {
            EntityHandler subEh = this.context.getHandlerByName(subQuery.getQuery().getFrom().getEntityName());
            VersionedQueryNormalizer subNormalizer = new VersionedQueryNormalizer(subEh.getService().getVersionController(subEh), subEh, this.context, this);
            if (subQuery.getOn() != null) {
                on = (Condition)subQuery.getOn().accept(subNormalizer);
            }
            query = (Query)subQuery.getQuery().accept(subNormalizer);
        }
        return new SubQuery(query, on);
    }

    @Override
    public ASTNode visit(Refer refer) {
        if (refer.getAsOf() != null) {
            VersionInfo vi = this.getVi(refer.getReferenceName().getPropertyName());
            vi.asOf = refer.getAsOf();
        }
        return super.visit(refer);
    }

    private class VersionInfo {
        ReferencePropertyHandler rph;
        boolean isVersionSpecify;
        AsOf asOf;

        VersionInfo(VersionedQueryNormalizer versionedQueryNormalizer, ReferencePropertyHandler rph) {
            this.rph = rph;
            this.isVersionSpecify = false;
        }
    }
}

