/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchService;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogDeleteSql;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogInsertSql;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogSearchSql;
import org.iplass.mtp.impl.fulltextsearch.sql.CrawlLogUpdateSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogDeleteSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogSearchSql;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogTable;
import org.iplass.mtp.impl.properties.extend.ExpressionType;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractFulltextSeachService
implements FulltextSearchService {
    private static Logger logger = LoggerFactory.getLogger(AbstractFulltextSeachService.class);
    private RdbAdapter rdb;
    private CrawlLogDeleteSql crawlLogDeleteSql;
    private CrawlLogSearchSql crawlLogSearchSql;
    private CrawlLogInsertSql crawlLogInsertSql;
    private CrawlLogUpdateSql crawlLogUpdateSql;
    private DeleteLogDeleteSql deleteLogDeleteSql;
    private DeleteLogSearchSql deleteLogSearchSql;
    private boolean useFulltextSearch;
    private int maxRows = 0;
    private boolean throwExceptionWhenOverLimit;

    @Override
    public void init(Config config) {
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.useFulltextSearch = Boolean.valueOf(config.getValue("useFulltextSearch"));
        this.maxRows = Integer.valueOf(config.getValue("maxRows"));
        this.throwExceptionWhenOverLimit = Boolean.valueOf(config.getValue("throwExceptionWhenOverLimit"));
        if (this.useFulltextSearch) {
            this.crawlLogSearchSql = this.rdb.getQuerySqlCreator(CrawlLogSearchSql.class);
            this.crawlLogDeleteSql = this.rdb.getUpdateSqlCreator(CrawlLogDeleteSql.class);
            this.crawlLogInsertSql = this.rdb.getUpdateSqlCreator(CrawlLogInsertSql.class);
            this.crawlLogUpdateSql = this.rdb.getUpdateSqlCreator(CrawlLogUpdateSql.class);
            this.deleteLogDeleteSql = this.rdb.getUpdateSqlCreator(DeleteLogDeleteSql.class);
            this.deleteLogSearchSql = this.rdb.getQuerySqlCreator(DeleteLogSearchSql.class);
        }
    }

    @Override
    public void initTenantContext(TenantContext tenantContext) {
    }

    @Override
    public void destroyTenantContext(TenantContext tenantContext) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isUseFulltextSearch() {
        return this.useFulltextSearch;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public boolean isThrowExceptionWhenOverLimit() {
        return this.throwExceptionWhenOverLimit;
    }

    @Override
    public Map<String, Timestamp> getLastCrawlTimestamp(String ... defNames) {
        HashMap<String, Timestamp> result = new HashMap<String, Timestamp>();
        Map<String, CrawlTimestampDto> crawlData = this.getAllLastCrawlTimestamp();
        EntityService ehs = ServiceRegistry.getRegistry().getService(EntityService.class);
        if (defNames.length == 0) {
            crawlData.forEach((key, value) -> {
                EntityHandler entity = ehs.getRuntimeById((String)key);
                if (entity != null) {
                    result.put(entity.getMetaData().getName(), value.getUpDate());
                }
            });
        } else {
            for (String defName : defNames) {
                EntityHandler entity = ehs.getRuntimeByName(defName);
                if (entity == null) {
                    throw new FulltextSearchRuntimeException("A target entity is not exist. [Entity\uff1a" + defName + "]");
                }
                String key2 = entity.getMetaData().getId();
                if (!crawlData.containsKey(key2)) continue;
                result.put(defName, crawlData.get(key2).getUpDate());
            }
        }
        return result;
    }

    protected Timestamp getLastCrawlTimestamp(final String defId, final int version) {
        SqlExecuter<Timestamp> exec = new SqlExecuter<Timestamp>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Timestamp logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.crawlLogSearchSql.toGetLastCrawlTimestampSql(tenantId, defId, version, AbstractFulltextSeachService.this.rdb);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    if (rs.next()) {
                        Timestamp timestamp = rs.getTimestamp(1, AbstractFulltextSeachService.this.rdb.rdbCalendar());
                        return timestamp;
                    }
                }
                return null;
            }
        };
        return (Timestamp)exec.execute(this.rdb, true);
    }

    private Map<String, CrawlTimestampDto> getAllLastCrawlTimestamp() {
        SqlExecuter<Map<String, CrawlTimestampDto>> exec = new SqlExecuter<Map<String, CrawlTimestampDto>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, CrawlTimestampDto> logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.crawlLogSearchSql.toGetAllLastCrawlTimestampSql(tenantId, AbstractFulltextSeachService.this.rdb);
                HashMap<String, CrawlTimestampDto> data = new HashMap<String, CrawlTimestampDto>();
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    while (rs.next()) {
                        CrawlTimestampDto dto = new CrawlTimestampDto();
                        dto.setObjDefId(rs.getString(1));
                        dto.setObjDefVer(rs.getString(2));
                        dto.setUpDate(rs.getTimestamp(3, AbstractFulltextSeachService.this.rdb.rdbCalendar()));
                        data.put(dto.getObjDefId(), dto);
                    }
                }
                return data;
            }
        };
        return (Map)exec.execute(this.rdb, true);
    }

    protected void insertCrawlLog(final String defId, final int version, final Timestamp sysdate) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.crawlLogInsertSql.toSql(tenantId, defId, version, sysdate, AbstractFulltextSeachService.this.rdb);
                logger.debug("insert crawl log sql : " + sql);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected void updateCrawlLog(final String defId, final int version, final Timestamp sysdate) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.crawlLogUpdateSql.toSql(tenantId, defId, version, sysdate, AbstractFulltextSeachService.this.rdb);
                logger.debug("update crawl log sql : " + sql);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected List<RestoreDto> getRestoreIndexData(final String defId, final Timestamp baseDate) {
        SqlExecuter<List<RestoreDto>> exec = new SqlExecuter<List<RestoreDto>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RestoreDto> logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.deleteLogSearchSql.toGetDeleteIndexDataSql(tenantId, defId, baseDate, AbstractFulltextSeachService.this.rdb);
                ArrayList<RestoreDto> dtoList = new ArrayList<RestoreDto>();
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    while (rs.next()) {
                        RestoreDto dto = new RestoreDto();
                        dto.setTenantId(rs.getInt(1));
                        dto.setObjDefId(rs.getString(2));
                        dto.setObjId(rs.getString(3));
                        dto.setObjVer(rs.getLong(4));
                        dto.setStatus(DeleteLogTable.Status.codeOf(rs.getString(5)));
                        String id = dto.getTenantId() + "_" + dto.getObjDefId() + "_" + dto.getObjId() + "_" + dto.getObjVer();
                        dto.setId(id);
                        dtoList.add(dto);
                    }
                }
                return dtoList;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    protected void removeDeleteLog(final String defId, final Timestamp baseDate) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.deleteLogDeleteSql.deleteProcessedLog(tenantId, defId, baseDate, AbstractFulltextSeachService.this.rdb);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected void removeAllDeleteLog() {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.deleteLogDeleteSql.deleteAll(tenantId, AbstractFulltextSeachService.this.rdb);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected void removeAllCrawlLog() {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                String sql = AbstractFulltextSeachService.this.crawlLogDeleteSql.deleteAll(tenantId, AbstractFulltextSeachService.this.rdb);
                this.getStatement().executeUpdate(sql);
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    protected Map<String, String> generateCrawlPropInfo(MetaEntity meta) {
        HashMap<String, String> crawlPropertyNameMap = new HashMap<String, String>();
        List<MetaProperty> declaredProperties = meta.getDeclaredPropertyList();
        List<MetaProperty> superProperties = null;
        int refCnt = 1;
        int expCnt = 1;
        int columnIndex = 1;
        String columnStr = "V_";
        for (String crawlId : meta.getCrawlPropertyId()) {
            String propertyName;
            boolean match = false;
            for (MetaProperty metaProperty : declaredProperties) {
                propertyName = metaProperty.getName();
                if (!metaProperty.getId().equals(crawlId)) continue;
                if (metaProperty instanceof MetaReferenceProperty) {
                    crawlPropertyNameMap.put(propertyName + ".name", "R_" + refCnt);
                    ++refCnt;
                } else {
                    MetaPrimitiveProperty metaPrimitiveProperty = (MetaPrimitiveProperty)metaProperty;
                    if (metaPrimitiveProperty.getType() instanceof ExpressionType) {
                        crawlPropertyNameMap.put(propertyName, "E_" + expCnt);
                        ++expCnt;
                    } else {
                        Object columnName = "";
                        if (metaProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore || metaProperty.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                            columnName = columnStr + columnIndex;
                            ++columnIndex;
                        }
                        if ("OBJ_ID".equals(columnName) || "OBJ_VER".equals(columnName)) {
                            columnName = "OPT_" + (String)columnName;
                        }
                        crawlPropertyNameMap.put(propertyName, (String)columnName);
                    }
                }
                match = true;
                break;
            }
            if (!match) {
                EntityService ehs;
                EntityHandler superEntity;
                if (superProperties == null && (superEntity = (ehs = ServiceRegistry.getRegistry().getService(EntityService.class)).getRuntimeById(meta.getInheritedEntityMetaDataId())) != null) {
                    superProperties = superEntity.getMetaData().getDeclaredPropertyList();
                }
                if (superProperties != null) {
                    for (MetaProperty metaProperty : superProperties) {
                        if (!metaProperty.getId().equals(crawlId)) continue;
                        propertyName = metaProperty.getName();
                        if (!(metaProperty instanceof MetaReferenceProperty)) {
                            Object columnName = "";
                            if (metaProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore || metaProperty.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                                columnName = columnStr + columnIndex;
                                ++columnIndex;
                            }
                            if ("OBJ_ID".equals(columnName) || "OBJ_VER".equals(columnName)) {
                                columnName = "OPT_" + (String)columnName;
                            }
                            crawlPropertyNameMap.put(propertyName, (String)columnName);
                        }
                        match = true;
                        break;
                    }
                }
            }
            if (match) continue;
            logger.warn("### DefinitionName [" + meta.getName() + "] ###\r\ncrawlId " + crawlId + " is not found.");
        }
        return crawlPropertyNameMap;
    }

    public static class CrawlTimestampDto {
        private String objDefId;
        private String objDefVer;
        private Timestamp upDate;

        public String getObjDefId() {
            return this.objDefId;
        }

        public void setObjDefId(String objDefId) {
            this.objDefId = objDefId;
        }

        public String getObjDefVer() {
            return this.objDefVer;
        }

        public void setObjDefVer(String objDefVer) {
            this.objDefVer = objDefVer;
        }

        public Timestamp getUpDate() {
            return this.upDate;
        }

        public void setUpDate(Timestamp upDate) {
            this.upDate = upDate;
        }
    }

    public static class RestoreDto {
        private String id;
        private int tenantId;
        private String objDefId;
        private String objId;
        private Long objVer;
        private DeleteLogTable.Status status;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(int tenantId) {
            this.tenantId = tenantId;
        }

        public String getObjDefId() {
            return this.objDefId;
        }

        public void setObjDefId(String objDefId) {
            this.objDefId = objDefId;
        }

        public String getObjId() {
            return this.objId;
        }

        public void setObjId(String objId) {
            this.objId = objId;
        }

        public Long getObjVer() {
            return this.objVer;
        }

        public void setObjVer(Long objVer) {
            this.objVer = objVer;
        }

        public DeleteLogTable.Status getStatus() {
            return this.status;
        }

        public void setStatus(DeleteLogTable.Status status) {
            this.status = status;
        }
    }
}

