/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformerSupport;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchResult;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchService;
import org.iplass.mtp.spi.ServiceRegistry;

public class FulltextSearchQueryASTTransformer
extends ASTTransformerSupport {
    private String defName;
    private String searchText;
    private final Map<String, Map<String, List<String>>> highlightMap = new HashMap<String, Map<String, List<String>>>();

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public Map<String, Map<String, List<String>>> getHighlightMap() {
        return this.highlightMap;
    }

    public FulltextSearchQueryASTTransformer(String defName) {
        this.defName = defName;
    }

    @Override
    public ASTNode visit(Contains contains) {
        this.searchText = contains.getSearchText();
        FulltextSearchService fulltextSearchService = ServiceRegistry.getRegistry().getService(FulltextSearchService.class);
        List<FulltextSearchResult> resultList = fulltextSearchService.execFulltextSearch(this.defName, this.searchText);
        if (resultList.size() < 1) {
            return new In("oid", "");
        }
        Object[] oidArr = new Object[resultList.size()];
        int cnt = 0;
        for (FulltextSearchResult result : resultList) {
            String oid = result.getOid();
            this.highlightMap.put(oid, result.getHighlight());
            oidArr[cnt] = oid;
            ++cnt;
        }
        return new In("oid", oidArr);
    }
}

