/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.impl.fulltextsearch.lucene.AnalyzerSetting;
import org.iplass.mtp.impl.fulltextsearch.lucene.LuceneFulltextSearchService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JapaneseAnalyzerSetting
implements AnalyzerSetting {
    private static Logger logger = LoggerFactory.getLogger(JapaneseAnalyzerSetting.class);
    private String className = JapaneseAnalyzer.class.getName();
    private JapaneseTokenizer.Mode mode = JapaneseTokenizer.Mode.SEARCH;
    private String userDictionary;
    private String stopwords;
    private String stoptags;
    private Analyzer analyzer;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getUserDictionary() {
        return this.userDictionary;
    }

    public void setUserDictionary(String userDictionary) {
        this.userDictionary = userDictionary;
    }

    public String getStopwords() {
        return this.stopwords;
    }

    public void setStopwords(String stopwords) {
        this.stopwords = stopwords;
    }

    public String getStoptags() {
        return this.stoptags;
    }

    public void setStoptags(String stoptags) {
        this.stoptags = stoptags;
    }

    public JapaneseTokenizer.Mode getMode() {
        return this.mode;
    }

    public void setMode(JapaneseTokenizer.Mode mode) {
        this.mode = mode;
    }

    @Override
    public Analyzer getAnalyzer(int tenantId, String entityDefName) {
        return this.analyzer;
    }

    @Override
    public void inited(LuceneFulltextSearchService service, Config config) {
        if (service.isUseFulltextSearch()) {
            try {
                Class<?> clazz;
                block7: {
                    clazz = Class.forName(this.className);
                    if (JapaneseAnalyzer.class.isAssignableFrom(clazz)) {
                        UserDictionary userDict = this.createUserDictionary();
                        CharArraySet sw = JapaneseAnalyzerSettingInternalAnalyzer.createStopwords(this.stopwords);
                        Set<String> st = JapaneseAnalyzerSettingInternalAnalyzer.createStopTags(this.stoptags);
                        try {
                            Constructor<?> c = clazz.getConstructor(UserDictionary.class, JapaneseTokenizer.Mode.class, CharArraySet.class, Set.class);
                            this.analyzer = (Analyzer)c.newInstance(userDict, this.mode, sw, st);
                        }
                        catch (NoSuchMethodException e) {
                            if (!logger.isDebugEnabled()) break block7;
                            logger.debug(this.className + " has no constructor of signature (UserDictionary, Mode, CharArraySet, Set), so use default constructor.");
                        }
                    }
                }
                if (this.analyzer == null) {
                    this.analyzer = (Analyzer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                throw new FulltextSearchRuntimeException("can not instantiate Analyzer class: " + this.className, e1);
            }
        }
    }

    private UserDictionary createUserDictionary() {
        UserDictionary userDictionary;
        if (this.userDictionary == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(JapaneseAnalyzerSettingInternalAnalyzer.class.getResourceAsStream(this.userDictionary), Charset.forName("utf-8"));
        try {
            userDictionary = UserDictionary.open((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FulltextSearchRuntimeException("User Dictionary can not read. : " + this.userDictionary, e);
            }
        }
        reader.close();
        return userDictionary;
    }

    @Override
    public void destroyed() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    private static abstract class JapaneseAnalyzerSettingInternalAnalyzer
    extends StopwordAnalyzerBase {
        private static final int CHAR_ARRAY_SET_INITIAL_CAPACITY = 16;
        private static final String WORDS_COMMENT = "#";

        private JapaneseAnalyzerSettingInternalAnalyzer() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static CharArraySet createStopwords(String stopwords) {
            if (StringUtil.isEmpty(stopwords)) {
                return JapaneseAnalyzer.getDefaultStopSet();
            }
            try (InputStream input = JapaneseAnalyzerSettingInternalAnalyzer.class.getResourceAsStream(stopwords);){
                CharArraySet charArraySet;
                try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                    charArraySet = WordlistLoader.getWordSet((Reader)reader, (String)WORDS_COMMENT, (CharArraySet)new CharArraySet(16, true));
                }
                return charArraySet;
            }
            catch (IOException e) {
                logger.warn("Unable to load stopword set : " + stopwords + ",  So use default one.");
                return JapaneseAnalyzer.getDefaultStopSet();
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static Set<String> createStopTags(String stoptags) {
            if (StringUtil.isEmpty(stoptags)) {
                return JapaneseAnalyzer.getDefaultStopTags();
            }
            try (InputStream input = JapaneseAnalyzerSettingInternalAnalyzer.class.getResourceAsStream(stoptags);){
                HashSet<String> hashSet;
                try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                    CharArraySet tagset = WordlistLoader.getWordSet((Reader)reader, (String)WORDS_COMMENT, (CharArraySet)new CharArraySet(16, false));
                    HashSet<String> tags = new HashSet<String>();
                    for (Object element : tagset) {
                        char[] chars = (char[])element;
                        tags.add(new String(chars));
                    }
                    hashSet = tags;
                }
                return hashSet;
            }
            catch (IOException e) {
                logger.warn("Unable to load stoptag set : " + stoptags + ", So use default one.");
                return JapaneseAnalyzer.getDefaultStopTags();
            }
        }
    }
}

