/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch.lucene;

import java.io.IOException;
import java.util.List;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.impl.cache.CacheController;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.LoadingAdapter;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.event.CacheCreateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheInvalidateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheRemoveEvent;
import org.iplass.mtp.impl.cache.store.event.CacheUpdateEvent;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.fulltextsearch.lucene.IndexDir;
import org.iplass.mtp.impl.fulltextsearch.lucene.LuceneFulltextSearchService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneFulltextSearchContext {
    private static Logger logger = LoggerFactory.getLogger(LuceneFulltextSearchContext.class);
    public static final String CACHE_NAMESPACE = "mtp.fulltextsearch.lucene.dir";
    private LuceneFulltextSearchService service;
    private CacheController<String, IndexDir> dirs;
    private int tenantId;

    public LuceneFulltextSearchContext(LuceneFulltextSearchService service, TenantContext tc) {
        this.service = service;
        this.tenantId = tc.getTenantId();
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        this.dirs = new CacheController<String, IndexDir>(cs.getCache("mtp.fulltextsearch.lucene.dir/" + this.tenantId), false, 0, new IndexDirLoadingAdapter(), false, true);
        this.dirs.getStore().addCacheEventListenner(new IndexCacheEventListener());
    }

    public IndexDir getIndexDir(String defId) {
        return this.dirs.get(defId);
    }

    private void closeDir(CacheEntry ce) {
        IndexDir dir;
        if (ce != null && (dir = (IndexDir)ce.getValue()) != null) {
            try {
                dir.close();
            }
            catch (IOException e) {
                logger.warn("can not close Lucene index directory:" + dir.getDefId() + ", maybe resource leak...", (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.dirs.maintenance(cc -> {
            this.dirs.clearAll();
            this.dirs.invalidateCacheStore();
        });
    }

    public void refreshAll() {
        this.dirs.maintenance(cc -> {
            Throwable ex = null;
            for (Object key : cc.getStore().keySet()) {
                CacheEntry ce = cc.getStore().get(key);
                if (ce.getValue() == null) continue;
                try {
                    ((IndexDir)ce.getValue()).refresh();
                }
                catch (Exception e) {
                    if (ex == null) {
                        ex = new FulltextSearchRuntimeException("Error occurred when refreshing searcher.", e);
                        continue;
                    }
                    ex.addSuppressed(e);
                }
            }
            if (ex != null) {
                throw ex;
            }
        });
    }

    private class IndexDirLoadingAdapter
    implements LoadingAdapter<String, IndexDir> {
        private IndexDirLoadingAdapter() {
        }

        @Override
        public IndexDir load(String key) {
            return LuceneFulltextSearchContext.this.service.newIndexDir(LuceneFulltextSearchContext.this.tenantId, key);
        }

        @Override
        public List<IndexDir> loadByIndex(int indexType, Object indexVal) {
            return null;
        }

        @Override
        public long getVersion(IndexDir value) {
            return 0L;
        }

        @Override
        public Object getIndexVal(int indexType, IndexDir value) {
            return null;
        }

        @Override
        public String getKey(IndexDir val) {
            return val.getDefId();
        }
    }

    private class IndexCacheEventListener
    implements CacheEventListener {
        private IndexCacheEventListener() {
        }

        @Override
        public void updated(CacheUpdateEvent event) {
        }

        @Override
        public void removed(CacheRemoveEvent event) {
            LuceneFulltextSearchContext.this.closeDir(event.getEntry());
        }

        @Override
        public void invalidated(CacheInvalidateEvent event) {
            LuceneFulltextSearchContext.this.closeDir(event.getEntry());
        }

        @Override
        public void created(CacheCreateEvent event) {
        }
    }
}

