/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.fulltextsearch.AbstractFulltextSearchService;
import org.iplass.mtp.impl.fulltextsearch.IndexedEntity;
import org.iplass.mtp.impl.fulltextsearch.lucene.AnalyzerSetting;
import org.iplass.mtp.impl.fulltextsearch.lucene.IndexDir;
import org.iplass.mtp.impl.fulltextsearch.lucene.IndexWriterSetting;
import org.iplass.mtp.impl.fulltextsearch.lucene.JapaneseAnalyzerSetting;
import org.iplass.mtp.impl.fulltextsearch.lucene.LuceneFulltextSearchContext;
import org.iplass.mtp.impl.fulltextsearch.lucene.SimpleIndexDir;
import org.iplass.mtp.impl.fulltextsearch.sql.DeleteLogTable;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneFulltextSearchService
extends AbstractFulltextSearchService {
    private static Logger logger = LoggerFactory.getLogger(LuceneFulltextSearchService.class);
    private AnalyzerSetting analyzerSetting;
    private QueryParser.Operator defaultOperator;
    private long searcherAutoRefreshTimeMinutes = -1L;
    private Timer timer;
    private IndexWriterSetting indexWriterSetting;
    private String directory;
    private Class<?> luceneFSDirectoryClass;
    private long maxChunkSizeMB;
    private ConcurrentHashMap<Integer, LuceneFulltextSearchContext> contexts;

    IndexDir newIndexDir(int tenantId, String defId) {
        EntityService entityService = ServiceRegistry.getRegistry().getService(EntityService.class);
        EntityHandler eh = entityService.getRuntimeById(defId);
        if (eh == null || !eh.getMetaData().isCrawl()) {
            logger.debug("defId:" + defId + " not foud or disable crawl.");
            return null;
        }
        Path dirPath = Paths.get(this.directory, String.valueOf(tenantId), defId);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            logger.debug(dirPath.toString() + " not exists.so create new directory");
        }
        Object dir = null;
        try {
            dir = this.luceneFSDirectoryClass != null ? (MMapDirectory.class.equals(this.luceneFSDirectoryClass) ? new MMapDirectory(dirPath, this.maxChunkSizeMB) : (FSDirectory)this.luceneFSDirectoryClass.getConstructor(Path.class).newInstance(dirPath)) : FSDirectory.open((Path)dirPath);
            return new SimpleIndexDir(tenantId, defId, (FSDirectory)dir, this.searcherAutoRefreshTimeMinutes, this.timer);
        }
        catch (Exception e) {
            if (dir != null) {
                try {
                    dir.close();
                }
                catch (IOException e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new FulltextSearchRuntimeException("Failed to initialize the Lucene index directory:" + tenantId + "/" + defId, e);
        }
    }

    private boolean existsDir(int tenantId, String defId) {
        Path dirPath = Paths.get(this.directory, String.valueOf(tenantId), defId);
        return Files.exists(dirPath, new LinkOption[0]);
    }

    @Override
    public void initTenantContext(TenantContext tenantContext) {
        if (this.isUseFulltextSearch()) {
            this.contexts.computeIfAbsent(tenantContext.getTenantId(), key -> new LuceneFulltextSearchContext(this, tenantContext));
        }
    }

    @Override
    public void destroyTenantContext(TenantContext tenantContext) {
        LuceneFulltextSearchContext fsc;
        if (this.isUseFulltextSearch() && (fsc = this.contexts.remove(tenantContext.getTenantId())) != null) {
            fsc.destroy();
        }
    }

    @Override
    public void destroy() {
        if (this.isUseFulltextSearch()) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            for (LuceneFulltextSearchContext fsc : this.contexts.values()) {
                fsc.destroy();
            }
        }
    }

    @Override
    public void init(Config config) {
        super.init(config);
        if (this.isUseFulltextSearch()) {
            this.contexts = new ConcurrentHashMap();
            this.directory = config.getValue("directory");
            if (this.directory == null) {
                throw new NullPointerException("directory is null");
            }
            String className = config.getValue("luceneFSDirectory");
            if (className != null) {
                try {
                    this.luceneFSDirectoryClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceConfigrationException(e);
                }
                if (!FSDirectory.class.isAssignableFrom(this.luceneFSDirectoryClass)) {
                    throw new ServiceConfigrationException(className + " is not sub class of FSDirectory");
                }
            }
            this.maxChunkSizeMB = config.getValue("luceneFSDirectoryMaxChunkSizeMB", Long.TYPE, MMapDirectory.DEFAULT_MAX_CHUNK_SIZE);
            this.searcherAutoRefreshTimeMinutes = config.getValue("searcherAutoRefreshTimeMinutes", Long.TYPE, -1L);
            if (this.searcherAutoRefreshTimeMinutes > 0L) {
                this.timer = new Timer("Searcher refresh timer", true);
            }
            this.indexWriterSetting = config.getValue("indexWriterSetting", IndexWriterSetting.class, new IndexWriterSetting());
            this.analyzerSetting = config.getValueWithSupplier("analyzerSetting", AnalyzerSetting.class, () -> new JapaneseAnalyzerSetting());
        }
        this.defaultOperator = config.getValue("defaultOperator", QueryParser.Operator.class);
    }

    @Override
    public void execRefresh() {
        LuceneFulltextSearchContext fsc;
        if (this.isUseFulltextSearch() && (fsc = this.contexts.get(ExecuteContext.getCurrentContext().getClientTenantId())) != null) {
            fsc.refreshAll();
        }
    }

    @Override
    protected void createIndexData(int tenantId, String defName) {
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(DefinitionService.getInstance().getPath(EntityDefinition.class, defName));
        if (entry == null) {
            logger.warn(defName + " is not found.");
            return;
        }
        MetaEntity meta = (MetaEntity)entry.getMetaData();
        if (!meta.isCrawl()) {
            logger.debug(defName + " is not crawl target entity.");
            return;
        }
        logger.info("start crawl " + defName);
        if (meta.getCrawlPropertyId() == null || meta.getCrawlPropertyId().isEmpty()) {
            logger.warn(defName + " have no crawl target property. so skip crawl.");
            logger.info("end crawl " + defName);
            return;
        }
        AuthContext.doPrivileged(() -> {
            Map<String, String> crawlPropertyNameMap = this.generateCrawlPropMap(meta);
            Select select = new Select();
            select.add(new EntityField("oid"), new EntityField("version"));
            crawlPropertyNameMap.keySet().forEach(propName -> select.add((Object)new EntityField((String)propName)));
            String objDefId = meta.getId();
            int objDefVer = entry.getVersion();
            Timestamp fromDBTime = this.getLastCrawlTimestamp(objDefId, objDefVer);
            Timestamp lastUpdate = null;
            if (fromDBTime != null) {
                lastUpdate = new Timestamp(fromDBTime.getTime() - TimeUnit.MINUTES.toMillis(this.redundantTimeMinutes));
            }
            Timestamp now = InternalDateUtil.getNow();
            Timestamp delTargetDatetime = new Timestamp(now.getTime() - TimeUnit.MINUTES.toMillis(this.redundantTimeMinutes));
            try (EntityIndexWriter writer = new EntityIndexWriter(tenantId, meta);){
                try {
                    org.iplass.mtp.entity.query.Query query;
                    List<AbstractFulltextSearchService.RestoreDto> dtoList = this.getRestoreIndexData(objDefId, delTargetDatetime);
                    dtoList.stream().filter(dto -> dto.getStatus().equals((Object)DeleteLogTable.Status.DELETE)).forEach(dto -> {
                        try {
                            Term term = new Term("id", dto.getId());
                            writer.deleteDocuments(term);
                        }
                        catch (IOException e) {
                            throw new FulltextSearchRuntimeException("Cant create index cause " + e.toString(), e);
                        }
                    });
                    ArrayList oidList = new ArrayList();
                    dtoList.stream().filter(dto -> dto.getStatus().equals((Object)DeleteLogTable.Status.RESTORE)).forEach(dto -> {
                        oidList.add(new Literal(dto.getObjId()));
                        if (oidList.size() == 1000) {
                            org.iplass.mtp.entity.query.Query query = new org.iplass.mtp.entity.query.Query();
                            query.setSelect(select);
                            query.from(defName);
                            In in = new In((ValueExpression)new EntityField("oid"), new ArrayList<ValueExpression>(oidList));
                            query.where(in);
                            this.createIndexByQuery(query, tenantId, objDefId, writer, crawlPropertyNameMap);
                            oidList.clear();
                        }
                    });
                    if (oidList.size() > 0) {
                        query = new org.iplass.mtp.entity.query.Query();
                        query.setSelect(select);
                        query.from(defName);
                        In in = new In((ValueExpression)new EntityField("oid"), new ArrayList<ValueExpression>(oidList));
                        query.where(in);
                        this.createIndexByQuery(query, tenantId, objDefId, writer, crawlPropertyNameMap);
                    }
                    query = new org.iplass.mtp.entity.query.Query();
                    query.setSelect(select);
                    query.from(defName);
                    if (lastUpdate != null) {
                        query.where(new GreaterEqual("updateDate", lastUpdate));
                    }
                    this.createIndexByQuery(query, tenantId, objDefId, writer, crawlPropertyNameMap);
                    this.removeDeleteLog(objDefId, delTargetDatetime);
                    if (lastUpdate == null) {
                        this.insertCrawlLog(objDefId, objDefVer, now);
                    } else {
                        this.updateCrawlLog(objDefId, objDefVer, now);
                    }
                    writer.commit();
                    logger.info("end crawl " + defName);
                }
                catch (IOException | RuntimeException e) {
                    writer.rollback();
                    throw e;
                }
            }
            catch (IOException e) {
                throw new FulltextSearchRuntimeException("Cant create index cause " + e.toString(), e);
            }
        });
    }

    private boolean createIndexByQuery(org.iplass.mtp.entity.query.Query query, int tenantId, String objDefId, EntityIndexWriter writer, Map<String, String> crawlPropertyNameMap) {
        EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
        if (logger.isDebugEnabled()) {
            logger.debug("### EQL : " + query.toString() + "###");
        }
        boolean[] isIndexed = new boolean[]{false};
        em.searchEntity(query, entity -> {
            isIndexed[0] = true;
            String id = tenantId + "_" + objDefId + "_" + entity.getOid() + "_" + entity.getVersion();
            try {
                Term term = new Term("id", id);
                writer.deleteDocuments(term);
                Document doc = new Document();
                doc.add((IndexableField)new StringField("id", id, Field.Store.YES));
                doc.add((IndexableField)new StringField("tenant_id", Integer.toString(tenantId), Field.Store.YES));
                doc.add((IndexableField)new StringField("def_name", entity.getDefinitionName(), Field.Store.YES));
                doc.add((IndexableField)new StringField("OBJ_ID", entity.getOid(), Field.Store.YES));
                if (entity.getVersion() != null) {
                    doc.add((IndexableField)new StringField("OBJ_VER", Long.toString(entity.getVersion()), Field.Store.YES));
                }
                for (Map.Entry e : crawlPropertyNameMap.entrySet()) {
                    String propName = (String)e.getKey();
                    Object val = entity.getValue(propName);
                    if (val == null) continue;
                    String fieldName = (String)e.getValue();
                    if (val.getClass().isArray()) {
                        Object[] valArray = (Object[])val;
                        for (int i = 0; i < valArray.length; ++i) {
                            doc.add((IndexableField)this.toField(fieldName, valArray[i]));
                        }
                        continue;
                    }
                    doc.add((IndexableField)this.toField(fieldName, val));
                }
                writer.addDocument((Iterable<? extends IndexableField>)doc);
            }
            catch (IOException e) {
                throw new FulltextSearchRuntimeException("Exception occured on index creating process.", e);
            }
            return true;
        });
        return isIndexed[0];
    }

    private Field toField(String fieldName, Object val) throws IOException {
        return new TextField(fieldName, this.toValue(val), Field.Store.NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<IndexedEntity> fulltextSearchImpl(Integer tenantId, EntityHandler eh, String fulltext, int limit) {
        if (eh == null) return Collections.emptyList();
        if (StringUtil.isEmpty(fulltext)) {
            return Collections.emptyList();
        }
        IndexDir dir = this.contexts.get(tenantId).getIndexDir(eh.getMetaData().getId());
        if (dir == null) {
            return Collections.emptyList();
        }
        if (eh.getMetaData().getCrawlPropertyId() == null) return Collections.emptyList();
        if (eh.getMetaData().getCrawlPropertyId().isEmpty()) {
            return Collections.emptyList();
        }
        String[] fields = eh.getMetaData().getCrawlPropertyId().toArray(new String[eh.getMetaData().getCrawlPropertyId().size()]);
        MultiFieldQueryParser qp = new MultiFieldQueryParser(fields, this.analyzerSetting.getAnalyzer(tenantId, eh.getMetaData().getName()));
        qp.setDefaultOperator(this.defaultOperator);
        IndexSearcher searcher = null;
        try {
            searcher = (IndexSearcher)dir.getSearcherManager().acquire();
            if (limit < 0) {
                limit = searcher.getIndexReader().numDocs();
            }
            Query fulltextQuery = qp.parse(fulltext);
            if (logger.isDebugEnabled()) {
                logger.debug("lucene query : " + String.valueOf(fulltextQuery));
            }
            TopDocs docs = searcher.search(fulltextQuery, limit);
            ScoreDoc[] hits = docs.scoreDocs;
            ArrayList<IndexedEntity> result = new ArrayList<IndexedEntity>(hits.length);
            StoredFields storedFields = searcher.storedFields();
            for (ScoreDoc hit : hits) {
                Document doc = storedFields.document(hit.doc);
                String oid = doc.get("OBJ_ID");
                result.add(new IndexedEntity(eh.getMetaData().getName(), oid, hit.score));
            }
            ArrayList<IndexedEntity> arrayList = result;
            return arrayList;
        }
        catch (IOException | ParseException e) {
            throw new FulltextSearchRuntimeException("Fulltext search(lucene) error.:" + e.toString(), e);
        }
        finally {
            if (searcher != null) {
                try {
                    try {
                        dir.getSearcherManager().release((Object)searcher);
                        searcher = null;
                    }
                    catch (IOException e) {
                        logger.error("Error occurred when IndexSearcher releasing, maybe resource leak", (Throwable)e);
                        searcher = null;
                    }
                }
                catch (Throwable throwable) {
                    searcher = null;
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void deleteAllIndex() {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        EntityService es = ServiceRegistry.getRegistry().getService(EntityService.class);
        List<MetaDataEntryInfo> defList = es.list();
        for (MetaDataEntryInfo def : defList) {
            if (!this.existsDir(tenantId, def.getId())) continue;
            EntityHandler eh = es.getRuntimeById(def.getId());
            IndexDir dir = this.contexts.get(tenantId).getIndexDir(eh.getMetaData().getId());
            if (dir == null) continue;
            try (IndexWriter writer = new IndexWriter((Directory)dir.getDirectory(), new IndexWriterConfig(this.analyzerSetting.getAnalyzer(tenantId, eh.getMetaData().getName())));){
                Term term = new Term("tenant_id", String.valueOf(tenantId));
                writer.deleteDocuments(new Term[]{term});
            }
            catch (IOException e) {
                throw new FulltextSearchRuntimeException("Index error occurred when deleting.", e);
            }
        }
        this.removeAllCrawlLog();
        this.removeAllDeleteLog();
    }

    private class EntityIndexWriter
    implements Closeable {
        private IndexWriter writer;
        private int tenantId;
        private MetaEntity metaEntity;
        private int counter;

        public EntityIndexWriter(int tenantId, MetaEntity metaEntity) throws IOException {
            this.tenantId = tenantId;
            this.metaEntity = metaEntity;
            this.createWriter();
        }

        @Override
        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }

        public final long commit() throws IOException {
            if (this.writer != null) {
                return this.writer.commit();
            }
            return -1L;
        }

        public void rollback() throws IOException {
            if (this.writer != null) {
                this.writer.rollback();
            }
        }

        public long deleteDocuments(Term ... terms) throws IOException {
            if (this.writer != null) {
                this.checkLimit();
            } else {
                this.createWriter();
            }
            long sequence = this.writer.deleteDocuments(terms);
            ++this.counter;
            return sequence;
        }

        public long addDocument(Iterable<? extends IndexableField> doc) throws IOException {
            if (this.writer != null) {
                this.checkLimit();
            } else {
                this.createWriter();
            }
            long sequence = this.writer.addDocument(doc);
            ++this.counter;
            return sequence;
        }

        private void checkLimit() throws IOException {
            if (LuceneFulltextSearchService.this.indexWriterSetting.getCommitLimit() > 0 && this.counter >= LuceneFulltextSearchService.this.indexWriterSetting.getCommitLimit()) {
                this.recreateWriter();
            }
        }

        private void recreateWriter() throws IOException {
            this.commit();
            this.close();
            this.counter = 0;
            logger.info("commit lucene index writer. because the operation count has exceeded the upper limit value(" + LuceneFulltextSearchService.this.indexWriterSetting.getCommitLimit() + ").");
            this.createWriter();
        }

        private void createWriter() throws IOException {
            IndexWriterConfig config = LuceneFulltextSearchService.this.indexWriterSetting.createIndexWriterConfig(LuceneFulltextSearchService.this.analyzerSetting.getAnalyzer(this.tenantId, this.metaEntity.getName()));
            IndexDir dir = LuceneFulltextSearchService.this.contexts.get(this.tenantId).getIndexDir(this.metaEntity.getId());
            this.writer = new IndexWriter((Directory)dir.getDirectory(), config);
        }
    }

    private class FulltextSearchDto {
        private String defName;
        private List<String> oidList;
        private Map<String, Float> score;

        public FulltextSearchDto(LuceneFulltextSearchService luceneFulltextSearchService, String defName) {
            this.defName = defName;
        }

        public String getDefName() {
            return this.defName;
        }

        public void setDefName(String defName) {
            this.defName = defName;
        }

        public List<String> getOidList() {
            return this.oidList;
        }

        public void setOidList(List<String> oidList) {
            this.oidList = oidList;
        }

        public void addOid(String oid) {
            if (this.oidList == null) {
                this.oidList = new ArrayList<String>();
            }
            this.oidList.add(oid);
        }

        public Map<String, Float> getScore() {
            return this.score;
        }

        public void setScore(Map<String, Float> score) {
            this.score = score;
        }

        public void addScore(String oid, Float score) {
            if (this.score == null) {
                this.score = new HashMap<String, Float>();
            }
            this.score.put(oid, score);
        }
    }
}

