/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.impl.fulltextsearch.parser.BinaryReferenceParseException;
import org.iplass.mtp.impl.fulltextsearch.parser.BinaryReferenceParser;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractBinaryReferenceParser
implements BinaryReferenceParser {
    private static Logger logger = LoggerFactory.getLogger(AbstractBinaryReferenceParser.class);
    private List<String> continuableExceptions = Collections.emptyList();
    private Set<MediaType> supportTypes;

    @Override
    public BinaryReferenceParser getParser(BinaryReference br) {
        MediaType brType = MediaType.parse((String)br.getType());
        if (brType != null) {
            if (this.getSupportTypes().contains(brType)) {
                return this;
            }
            if (this.getCustomSupportTypes() != null && this.getCustomSupportTypes().contains(brType)) {
                return this;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parse(BinaryReference br, int writeLimit) {
        EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
        try (InputStream is = em.getInputStream(br);){
            Parser parser = this.parserInstance();
            BodyContentHandler handler = new BodyContentHandler(writeLimit);
            Metadata metadata = new Metadata();
            try {
                parser.parse(is, (ContentHandler)handler, metadata, new ParseContext());
            }
            catch (SAXException e) {
                if (!e.getClass().getName().equals("org.apache.tika.sax.WriteOutContentHandler$WriteLimitReachedException")) throw new BinaryReferenceParseException("Exception occured on index creating process.", e);
                logger.warn(br.getName() + " contained more than " + writeLimit + " characters. so cut " + writeLimit + " characters.");
            }
            catch (TikaException e) {
                throw new BinaryReferenceParseException("Exception occured on index creating process.", e);
            }
            catch (Throwable e) {
                if (e instanceof NoClassDefFoundError) throw new BinaryReferenceParseException("Exception occured on index creating process.", e);
                if (!this.continuableExceptions.contains(e.getClass().getName())) throw e;
                throw new BinaryReferenceParseException("Exception occured on index creating process.", e);
            }
            String content = handler.toString();
            logger.trace(br.getName() + " tika content is [" + content + "]");
            if (StringUtil.isNotEmpty(content)) {
                String string2 = br.getName() + " " + br.getType() + " " + content;
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new FulltextSearchRuntimeException("Exception occured on index creating process.", e);
        }
    }

    public void setContinuableExceptions(String[] continuableExceptions) {
        this.continuableExceptions = Arrays.asList(continuableExceptions);
    }

    public String[] getContinuableExceptions() {
        return this.continuableExceptions.toArray(new String[this.continuableExceptions.size()]);
    }

    protected Set<MediaType> getCustomSupportTypes() {
        return null;
    }

    protected Set<MediaType> getSupportTypes() {
        if (this.supportTypes == null) {
            this.supportTypes = this.parserInstance().getSupportedTypes(new ParseContext());
        }
        return this.supportTypes;
    }

    protected abstract Parser parserInstance();
}

