/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.http;

import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackoff {
    private static final Logger logger = LoggerFactory.getLogger(ExponentialBackoff.class);
    public static ExponentialBackoff NO_RETRY = new ExponentialBackoff(){

        @Override
        public void execute(BooleanSupplier func) throws InterruptedException {
            func.getAsBoolean();
        }
    };
    private long retryIntervalMillis = 500L;
    private double randomizationFactor = 0.5;
    private double multiplier = 1.5;
    private long maxIntervalMillis = 60000L;
    private long maxElapsedTimeMillis = 300000L;

    public long getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public void setRetryIntervalMillis(long retryIntervalMillis) {
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public double getRandomizationFactor() {
        return this.randomizationFactor;
    }

    public void setRandomizationFactor(double randomizationFactor) {
        this.randomizationFactor = randomizationFactor;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public long getMaxIntervalMillis() {
        return this.maxIntervalMillis;
    }

    public void setMaxIntervalMillis(long maxIntervalMillis) {
        this.maxIntervalMillis = maxIntervalMillis;
    }

    public long getMaxElapsedTimeMillis() {
        return this.maxElapsedTimeMillis;
    }

    public void setMaxElapsedTimeMillis(long maxElapsedTimeMillis) {
        this.maxElapsedTimeMillis = maxElapsedTimeMillis;
    }

    public void execute(BooleanSupplier func) throws InterruptedException {
        long endTime = System.currentTimeMillis() + this.maxElapsedTimeMillis;
        long intervalTime = this.retryIntervalMillis;
        while (System.currentTimeMillis() < endTime) {
            if (func.getAsBoolean()) {
                return;
            }
            long sleepTime = this.randomized(intervalTime);
            if (logger.isDebugEnabled()) {
                logger.debug("execution failed. retry after " + sleepTime + "ms.");
            }
            Thread.sleep(sleepTime);
            if ((intervalTime = (long)((double)intervalTime * this.multiplier)) <= this.maxIntervalMillis) continue;
            intervalTime = this.maxIntervalMillis;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("execution failed and retry over.");
        }
    }

    private long randomized(long l) {
        double rv = this.randomizationFactor * (Math.random() * 2.0 - 1.0);
        return (long)((double)l * (1.0 + rv));
    }
}

