/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.http;

import java.io.IOException;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.iplass.mtp.impl.http.HttpClientBuilderFactory;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceInitListener;

public class HttpClientConfig
implements ServiceInitListener<Service> {
    public static final Integer DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final Integer DEFAULT_SO_TIMEOUT = 30000;
    public static final Integer DEFAULT_POOLING_MAX_TOTAL = 20;
    public static final Integer DEFAULT_POOLING_DEFAULT_MAX_PER_ROUTE = 2;
    private Integer connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private Integer soTimeout = DEFAULT_SO_TIMEOUT;
    private String proxyHost;
    private Integer proxyPort;
    private Integer poolingMaxTotal = DEFAULT_POOLING_MAX_TOTAL;
    private Integer poolingDefaultMaxPerRoute = DEFAULT_POOLING_DEFAULT_MAX_PER_ROUTE;
    private Integer poolingTimeToLive;
    private HttpClientBuilderFactory httpClientBuilderFactory;
    private CloseableHttpClient instance;

    public HttpClientBuilderFactory getHttpClientBuilderFactory() {
        return this.httpClientBuilderFactory;
    }

    public void setHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        this.httpClientBuilderFactory = httpClientBuilderFactory;
    }

    public Integer getPoolingTimeToLive() {
        return this.poolingTimeToLive;
    }

    public void setPoolingTimeToLive(Integer poolingTimeToLive) {
        this.poolingTimeToLive = poolingTimeToLive;
    }

    public Integer getPoolingMaxTotal() {
        return this.poolingMaxTotal;
    }

    public void setPoolingMaxTotal(Integer poolingMaxTotal) {
        this.poolingMaxTotal = poolingMaxTotal;
    }

    public Integer getPoolingDefaultMaxPerRoute() {
        return this.poolingDefaultMaxPerRoute;
    }

    public void setPoolingDefaultMaxPerRoute(Integer poolingDefaultMaxPerRoute) {
        this.poolingDefaultMaxPerRoute = poolingDefaultMaxPerRoute;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public CloseableHttpClient getInstance() {
        return this.instance;
    }

    @Override
    public void inited(Service service, Config config) {
        if (this.httpClientBuilderFactory != null) {
            this.instance = this.httpClientBuilderFactory.create(service, config, this).build();
        } else {
            ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.connectionTimeout.intValue())).setSocketTimeout(Timeout.ofMilliseconds((long)this.soTimeout.intValue()));
            if (this.poolingTimeToLive != null) {
                connectionConfigBuilder.setTimeToLive(TimeValue.ofMilliseconds((long)this.poolingTimeToLive.intValue()));
            }
            PoolingHttpClientConnectionManagerBuilder poolingConnectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfigBuilder.build());
            if (this.poolingMaxTotal != null) {
                poolingConnectionManagerBuilder.setMaxConnTotal(this.poolingMaxTotal.intValue());
            }
            if (this.poolingDefaultMaxPerRoute != null) {
                poolingConnectionManagerBuilder.setMaxConnPerRoute(this.poolingDefaultMaxPerRoute.intValue());
            }
            HttpClientBuilder httpClinetBuilder = HttpClientBuilder.create();
            if (this.proxyHost != null) {
                httpClinetBuilder.setProxy(new HttpHost(this.proxyHost, this.proxyPort.intValue()));
            }
            this.instance = httpClinetBuilder.setConnectionManager((HttpClientConnectionManager)poolingConnectionManagerBuilder.build()).build();
        }
    }

    @Override
    public void destroyed() {
        try {
            this.instance.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.instance = null;
    }
}

