/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.iplass.mtp.impl.http.ExponentialBackoff;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpInvoker {
    private static Logger logger = LoggerFactory.getLogger(SimpleHttpInvoker.class);
    private HttpClientConfig httpClientConfig;
    private ExponentialBackoff exponentialBackoff;
    private Charset contentCharset = StandardCharsets.UTF_8;

    public SimpleHttpInvoker(HttpClientConfig httpClientConfig, ExponentialBackoff exponentialBackoff) {
        this.httpClientConfig = httpClientConfig;
        this.exponentialBackoff = exponentialBackoff == null ? ExponentialBackoff.NO_RETRY : exponentialBackoff;
    }

    private final boolean noRetry(Response res) {
        return true;
    }

    public Response call(HttpUriRequest request) {
        return this.call(request, this::noRetry);
    }

    public Response call(HttpUriRequest request, Predicate<Response> stopRetryCondition) {
        Response response = new Response();
        long start = System.currentTimeMillis();
        try {
            this.exponentialBackoff.execute(() -> {
                try {
                    this.httpClientConfig.getInstance().execute((ClassicHttpRequest)request, resp -> {
                        HttpEntity entity = resp.getEntity();
                        try {
                            response.status = resp.getCode();
                            response.content = null == entity ? null : EntityUtils.toString((HttpEntity)entity, (Charset)this.contentCharset);
                            Object var4_4 = null;
                            return var4_4;
                        }
                        finally {
                            EntityUtils.consume((HttpEntity)entity);
                        }
                    });
                }
                catch (IOException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("error while http call: {}", (Object)request.toString(), (Object)e);
                    }
                    if (response.exception != null) {
                        e.addSuppressed(response.exception);
                    }
                    response.exception = e;
                    response.status = 0;
                    response.content = null;
                }
                finally {
                    if (request instanceof HttpUriRequestBase) {
                        HttpUriRequestBase httpUriRequestBase = (HttpUriRequestBase)request;
                        httpUriRequestBase.reset();
                    }
                }
                return stopRetryCondition.test(response);
            });
        }
        catch (InterruptedException e) {
            if (response.exception != null) {
                e.addSuppressed(response.exception);
            }
            response.exception = e;
            response.status = 0;
            response.content = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("call external web resource: {} {}ms", (Object)request, (Object)(System.currentTimeMillis() - start));
        }
        return response;
    }

    public static class Response {
        public String content;
        public int status;
        public Exception exception;
    }
}

