/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.i18n;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.iplass.mtp.impl.i18n.EnableLanguages;
import org.iplass.mtp.impl.i18n.LanguageFonts;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;

public class I18nService
implements Service {
    private List<EnableLanguages> enableLanguages;
    private Map<String, String> enableLanguagesMap;
    private Map<String, String> otherLanguagesMap;
    private Locale locale;
    private TimeZone timezone;
    private List<LocaleFormat> localeFormat;
    private Map<String, LocaleFormat> localeFormatMap;
    private LocaleFormat defaultLocaleFormat;
    private List<LanguageFonts> languageFonts;
    private List<String> genericFontFamilyList;

    public Locale selectLangLocale(Locale tenantLocale) {
        String langTag = tenantLocale.toLanguageTag();
        if ((langTag = this.toValidLanguageTag(langTag)) == null) {
            return Locale.ENGLISH;
        }
        return Locale.forLanguageTag(langTag);
    }

    public String toValidLanguageTag(String lang) {
        String lowerLang = lang.toLowerCase();
        String ret = this.otherLanguagesMap.get(lowerLang);
        while (ret == null) {
            int i = lowerLang.indexOf(45);
            if (i <= 0) {
                return null;
            }
            lowerLang = lowerLang.substring(0, i);
            ret = this.otherLanguagesMap.get(lowerLang);
        }
        return ret;
    }

    public Map<String, String> getEnableLanguagesMap() {
        return this.enableLanguagesMap;
    }

    public void setEnableLanguagesMap(Map<String, String> enableLanguagesMap) {
        this.enableLanguagesMap = enableLanguagesMap;
    }

    public List<EnableLanguages> getEnableLanguages() {
        return this.enableLanguages;
    }

    public void setEnableLanguages(List<EnableLanguages> enableLanguages) {
        this.enableLanguages = enableLanguages;
    }

    public List<String> getGenericFontFamilyList() {
        return this.genericFontFamilyList;
    }

    public void setGenericFontFamilyList(List<String> genericFontFamilyList) {
        this.genericFontFamilyList = genericFontFamilyList;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public List<LocaleFormat> getLocaleFormat() {
        return this.localeFormat;
    }

    public void setLocaleFormat(List<LocaleFormat> localeFormat) {
        this.localeFormat = localeFormat;
    }

    public Map<String, LocaleFormat> getLocaleFormatMap() {
        return this.localeFormatMap;
    }

    public void setLocaleFormatMap(Map<String, LocaleFormat> localeFormatMap) {
        this.localeFormatMap = localeFormatMap;
    }

    public LocaleFormat getDefaultLocaleFormat() {
        return this.defaultLocaleFormat;
    }

    public void setDefaultLocaleFormat(LocaleFormat defaultLocaleFormat) {
        this.defaultLocaleFormat = defaultLocaleFormat;
    }

    public List<LanguageFonts> getLanguageFonts() {
        return this.languageFonts;
    }

    public void setLanguageFonts(List<LanguageFonts> languageFonts) {
        this.languageFonts = languageFonts;
    }

    public LocaleFormat getLocaleFormat(String locale) {
        if (this.localeFormatMap.get(locale) == null) {
            return this.getDefaultLocaleFormat();
        }
        return this.localeFormatMap.get(locale);
    }

    public LocaleFormat getLocaleFormat(String locale, Tenant tenant) {
        LocaleFormat format = this.getLocaleFormat(locale);
        if (tenant == null) {
            return format;
        }
        TenantI18nInfo i18n = tenant.getTenantConfig(TenantI18nInfo.class);
        if (StringUtil.isNotEmpty(i18n.getOutputDateFormat()) || StringUtil.isNotEmpty(i18n.getBrowserInputDateFormat())) {
            LocaleFormat customFormat = format.clone();
            if (StringUtil.isNotEmpty(i18n.getOutputDateFormat())) {
                customFormat.setOutputDateFormat(i18n.getOutputDateFormat());
            }
            if (StringUtil.isNotEmpty(i18n.getBrowserInputDateFormat())) {
                customFormat.setBrowserInputDateFormat(i18n.getBrowserInputDateFormat());
            }
            return customFormat;
        }
        return format;
    }

    @Override
    public void init(Config config) {
        if (config.getBeans("enableLanguages") != null) {
            this.enableLanguages = config.getBeans("enableLanguages");
            this.enableLanguagesMap = new LinkedHashMap<String, String>();
            this.otherLanguagesMap = new HashMap<String, String>();
            for (EnableLanguages e : this.enableLanguages) {
                this.enableLanguagesMap.put(e.getLanguageKey(), e.getLanguageName());
                this.otherLanguagesMap.put(e.getLanguageKey().toLowerCase(), e.getLanguageKey());
                if (e.getOtherLanguageKey() == null) continue;
                for (String ol : e.getOtherLanguageKey()) {
                    this.otherLanguagesMap.put(ol.toLowerCase(), e.getLanguageKey());
                }
            }
        }
        this.locale = Locale.getDefault();
        this.timezone = TimeZone.getDefault();
        this.defaultLocaleFormat = (LocaleFormat)config.getBean("defaultLocaleFormat");
        if (config.getBeans("localeFormat") != null) {
            this.localeFormat = config.getBeans("localeFormat");
            this.localeFormatMap = new LinkedHashMap<String, LocaleFormat>();
            for (LocaleFormat lf : this.localeFormat) {
                List<String> localeList = lf.getLocale();
                for (String l : localeList) {
                    this.localeFormatMap.put(l, lf);
                }
            }
        }
        this.languageFonts = config.getBeans("languageFonts");
        this.genericFontFamilyList = config.getValues("genericFontFamilyList");
    }

    @Override
    public void destroy() {
    }
}

