/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;

public final class I18nUtil {
    public static String stringDef(String defaultString, List<LocalizedStringDefinition> localizedStringList) {
        String lang;
        String multilingualString = defaultString;
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        if (ec.getCurrentTenant().getTenantConfig(TenantI18nInfo.class).isUseMultilingual() && (lang = ec.getLanguage()) != null && localizedStringList != null) {
            for (LocalizedStringDefinition lsd : localizedStringList) {
                if (!lang.equals(lsd.getLocaleName())) continue;
                multilingualString = lsd.getStringValue();
                break;
            }
        }
        return multilingualString;
    }

    public static String stringMeta(String defaultString, List<MetaLocalizedString> localizedStringList) {
        String lang;
        String multilingualString = defaultString;
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        if (ec.getCurrentTenant().getTenantConfig(TenantI18nInfo.class).isUseMultilingual() && (lang = ec.getLanguage()) != null && localizedStringList != null) {
            for (MetaLocalizedString mls : localizedStringList) {
                if (!lang.equals(mls.getLocaleName())) continue;
                multilingualString = mls.getStringValue();
                break;
            }
        }
        return multilingualString;
    }

    public static Locale getLocale(String localeStr) {
        String[] tmp = localeStr.split("_");
        Locale locale = null;
        if (tmp.length == 1) {
            locale = new Locale(tmp[0]);
        } else if (tmp.length == 2) {
            locale = new Locale(tmp[0], tmp[1]);
        } else if (tmp.length == 3) {
            locale = new Locale(tmp[0], tmp[1], tmp[2]);
        }
        return locale;
    }

    public static String getLocaleString(Locale locale) {
        Object localeName = locale.getLanguage();
        if (StringUtil.isNotEmpty(locale.getCountry())) {
            localeName = (String)localeName + "_" + locale.getCountry();
            if (StringUtil.isNotEmpty(locale.getVariant())) {
                localeName = (String)localeName + "_" + locale.getVariant();
            }
        }
        return localeName;
    }

    public static List<MetaLocalizedString> toMeta(List<LocalizedStringDefinition> def) {
        if (def == null) {
            return null;
        }
        ArrayList<MetaLocalizedString> meta = new ArrayList<MetaLocalizedString>();
        for (LocalizedStringDefinition ed : def) {
            MetaLocalizedString mls = new MetaLocalizedString();
            mls.setLocaleName(ed.getLocaleName());
            mls.setStringValue(ed.getStringValue());
            meta.add(mls);
        }
        return meta;
    }

    public static List<LocalizedStringDefinition> toDef(List<MetaLocalizedString> meta) {
        if (meta == null) {
            return null;
        }
        ArrayList<LocalizedStringDefinition> def = new ArrayList<LocalizedStringDefinition>();
        for (MetaLocalizedString m : meta) {
            def.add(m.currentConfig());
        }
        return def;
    }

    public static String getLanguageIfUseMultilingual() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        if (ec.getCurrentTenant().getTenantConfig(TenantI18nInfo.class).isUseMultilingual()) {
            return ec.getLanguage();
        }
        return null;
    }
}

