/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbandonedStreamDetector {
    private static Logger logger = LoggerFactory.getLogger(AbandonedStreamDetector.class);
    private boolean detectAbandonedStream;
    private boolean logAbandoned;
    private Cleaner cleaner;

    AbandonedStreamDetector(boolean detectAbandonedStream, boolean logAbandoned) {
        this.detectAbandonedStream = detectAbandonedStream;
        this.logAbandoned = logAbandoned;
        if (detectAbandonedStream) {
            this.cleaner = Cleaner.create();
        }
    }

    InputStream registerOrNot(InputStream in) {
        if (this.detectAbandonedStream) {
            return new DetectAbandonedInputStream(this, in);
        }
        return in;
    }

    OutputStream registerOrNot(OutputStream out) {
        if (this.detectAbandonedStream) {
            return new DetectAbandonedOutputStream(this, out);
        }
        return out;
    }

    private class DetectAbandonedInputStream
    extends FilterInputStream {
        State state;
        Cleaner.Cleanable cleanable;

        public DetectAbandonedInputStream(AbandonedStreamDetector abandonedStreamDetector, InputStream in) {
            super(in);
            this.state = new State(in, abandonedStreamDetector.logAbandoned ? new Exception("StackTrace where LobStream was created") : null);
            this.cleanable = abandonedStreamDetector.cleaner.register(this, this.state);
        }

        @Override
        public void close() throws IOException {
            this.state.callCorrectly = true;
            try {
                this.cleanable.clean();
            }
            catch (WrapException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw (RuntimeException)e.getCause();
            }
        }
    }

    private class DetectAbandonedOutputStream
    extends FilterOutputStream {
        State state;
        Cleaner.Cleanable cleanable;

        public DetectAbandonedOutputStream(AbandonedStreamDetector abandonedStreamDetector, OutputStream out) {
            super(out);
            this.state = new State(out, abandonedStreamDetector.logAbandoned ? new Exception("StackTrace where LobStream was created") : null);
            this.cleanable = abandonedStreamDetector.cleaner.register(this, this.state);
        }

        @Override
        public void close() throws IOException {
            this.state.callCorrectly = true;
            try {
                this.cleanable.clean();
            }
            catch (WrapException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw (RuntimeException)e.getCause();
            }
        }
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = -1586276797291855842L;

        WrapException(Exception cause) {
            super(cause);
        }
    }

    private static class State
    implements Runnable {
        private Closeable stream;
        private Exception createdStackTrace;
        private volatile boolean callCorrectly;

        State(Closeable stream, Exception createdStackTrace) {
            this.stream = stream;
            this.createdStackTrace = createdStackTrace;
        }

        @Override
        public void run() {
            try {
                this.stream.close();
            }
            catch (IOException | RuntimeException e) {
                if (this.callCorrectly) {
                    throw new WrapException(e);
                }
                logger.error("Error on closing stream", (Throwable)e);
            }
            finally {
                if (!this.callCorrectly) {
                    if (this.createdStackTrace == null) {
                        logger.warn("Abandoned Stream Detected: " + String.valueOf(this.stream));
                    } else {
                        logger.warn("Abandoned Stream Detected: " + String.valueOf(this.stream), (Throwable)this.createdStackTrace);
                    }
                }
            }
        }
    }
}

