/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobStoreService;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.lob.sql.BlobDeleteSql;
import org.iplass.mtp.impl.lob.sql.BlobInsertSql;
import org.iplass.mtp.impl.lob.sql.BlobLobDataIdUpdateSql;
import org.iplass.mtp.impl.lob.sql.BlobRecycleBinSql;
import org.iplass.mtp.impl.lob.sql.BlobSearchSql;
import org.iplass.mtp.impl.lob.sql.BlobStatUpdateSql;
import org.iplass.mtp.impl.lob.sql.LobStoreDeleteSql;
import org.iplass.mtp.impl.lob.sql.LobStoreInsertSql;
import org.iplass.mtp.impl.lob.sql.LobStoreSearchSql;
import org.iplass.mtp.impl.lob.sql.LobStoreUpdateSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class LobDao {
    private static final String COUNTER_SERVICE_INC_KEY = "lobid";
    private RdbAdapter rdb;
    private CounterService counterService;
    private LobStoreService lobStoreService;
    private BlobInsertSql blobInsertSql;
    private BlobSearchSql searchSql;
    private BlobDeleteSql deleteSql;
    private BlobStatUpdateSql statUpdateSql;
    private BlobLobDataIdUpdateSql lobDataIdUpdateSql;
    private BlobRecycleBinSql recycleBinSql;
    private LobStoreDeleteSql lobStoreDelSql;
    private LobStoreInsertSql lobStoreInsertSql;
    private LobStoreSearchSql lobStoreSearchSql;
    private LobStoreUpdateSql lobStoreUpdateSql;

    public void init(RdbAdapter rdb, CounterService counterService, LobStoreService lobStoreService) {
        this.rdb = rdb;
        this.counterService = counterService;
        this.lobStoreService = lobStoreService;
        this.blobInsertSql = rdb.getUpdateSqlCreator(BlobInsertSql.class);
        this.searchSql = rdb.getQuerySqlCreator(BlobSearchSql.class);
        this.deleteSql = rdb.getUpdateSqlCreator(BlobDeleteSql.class);
        this.statUpdateSql = rdb.getUpdateSqlCreator(BlobStatUpdateSql.class);
        this.lobDataIdUpdateSql = rdb.getUpdateSqlCreator(BlobLobDataIdUpdateSql.class);
        this.recycleBinSql = rdb.getUpdateSqlCreator(BlobRecycleBinSql.class);
        this.lobStoreDelSql = rdb.getUpdateSqlCreator(LobStoreDeleteSql.class);
        this.lobStoreInsertSql = rdb.getUpdateSqlCreator(LobStoreInsertSql.class);
        this.lobStoreSearchSql = rdb.getQuerySqlCreator(LobStoreSearchSql.class);
        this.lobStoreUpdateSql = rdb.getUpdateSqlCreator(LobStoreUpdateSql.class);
    }

    public Lob create(int tenantId, String name, String type, String defId, String propId, String oid, Long version, LobStore lobStore) {
        return this.createInternal(tenantId, name, type, false, null, defId, propId, oid, version, -1L, lobStore);
    }

    public Lob crateTemporary(int tenantId, String name, String type, String sessionId, LobStore lobStore) {
        return this.createInternal(tenantId, name, type, true, sessionId, null, null, null, null, -1L, lobStore);
    }

    public Lob create(Lob toCreate, LobStore lobStore) {
        return this.createInternal(toCreate.getTenantId(), toCreate.getName(), toCreate.getType(), toCreate.getSessionId() != null, toCreate.getSessionId(), toCreate.getDefinitionId(), toCreate.getPropertyId(), toCreate.getOid(), toCreate.getVersion(), toCreate.getLobDataId(), lobStore);
    }

    private Lob createInternal(final int tenantId, final String name, final String type, final boolean isTemporary, final String sessionId, final String defId, final String propId, final String oid, final Long version, final long lobDataId, LobStore lobStore) {
        final long lobId = this.nextLobId(tenantId);
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                String updateSql = LobDao.this.blobInsertSql.toSql(tenantId, lobId, name, type, isTemporary, sessionId, defId, propId, oid, version, lobDataId, LobDao.this.rdb);
                return this.getStatement().executeUpdate(updateSql);
            }
        };
        exec.execute(this.rdb, true);
        String status = null;
        status = isTemporary ? " " : "V";
        Lob bin = new Lob(tenantId, lobId, name, type, defId, propId, oid, version, sessionId, status, lobDataId, lobStore, this.lobStoreService);
        return bin;
    }

    public long nextLobId(int tenantId) {
        return this.counterService.increment(tenantId, COUNTER_SERVICE_INC_KEY, 1L);
    }

    public Lob load(int tenantId, long lobId, LobStore lobStore) {
        return this.loadInternal(tenantId, lobId, null, null, null, null, null, false, lobStore);
    }

    public Lob loadWithLock(int tenantId, long lobId, String sessionId, String defId, String propId, String oid, Long version, LobStore lobStore) {
        return this.loadInternal(tenantId, lobId, sessionId, defId, propId, oid, version, true, lobStore);
    }

    private Lob loadInternal(final int tenantId, final long lobId, final String sessionId, final String defId, final String propId, final String oid, final Long version, final boolean withLock, final LobStore lobStore) {
        SqlExecuter<Lob> exec = new SqlExecuter<Lob>(){

            @Override
            public Lob logic() throws SQLException {
                ResultSet rs = this.getStatement().executeQuery(LobDao.this.searchSql.toSql(LobDao.this.rdb, tenantId, lobId, sessionId, defId, propId, oid, version, withLock));
                Lob bin = null;
                if (rs.next()) {
                    bin = LobDao.this.searchSql.toBinaryData(rs, lobStore, LobDao.this.lobStoreService);
                }
                rs.close();
                return bin;
            }
        };
        return (Lob)exec.execute(this.rdb, true);
    }

    public Lob[] search(final int clientTenantId, final long[] lobId, final LobStore lobStore) {
        SqlExecuter<Lob[]> exec = new SqlExecuter<Lob[]>(){

            @Override
            public Lob[] logic() throws SQLException {
                ResultSet rs = this.getStatement().executeQuery(LobDao.this.searchSql.toSearchSql(LobDao.this.rdb, clientTenantId, lobId));
                ArrayList<Lob> res = new ArrayList<Lob>();
                while (rs.next()) {
                    Lob bin = LobDao.this.searchSql.toBinaryData(rs, lobStore, LobDao.this.lobStoreService);
                    res.add(bin);
                }
                rs.close();
                return res.toArray(new Lob[res.size()]);
            }
        };
        return (Lob[])exec.execute(this.rdb, true);
    }

    public void remove(final int tenantId, final long lobId) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.deleteSql.toSql(tenantId, lobId, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public void remove(final int tenantId, final String defId, final String propId, final String[] oid) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.deleteSql.toSql(tenantId, defId, propId, oid, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public boolean markPersistence(final int tenantId, final long lobId, final String defId, final String propId, final String oid, final Long version) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                int count = this.getStatement().executeUpdate(LobDao.this.statUpdateSql.toSql(tenantId, lobId, defId, propId, oid, version, LobDao.this.rdb));
                return count > 0;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    public boolean updateBinaryDataInfo(final int tenantId, final long lobId, final String name, final String type) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                int count = this.getStatement().executeUpdate(LobDao.this.statUpdateSql.toInfoUpdateSql(tenantId, lobId, name, type, LobDao.this.rdb));
                return count > 0;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    public void cleanTemporary() {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.deleteSql.toSqlForCleanTemporary(LobDao.this.rdb, -1));
            }
        };
        exec.execute(this.rdb, true);
    }

    public List<Long> getLobIdByRbid(final int tenantId, final long rbid) {
        SqlExecuter<List<Long>> exec = new SqlExecuter<List<Long>>(){

            @Override
            public List<Long> logic() throws SQLException {
                ArrayList<Long> res = new ArrayList<Long>();
                try (ResultSet rs = this.getStatement().executeQuery(LobDao.this.recycleBinSql.searchSql(LobDao.this.rdb, tenantId, rbid));){
                    while (rs.next()) {
                        res.add(rs.getLong("LOB_ID"));
                    }
                }
                return res;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public void removeFromRecycleBin(final int tenantId, final long rbid) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.recycleBinSql.deleteByRbIdSql(tenantId, rbid, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public void markToRecycleBin(final int tenantId, final long lobId, final long rbid) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.recycleBinSql.insertSql(tenantId, rbid, lobId, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public void markRestoreFromRecycleBin(final int tenantId, final long rbid) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.recycleBinSql.deleteByRbIdSql(tenantId, rbid, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public boolean refCountUp(final int tenantId, final long lobDataId, final int countUpValue) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                PreparedStatement stmt = this.getPreparedStatement(LobDao.this.lobStoreUpdateSql.toPrepareSqlForRefCountUpdate(LobDao.this.rdb));
                stmt.setInt(1, countUpValue);
                stmt.setInt(2, tenantId);
                stmt.setLong(3, lobDataId);
                return stmt.executeUpdate() == 1;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    public long nextLobDataId(int tenantId) {
        return this.nextLobId(tenantId);
    }

    public boolean updateLobDataId(final int tenantId, final long lobId, final long prevLobDataId, final long newLobDataId) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                int count = this.getStatement().executeUpdate(LobDao.this.lobDataIdUpdateSql.toSql(tenantId, lobId, prevLobDataId, newLobDataId, LobDao.this.rdb));
                return count > 0;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    public void initLobData(final int tenantId, final long lobDataId, final Long size) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.lobStoreInsertSql.toSql(tenantId, lobDataId, size, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public List<long[]> getLobIdListForCleanTemporary(final int day, final int tenantId) {
        SqlExecuter<List<long[]>> exec = new SqlExecuter<List<long[]>>(){

            @Override
            public List<long[]> logic() throws SQLException {
                ArrayList<long[]> res = new ArrayList<long[]>();
                try (ResultSet rs = this.getStatement().executeQuery(LobDao.this.searchSql.toSqlForCleanTemporary(LobDao.this.rdb, day, tenantId));){
                    while (rs.next()) {
                        res.add(new long[]{rs.getLong("LOB_ID"), rs.getLong("LOB_DATA_ID")});
                    }
                }
                return res;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public List<Long> getLobDataIdListForClean(final int day, final int tenantId) {
        SqlExecuter<List<Long>> exec = new SqlExecuter<List<Long>>(){

            @Override
            public List<Long> logic() throws SQLException {
                ArrayList<Long> res = new ArrayList<Long>();
                try (ResultSet rs = this.getStatement().executeQuery(LobDao.this.lobStoreSearchSql.toSqlForClean(tenantId, day, LobDao.this.rdb));){
                    while (rs.next()) {
                        res.add(rs.getLong("LOB_DATA_ID"));
                    }
                }
                return res;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public void removeData(final int tenantId, final long lobDataId) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            @Override
            public Integer logic() throws SQLException {
                return this.getStatement().executeUpdate(LobDao.this.lobStoreDelSql.toSql(tenantId, lobDataId, LobDao.this.rdb));
            }
        };
        exec.execute(this.rdb, true);
    }

    public List<Long> getLobIdByDefId(final int tenantId, final String defId) {
        SqlExecuter<List<Long>> exec = new SqlExecuter<List<Long>>(){

            @Override
            public List<Long> logic() throws SQLException {
                ArrayList<Long> res = new ArrayList<Long>();
                try (ResultSet rs = this.getStatement().executeQuery(LobDao.this.searchSql.toSqlByDefId(LobDao.this.rdb, tenantId, defId));){
                    while (rs.next()) {
                        res.add(rs.getLong("LOB_ID"));
                    }
                }
                return res;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public List<Long> getLobIdForDefrag(final int tenantId, final EntityHandler eh) {
        final ArrayList<String> binPropertyIds = new ArrayList<String>();
        for (PropertyHandler ph : eh.getDeclaredPropertyList()) {
            PrimitivePropertyHandler pph;
            if (!(ph instanceof PrimitivePropertyHandler) || (pph = (PrimitivePropertyHandler)ph).getEnumType() != PropertyDefinitionType.BINARY && pph.getEnumType() != PropertyDefinitionType.LONGTEXT) continue;
            binPropertyIds.add(pph.getId());
        }
        SqlExecuter<List<Long>> exec = new SqlExecuter<List<Long>>(){

            @Override
            public List<Long> logic() throws SQLException {
                ArrayList<Long> res = new ArrayList<Long>();
                try (ResultSet rs = this.getStatement().executeQuery(LobDao.this.searchSql.toSqlForDefrag(LobDao.this.rdb, tenantId, eh.getMetaData().getId(), binPropertyIds));){
                    while (rs.next()) {
                        res.add(rs.getLong("LOB_ID"));
                    }
                }
                return res;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public List<Long> getLobDataIdListForLobStoreSizeUpdate(final int tenantId) {
        SqlExecuter<List<Long>> exec = new SqlExecuter<List<Long>>(){

            @Override
            public List<Long> logic() throws SQLException {
                ArrayList<Long> res = new ArrayList<Long>();
                try (ResultSet rs = this.getStatement().executeQuery(LobDao.this.lobStoreSearchSql.toSqlForSizeUpdate(tenantId, LobDao.this.rdb));){
                    while (rs.next()) {
                        res.add(rs.getLong("LOB_DATA_ID"));
                    }
                }
                return res;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public boolean updateLobStoreSize(final int tenantId, final long lobDataId, final long size) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                PreparedStatement stmt = this.getPreparedStatement(LobDao.this.lobStoreUpdateSql.toPrepareSqlForLobSizeUpdate(LobDao.this.rdb));
                stmt.setLong(1, size);
                stmt.setInt(2, tenantId);
                stmt.setLong(3, lobDataId);
                return stmt.executeUpdate() == 1;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }
}

