/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.impl.command.RequestContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.logging.LogCondition;
import org.iplass.mtp.impl.logging.MdcAdapter;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConditionRuntime {
    private static Logger logger = LoggerFactory.getLogger(LogConditionRuntime.class);
    private LogCondition condition;
    private Object concreteServiceRuntime;
    private Script conditionScript;
    private Pattern loggerNamePattern;
    private ConcurrentHashMap<String, Boolean> loggerNameCache;

    public LogConditionRuntime(LogCondition condition, Object concreteServiceRuntime, TenantContext tc, int index) {
        this.condition = condition;
        this.concreteServiceRuntime = concreteServiceRuntime;
        if (condition != null) {
            if (condition.getCondition() != null) {
                this.conditionScript = tc.getScriptEngine().createScript(condition.getCondition(), "LogCondition_" + index);
            }
            if (condition.getLoggerNamePattern() != null) {
                this.loggerNamePattern = Pattern.compile(condition.getLoggerNamePattern());
                this.loggerNameCache = new ConcurrentHashMap();
            }
        }
    }

    public boolean hasConditionScript() {
        return this.conditionScript != null;
    }

    public boolean isConditionMatch(ExecuteContext ec) {
        if (this.condition == null) {
            return false;
        }
        if (this.condition.getCondition() == null) {
            return true;
        }
        ScriptContext sc = ec.getTenantContext().getScriptEngine().newScriptContext();
        sc.setAttribute(LogCondition.BIND_NAME_MDC, new MdcAdapter());
        sc.setAttribute(LogCondition.BIND_NAME_REQUEST, RequestContextHolder.getCurrent());
        sc.setAttribute(LogCondition.BIND_NAME_AUTH_CONTEXT, AuthContext.getCurrentContext());
        try {
            Boolean ret = (Boolean)this.conditionScript.eval(sc);
            if (ret == null) {
                return false;
            }
            return ret;
        }
        catch (RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("LogCondition script eval failed:" + this.condition.getCondition(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isTargetLogger(String loggerName) {
        if (this.loggerNamePattern == null) {
            return true;
        }
        Boolean ret = this.loggerNameCache.get(loggerName);
        if (ret == null) {
            ret = this.loggerNamePattern.matcher(loggerName).matches() ? Boolean.TRUE : Boolean.FALSE;
            this.loggerNameCache.put(loggerName, ret);
        }
        return ret;
    }

    public LogCondition getCondition() {
        if (this.condition == null) {
            return null;
        }
        return this.condition.copy();
    }

    public Object getConcreteServiceRuntime() {
        return this.concreteServiceRuntime;
    }
}

