/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantResource;
import org.iplass.mtp.impl.logging.LogCondition;
import org.iplass.mtp.impl.logging.LogConditionRuntime;
import org.iplass.mtp.impl.logging.LoggingService;
import org.iplass.mtp.spi.ServiceRegistry;

public class LoggingContext
implements TenantResource {
    private static final String LOG_CONDITION = "mtp.loggingContext.logCondition";
    private static LogConditionRuntime NULL_LOG_CONDITION = new LogConditionRuntime(null, null, null, 0);
    private TenantContext tc;
    private volatile List<LogConditionRuntime> list;

    public List<LogCondition> list() {
        List<LogConditionRuntime> cList = this.list;
        if (cList == null) {
            return Collections.emptyList();
        }
        ArrayList<LogCondition> ret = new ArrayList<LogCondition>();
        for (LogConditionRuntime lc : cList) {
            ret.add(lc.getCondition());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(List<LogCondition> logConditions) {
        LoggingContext loggingContext = this;
        synchronized (loggingContext) {
            LoggingService loggingService = ServiceRegistry.getRegistry().getService(LoggingService.class);
            ArrayList<LogConditionRuntime> newList = null;
            if (logConditions != null) {
                long maxExpires = loggingService.getMaxAgeSecondsOfLogCondition() != null && loggingService.getMaxAgeSecondsOfLogCondition() >= 0L ? System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(loggingService.getMaxAgeSecondsOfLogCondition()) : Long.MAX_VALUE;
                newList = new ArrayList<LogConditionRuntime>();
                for (int i = 0; i < logConditions.size(); ++i) {
                    LogCondition lc = logConditions.get(i);
                    if (lc.getExpiresAt() > maxExpires) {
                        throw new SystemException("The max age of log condition is " + loggingService.getMaxAgeSecondsOfLogCondition() + " seconds.");
                    }
                    newList.add(new LogConditionRuntime(lc, loggingService.createRuntime(lc), this.tc, i));
                }
            }
            this.list = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LoggingContext loggingContext = this;
        synchronized (loggingContext) {
            this.list = null;
        }
    }

    public void resetMatched(ExecuteContext ec) {
        ec.removeAttribute(LOG_CONDITION);
    }

    public LogConditionRuntime getMatched(ExecuteContext ec) {
        LogConditionRuntime cache = (LogConditionRuntime)ec.getAttribute(LOG_CONDITION);
        if (cache != null) {
            if (NULL_LOG_CONDITION == cache) {
                return null;
            }
            return cache;
        }
        List<LogConditionRuntime> cList = this.list;
        if (cList != null) {
            long time = System.currentTimeMillis();
            for (LogConditionRuntime lc : cList) {
                if (lc.getCondition().getExpiresAt() <= time || !lc.isConditionMatch(ec)) continue;
                ec.setAttribute(LOG_CONDITION, lc, false);
                return lc;
            }
        }
        ec.setAttribute(LOG_CONDITION, NULL_LOG_CONDITION, false);
        return null;
    }

    @Override
    public void init(TenantContext tenantContext) {
        this.tc = tenantContext;
    }

    @Override
    public void destory() {
        this.tc = null;
        this.list = null;
    }
}

