/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.logging.LogConditionRuntime;
import org.iplass.mtp.impl.logging.LoggingContext;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class LogConditionTurboFilter
extends TurboFilter {
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        String tenantIdString = MDC.get((String)"tenant");
        if (tenantIdString == null) {
            return FilterReply.NEUTRAL;
        }
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        LoggingContext lc = ec.getTenantContext().getResource(LoggingContext.class);
        if (lc == null) {
            return FilterReply.NEUTRAL;
        }
        LogConditionRuntime cond = lc.getMatched(ec);
        if (cond == null) {
            return FilterReply.NEUTRAL;
        }
        Level levelCond = (Level)cond.getConcreteServiceRuntime();
        if (levelCond == null) {
            return FilterReply.NEUTRAL;
        }
        if (!cond.isTargetLogger(logger.getName())) {
            return FilterReply.NEUTRAL;
        }
        if (level.isGreaterOrEqual(levelCond)) {
            return FilterReply.ACCEPT;
        }
        return FilterReply.DENY;
    }
}

