/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.mail.smime;

import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.Strings;
import org.iplass.mtp.impl.mail.MailService;
import org.iplass.mtp.impl.mail.smime.CertificateInvalidException;
import org.iplass.mtp.impl.mail.smime.CertificateKeyPair;
import org.iplass.mtp.impl.mail.smime.SmimeCertStore;
import org.iplass.mtp.impl.mail.smime.SmimeRuntimeException;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;

public class SmimeHandler
implements ServiceInitListener<MailService> {
    private String cmsAlgorithmName = "AES128_CBC";
    private Map<String, String> signatureAlgorithmMap;
    private SmimeCertStore certStore;
    private ASN1ObjectIdentifier cmsAlgorithm;

    @Override
    public void inited(MailService service, Config config) {
        if (this.certStore != null) {
            this.certStore.inited();
        }
        if (this.signatureAlgorithmMap == null) {
            this.signatureAlgorithmMap = new HashMap<String, String>();
            this.signatureAlgorithmMap.put("RSA", "SHA256withRSA");
            this.signatureAlgorithmMap.put("DSA", "SHA256withDSA");
            this.signatureAlgorithmMap.put("EC", "SHA256withECDSA");
        }
        try {
            this.cmsAlgorithm = (ASN1ObjectIdentifier)CMSAlgorithm.class.getDeclaredField(this.cmsAlgorithmName).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new ServiceConfigrationException("cant get cmsAlgorithm: " + e.getMessage(), e);
        }
    }

    @Override
    public void destroyed() {
        if (this.certStore != null) {
            this.certStore.destroyed();
        }
    }

    public String getCmsAlgorithmName() {
        return this.cmsAlgorithmName;
    }

    public void setCmsAlgorithmName(String cmsAlgorithmName) {
        this.cmsAlgorithmName = cmsAlgorithmName;
    }

    public Map<String, String> getSignatureAlgorithmMap() {
        return this.signatureAlgorithmMap;
    }

    public void setSignatureAlgorithmMap(Map<String, String> signatureAlgorithmMap) {
        this.signatureAlgorithmMap = signatureAlgorithmMap;
    }

    public SmimeCertStore getCertStore() {
        return this.certStore;
    }

    public void setCertStore(SmimeCertStore certStore) {
        this.certStore = certStore;
    }

    public MimeMessage handle(Session session, MimeMessage message, boolean sign, String keyPass, boolean encrypt) throws MessagingException {
        if (sign) {
            message.saveChanges();
            message = this.sign(session, message, keyPass);
        }
        if (encrypt) {
            message.saveChanges();
            message = this.encrypt(session, message);
        }
        message.saveChanges();
        return message;
    }

    private MimeMessage sign(Session session, MimeMessage message, String keyPass) throws MessagingException {
        MimeMultipart mm;
        Address[] from = message.getFrom();
        CertificateKeyPair ckp = this.certStore.getCertificateKeyPair(((InternetAddress)from[0]).getAddress(), keyPass);
        if (ckp == null) {
            throw new CertificateInvalidException("Valid CertificateKeyPair not found:" + ((InternetAddress)from[0]).getAddress());
        }
        try {
            SMIMECapabilityVector capabilities = new SMIMECapabilityVector();
            capabilities.addCapability(this.cmsAlgorithm);
            ASN1EncodableVector attributes = new ASN1EncodableVector();
            attributes.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(new IssuerAndSerialNumber(new X500Name(ckp.getCertificate().getIssuerDN().getName()), ckp.getCertificate().getSerialNumber())));
            attributes.add((ASN1Encodable)new SMIMECapabilitiesAttribute(capabilities));
            SMIMESignedGenerator signer = new SMIMESignedGenerator();
            signer.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(attributes)).build(this.signatureAlgorithmMap.get(ckp.getKey().getAlgorithm()), ckp.getKey(), ckp.getCertificate()));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(ckp.getCertificate());
            JcaCertStore certs = new JcaCertStore(certList);
            signer.addCertificates((Store)certs);
            mm = signer.generate(message);
        }
        catch (CertificateEncodingException | SMIMEException | OperatorCreationException e) {
            throw new SmimeRuntimeException("can not sign to mail: " + e.getMessage(), e);
        }
        MimeMessage signedMessage = new MimeMessage(session);
        Enumeration headers = message.getAllHeaderLines();
        while (headers.hasMoreElements()) {
            signedMessage.addHeaderLine((String)headers.nextElement());
        }
        signedMessage.setContent((Multipart)mm);
        return signedMessage;
    }

    private MimeMessage encrypt(Session session, MimeMessage message) throws MessagingException {
        MimeMessage encryptedMessage;
        Address[] bcc = message.getRecipients(Message.RecipientType.BCC);
        if (bcc != null && bcc.length > 0) {
            throw new SmimeRuntimeException("currently no support of bcc recipients with encrypted message");
        }
        SMIMEEnvelopedGenerator encrypter = new SMIMEEnvelopedGenerator();
        try {
            for (Address recipient : message.getAllRecipients()) {
                X509Certificate cert = this.certStore.getCertificate(((InternetAddress)recipient).getAddress());
                if (cert == null) {
                    throw new CertificateInvalidException("Valid Certificate not found:" + ((InternetAddress)recipient).getAddress());
                }
                encrypter.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider("BC"));
            }
            MimeBodyPart encryptedPart = encrypter.generate(message, new JceCMSContentEncryptorBuilder(this.cmsAlgorithm).setProvider("BC").build());
            encryptedMessage = new MimeMessage(session);
            encryptedMessage.setContent(encryptedPart.getContent(), encryptedPart.getContentType());
        }
        catch (IOException | IllegalArgumentException | CertificateEncodingException | CMSException | SMIMEException e) {
            throw new SmimeRuntimeException("can not encrypt mail: " + e.getMessage(), e);
        }
        Enumeration headers = message.getAllHeaderLines();
        while (headers.hasMoreElements()) {
            String headerLine = (String)headers.nextElement();
            if (Strings.toLowerCase((String)headerLine).startsWith("content-")) continue;
            encryptedMessage.addHeaderLine(headerLine);
        }
        return encryptedMessage;
    }

    static {
        if (null == Security.getProvider("BC")) {
            MailcapCommandMap map = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            map.addMailcap("application/pkcs7-signature;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
            map.addMailcap("application/pkcs7-mime;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
            map.addMailcap("application/x-pkcs7-signature;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
            map.addMailcap("application/x-pkcs7-mime;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
            map.addMailcap("multipart/signed;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
            CommandMap.setDefaultCommandMap((CommandMap)map);
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

