/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.mail.template;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.mail.MailService;
import org.iplass.mtp.impl.mail.template.MetaHtmlBodyPart;
import org.iplass.mtp.impl.mail.template.MetaLocalizedMailTemplate;
import org.iplass.mtp.impl.mail.template.MetaPlainTextBodyPart;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.mail.HtmlMessage;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.template.definition.LocalizedMailTemplateDefinition;
import org.iplass.mtp.mail.template.definition.MailTemplateDefinition;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;

@XmlRootElement
public class MetaMailTemplate
extends BaseRootMetaData
implements DefinableMetaData<MailTemplateDefinition> {
    private static final long serialVersionUID = -6379003462059117529L;
    private String charset;
    private String subject;
    private MetaPlainTextBodyPart message;
    private MetaHtmlBodyPart htmlMessage;
    private List<MetaLocalizedMailTemplate> localizedMailTemplateList;
    private String from;
    private String replyTo;
    private String returnPath;
    private String fromDisplayName;
    private String replyToDisplayName;
    private String langOrUserBindingName;
    private boolean smimeSign;
    private boolean smimeEncrypt;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getFromDisplayName() {
        return this.fromDisplayName;
    }

    public void setFromDisplayName(String fromDisplayName) {
        this.fromDisplayName = fromDisplayName;
    }

    public String getReplyToDisplayName() {
        return this.replyToDisplayName;
    }

    public void setReplyToDisplayName(String replyToDisplayName) {
        this.replyToDisplayName = replyToDisplayName;
    }

    public List<MetaLocalizedMailTemplate> getLocalizedMailTemplateList() {
        return this.localizedMailTemplateList;
    }

    public void setLocalizedMailTemplateList(List<MetaLocalizedMailTemplate> localizedMailTemplateList) {
        this.localizedMailTemplateList = localizedMailTemplateList;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MetaPlainTextBodyPart getMessage() {
        return this.message;
    }

    public void setMessage(MetaPlainTextBodyPart message) {
        this.message = message;
    }

    public MetaHtmlBodyPart getHtmlMessage() {
        return this.htmlMessage;
    }

    public void setHtmlMessage(MetaHtmlBodyPart htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public String getLangOrUserBindingName() {
        return this.langOrUserBindingName;
    }

    public void setLangOrUserBindingName(String bindKey) {
        this.langOrUserBindingName = bindKey;
    }

    public boolean isSmimeSign() {
        return this.smimeSign;
    }

    public void setSmimeSign(boolean smimeSign) {
        this.smimeSign = smimeSign;
    }

    public boolean isSmimeEncrypt() {
        return this.smimeEncrypt;
    }

    public void setSmimeEncrypt(boolean smimeEncrypt) {
        this.smimeEncrypt = smimeEncrypt;
    }

    @Override
    public MailTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new MailTemplateRuntime();
    }

    @Override
    public MetaMailTemplate copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(MailTemplateDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.charset = definition.getCharset();
        this.subject = definition.getSubject();
        this.from = definition.getFrom();
        this.replyTo = definition.getReplyTo();
        this.returnPath = definition.getReturnPath();
        this.fromDisplayName = definition.getFromDisplayName();
        this.replyToDisplayName = definition.getReplyToDisplayName();
        if (definition.getPlainMessage() != null) {
            this.message = new MetaPlainTextBodyPart();
            this.message.applyConfig(definition.getPlainMessage());
        } else {
            this.message = null;
        }
        if (definition.getHtmlMessage() != null) {
            this.htmlMessage = new MetaHtmlBodyPart();
            this.htmlMessage.applyConfig(definition.getHtmlMessage());
        } else {
            this.htmlMessage = null;
        }
        if (definition.getLocalizedMailTemplateList() != null) {
            this.localizedMailTemplateList = new ArrayList<MetaLocalizedMailTemplate>();
            for (LocalizedMailTemplateDefinition ed : definition.getLocalizedMailTemplateList()) {
                MetaLocalizedMailTemplate mls = new MetaLocalizedMailTemplate();
                mls.applyConfig(ed);
                this.localizedMailTemplateList.add(mls);
            }
        } else {
            this.localizedMailTemplateList = null;
        }
        this.langOrUserBindingName = definition.getLangOrUserBindingName();
        this.smimeSign = definition.isSmimeSign();
        this.smimeEncrypt = definition.isSmimeEncrypt();
    }

    @Override
    public MailTemplateDefinition currentConfig() {
        MailTemplateDefinition definition = new MailTemplateDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setCharset(this.charset);
        definition.setSubject(this.subject);
        definition.setFrom(this.from);
        definition.setReplyTo(this.replyTo);
        definition.setReturnPath(this.returnPath);
        definition.setFromDisplayName(this.fromDisplayName);
        definition.setReplyToDisplayName(this.replyToDisplayName);
        if (this.message != null) {
            definition.setPlainMessage(this.message.currentConfig());
        }
        if (this.htmlMessage != null) {
            definition.setHtmlMessage(this.htmlMessage.currentConfig());
        }
        if (this.localizedMailTemplateList != null) {
            for (MetaLocalizedMailTemplate mls : this.localizedMailTemplateList) {
                definition.addLocalizedMailTemplate(mls.currentConfig());
            }
        }
        definition.setLangOrUserBindingName(this.langOrUserBindingName);
        definition.setSmimeSign(this.smimeSign);
        definition.setSmimeEncrypt(this.smimeEncrypt);
        return definition;
    }

    public class MailTemplateRuntime
    extends BaseMetaDataRuntime {
        private GroovyTemplate subjectTemplate;
        private GroovyTemplate messageTemplate;
        private GroovyTemplate htmlMessageTemplate;
        private Map<String, TemplateSet> templateSetMap = new HashMap<String, TemplateSet>();

        public MailTemplateRuntime() {
            try {
                ScriptEngine se;
                if (MetaMailTemplate.this.localizedMailTemplateList != null && MetaMailTemplate.this.localizedMailTemplateList.size() > 0) {
                    se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                    for (MetaLocalizedMailTemplate meta : MetaMailTemplate.this.localizedMailTemplateList) {
                        TemplateSet templateSet = new TemplateSet(this);
                        String localeName = meta.getLocaleName();
                        if (meta.getSubject() != null) {
                            templateSet.subjectTemplate = GroovyTemplateCompiler.compile(meta.getSubject(), "MailTemplate_Subject" + MetaMailTemplate.this.getName() + "__" + localeName, (GroovyScriptEngine)se);
                        }
                        if (meta.getMessage() != null && meta.getMessage().getContent() != null) {
                            templateSet.messageTemplate = GroovyTemplateCompiler.compile(meta.getMessage().getContent(), "MailTemplate_Text" + MetaMailTemplate.this.getName() + "__" + localeName, (GroovyScriptEngine)se);
                        }
                        if (meta.getHtmlMessage() != null && meta.getHtmlMessage().getContent() != null) {
                            templateSet.htmlMessageTemplate = GroovyTemplateCompiler.compile(meta.getHtmlMessage().getContent(), "MailTemplate_Html" + MetaMailTemplate.this.getName() + "__" + localeName, (GroovyScriptEngine)se);
                        }
                        if (meta.getCharset() != null) {
                            templateSet.charset = meta.getCharset();
                        }
                        this.templateSetMap.put(localeName, templateSet);
                    }
                }
                se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                if (MetaMailTemplate.this.subject != null) {
                    this.subjectTemplate = GroovyTemplateCompiler.compile(MetaMailTemplate.this.subject, "MailTemplate_Subject" + MetaMailTemplate.this.getName(), (GroovyScriptEngine)se);
                }
                if (MetaMailTemplate.this.message != null && MetaMailTemplate.this.message.getContent() != null) {
                    this.messageTemplate = GroovyTemplateCompiler.compile(MetaMailTemplate.this.message.getContent(), "MailTemplate_Text" + MetaMailTemplate.this.getName(), (GroovyScriptEngine)se);
                }
                if (MetaMailTemplate.this.htmlMessage != null && MetaMailTemplate.this.htmlMessage.getContent() != null) {
                    this.htmlMessageTemplate = GroovyTemplateCompiler.compile(MetaMailTemplate.this.htmlMessage.getContent(), "MailTemplate_Html" + MetaMailTemplate.this.getName(), (GroovyScriptEngine)se);
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        @Override
        public MetaMailTemplate getMetaData() {
            return MetaMailTemplate.this;
        }

        public Mail createMail(Map<String, Object> bindings) {
            GroovyTemplateBinding gtb;
            StringWriter sw;
            this.checkState();
            String lang = ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class).getLocale();
            if (StringUtil.isNotEmpty(MetaMailTemplate.this.langOrUserBindingName) && bindings.get(MetaMailTemplate.this.langOrUserBindingName) != null) {
                User user;
                String userLang;
                if (bindings.get(MetaMailTemplate.this.langOrUserBindingName) instanceof String) {
                    lang = (String)bindings.get(MetaMailTemplate.this.langOrUserBindingName);
                } else if (bindings.get(MetaMailTemplate.this.langOrUserBindingName) instanceof User && StringUtil.isNotEmpty(userLang = (user = (User)bindings.get(MetaMailTemplate.this.langOrUserBindingName)).getLanguage())) {
                    lang = userLang;
                }
            }
            MailService ms = ServiceRegistry.getRegistry().getService(MailService.class);
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            String _charset = MetaMailTemplate.this.charset;
            GroovyTemplate _subjectTemplate = this.subjectTemplate;
            GroovyTemplate _messageTemplate = this.messageTemplate;
            GroovyTemplate _htmlMessageTemplate = this.htmlMessageTemplate;
            if (this.templateSetMap.get(lang) != null) {
                _charset = this.templateSetMap.get((Object)lang).charset;
                _subjectTemplate = this.templateSetMap.get((Object)lang).subjectTemplate;
                _messageTemplate = this.templateSetMap.get((Object)lang).messageTemplate;
                _htmlMessageTemplate = this.templateSetMap.get((Object)lang).htmlMessageTemplate;
            }
            Mail mail = ms.createMail(ex.getCurrentTenant(), _charset);
            if (MetaMailTemplate.this.from != null && MetaMailTemplate.this.from.length() != 0) {
                mail.setFrom(MetaMailTemplate.this.from, StringUtil.isNotEmpty(MetaMailTemplate.this.fromDisplayName) ? MetaMailTemplate.this.fromDisplayName : null);
            }
            if (MetaMailTemplate.this.replyTo != null && MetaMailTemplate.this.replyTo.length() != 0) {
                mail.setReplyTo(MetaMailTemplate.this.replyTo, StringUtil.isNotEmpty(MetaMailTemplate.this.replyToDisplayName) ? MetaMailTemplate.this.replyToDisplayName : null);
            }
            if (MetaMailTemplate.this.returnPath != null && MetaMailTemplate.this.returnPath.length() != 0) {
                mail.setReturnPath(MetaMailTemplate.this.returnPath);
            }
            mail.setSmimeSign(MetaMailTemplate.this.smimeSign);
            mail.setSmimeEncript(MetaMailTemplate.this.smimeEncrypt);
            if (_subjectTemplate != null) {
                sw = new StringWriter();
                gtb = new GroovyTemplateBinding(sw);
                gtb.setVariable("mail", mail);
                if (bindings != null) {
                    for (Map.Entry<String, Object> e : bindings.entrySet()) {
                        gtb.setVariable(e.getKey(), e.getValue());
                    }
                }
                try {
                    _subjectTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                mail.setSubject(sw.toString());
            }
            if (_messageTemplate != null) {
                sw = new StringWriter();
                gtb = new GroovyTemplateBinding(sw);
                gtb.setVariable("mail", mail);
                if (bindings != null) {
                    for (Map.Entry<String, Object> e : bindings.entrySet()) {
                        gtb.setVariable(e.getKey(), e.getValue());
                    }
                }
                try {
                    _messageTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                mail.setMessage(sw.toString());
            }
            if (_htmlMessageTemplate != null) {
                String htmlCharset = MetaMailTemplate.this.htmlMessage.getCharset();
                if (htmlCharset == null) {
                    htmlCharset = mail.getCharset();
                }
                HtmlMessage htmlContent = new HtmlMessage();
                htmlContent.setCharset(htmlCharset);
                mail.setHtmlMessage(htmlContent);
                StringWriter sw2 = new StringWriter();
                GroovyTemplateBinding gtb2 = new GroovyTemplateBinding(sw2);
                gtb2.setVariable("mail", mail);
                if (bindings != null) {
                    for (Map.Entry<String, Object> e : bindings.entrySet()) {
                        gtb2.setVariable(e.getKey(), e.getValue());
                    }
                }
                try {
                    _htmlMessageTemplate.doTemplate(gtb2);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                if (mail.getHtmlMessage() != null) {
                    mail.getHtmlMessage().setContent(sw2.toString());
                } else {
                    mail.setHtmlMessage(new HtmlMessage(sw2.toString(), htmlCharset));
                }
            }
            return mail;
        }

        private class TemplateSet {
            private GroovyTemplate subjectTemplate;
            private GroovyTemplate messageTemplate;
            private GroovyTemplate htmlMessageTemplate;
            private String charset;

            private TemplateSet(MailTemplateRuntime mailTemplateRuntime) {
            }
        }
    }
}

