/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.message.MetaMessageCategory;
import org.iplass.mtp.impl.message.ResourceBundleConfig;
import org.iplass.mtp.message.MessageCategory;
import org.iplass.mtp.message.MessageManager;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class MessageService
extends AbstractTypedMetaDataService<MetaMessageCategory, MetaMessageCategory.MetaMessageCategoryHandler>
implements Service {
    public static final String MESSAGE_META_PATH = "/message/";
    private List<ResourceBundleConfig> resourceBundle;
    private ConcurrentHashMap<String, ResourceBundle.Control> resourceBundleControlMap;

    public List<ResourceBundleConfig> getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public void init(Config config) {
        this.resourceBundle = config.getValues("resourceBundle", ResourceBundleConfig.class);
        this.resourceBundleControlMap = new ConcurrentHashMap();
    }

    @Override
    public void destroy() {
    }

    public static String getFixedPath() {
        return MESSAGE_META_PATH;
    }

    public List<String> getMessageIdList(int tenantId, String category) {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.getRuntimeByName(category);
        MetaMessageCategory metaData = handler.getMetaData();
        return new ArrayList<String>(metaData.getMessages().keySet());
    }

    @Override
    public Class<MetaMessageCategory> getMetaDataType() {
        return MetaMessageCategory.class;
    }

    @Override
    public Class<MetaMessageCategory.MetaMessageCategoryHandler> getRuntimeType() {
        return MetaMessageCategory.MetaMessageCategoryHandler.class;
    }

    public ResourceBundle.Control getResourceBundleControl(String baseBundleName) {
        ResourceBundle.Control ctrl = this.resourceBundleControlMap.get(baseBundleName);
        if (ctrl == null && this.resourceBundle != null) {
            for (ResourceBundleConfig rbc : this.resourceBundle) {
                if (!rbc.isMatch(baseBundleName)) continue;
                ctrl = rbc.getResourceBundleControl();
                this.resourceBundleControlMap.put(baseBundleName, ctrl);
                break;
            }
        }
        return ctrl;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<MessageCategory, MetaMessageCategory> {
        public TypeMap() {
            super(MessageService.getFixedPath(), MetaMessageCategory.class, MessageCategory.class);
        }

        @Override
        public TypedDefinitionManager<MessageCategory> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(MessageManager.class);
        }
    }
}

