/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.message.MetaMessageItem;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.message.MessageCategory;
import org.iplass.mtp.message.MessageItem;

@XmlRootElement
public class MetaMessageCategory
extends BaseRootMetaData
implements DefinableMetaData<MessageCategory> {
    private static final long serialVersionUID = 3080437844175871382L;
    @XmlElement
    private LinkedHashMap<String, MetaMessageItem> messages;

    @Override
    public MetaMessageCategory copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaMessageCategoryHandler();
    }

    public Map<String, MessageItem> createMessageItems() {
        if (this.messages == null || this.messages.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, MessageItem> ret = new LinkedHashMap<String, MessageItem>(this.messages.size());
        for (Map.Entry<String, MetaMessageItem> metaItem : this.messages.entrySet()) {
            ret.put(metaItem.getKey(), metaItem.getValue().createMessageItem());
        }
        return ret.size() == 0 ? Collections.emptyMap() : ret;
    }

    @Override
    public void applyConfig(MessageCategory definition) {
        this.setName(definition.getName());
        this.setDisplayName(definition.getDisplayName());
        this.setDescription(definition.getDescription());
        this.setMetaMessages(definition.getMessageItems());
    }

    @Override
    public MessageCategory currentConfig() {
        MessageCategory definition = new MessageCategory();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setMessageItems(this.createMessageItems());
        return definition;
    }

    @XmlTransient
    public Map<String, MetaMessageItem> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, MetaMessageItem> messages) {
        this.messages = messages == null ? null : (messages instanceof LinkedHashMap ? (LinkedHashMap<Object, Object>)messages : new LinkedHashMap<String, MetaMessageItem>(messages));
    }

    public void addMessage(MetaMessageItem metaMessageItem) {
        if (this.messages == null) {
            this.messages = new LinkedHashMap();
        }
        this.messages.put(metaMessageItem.getMessageId(), metaMessageItem);
    }

    public void setMetaMessages(Map<String, MessageItem> messages) {
        if (messages == null) {
            return;
        }
        for (Map.Entry<String, MessageItem> messageItem : messages.entrySet()) {
            MetaMessageItem item = new MetaMessageItem();
            item.setValue(messageItem.getValue());
            this.addMessage(item);
        }
    }

    public class MetaMessageCategoryHandler
    extends BaseMetaDataRuntime {
        @Override
        public MetaMessageCategory getMetaData() {
            return MetaMessageCategory.this;
        }

        public MessageItem createMessageItem(String messageId) {
            if (MetaMessageCategory.this.messages == null || MetaMessageCategory.this.messages.size() == 0) {
                return null;
            }
            MetaMessageItem meta = MetaMessageCategory.this.messages.get(messageId);
            if (meta == null) {
                return null;
            }
            return meta.createMessageItem();
        }

        public String getMessageString(String messageId, String lang) {
            if (MetaMessageCategory.this.messages == null) {
                return null;
            }
            MetaMessageItem item = MetaMessageCategory.this.messages.get(messageId);
            if (item == null) {
                return null;
            }
            if (lang != null && item.getLocalizedMessageList() != null) {
                for (MetaLocalizedString mls : item.getLocalizedMessageList()) {
                    if (!lang.equals(mls.getLocaleName())) continue;
                    return mls.getStringValue();
                }
            }
            return item.getMessage();
        }
    }
}

