/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iplass.mtp.impl.cache.CacheController;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.LoadingAdapter;
import org.iplass.mtp.impl.cluster.ClusterEventListener;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataContextListener;
import org.iplass.mtp.impl.metadata.MetaDataDuplicatePathException;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataIllegalStateException;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataContext {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataContext.class);
    public static final String METADATA_CACHE_NAMESPACE = "mtp.metadata.metaData";
    public static final String METADATA_DEF_LIST_CACHE_NAMESPACE = "mtp.metadata.metaDataDefList";
    private static final String CLUSTER_EVENT_NAME_METADATA_CONTEXT_EVENT = "mtp.metadata.ce/";
    private static final String CLUSTER_MESSAGE_TYPE = "t";
    private static final String CLUSTER_MESSAGE_PATH = "p";
    private static final String CLUSTER_MESSAGE_PATH_BEFORE = "pb";
    private static final String CLUSTER_MESSAGE_TYPE_CREATED = "c";
    private static final String CLUSTER_MESSAGE_TYPE_UPDATED = "u";
    private static final String CLUSTER_MESSAGE_TYPE_REMOVED = "r";
    private final int tenantId;
    private final MetaDataRepository repository;
    private final TenantContextService tcService;
    private final CacheController<String, MetaDataEntry> cache;
    private final CacheController<String, MetaDataDefinitionCacheEntry> defListCache;
    private final CopyOnWriteArrayList<MetaDataContextListener> listenerList;
    private final String clusterEventName;
    private final ClusterEventListener cel;

    public static MetaDataContext getContext() {
        return ExecuteContext.getCurrentContext().getTenantContext().getMetaDataContext();
    }

    public MetaDataContext(int tenantId) {
        this.tenantId = tenantId;
        this.repository = ServiceRegistry.getRegistry().getService(MetaDataRepository.class);
        this.tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        this.cache = new CacheController<String, MetaDataEntry>(cs.getCache("mtp.metadata.metaData/" + tenantId), true, 1, new MetaDataCacheLogic(), true, true);
        this.defListCache = new CacheController<String, MetaDataDefinitionCacheEntry>(cs.getCache("mtp.metadata.metaDataDefList/" + tenantId), false, 0, new MetaDataDefinitionCacheLogic(), false, true);
        this.listenerList = new CopyOnWriteArrayList();
        this.clusterEventName = CLUSTER_EVENT_NAME_METADATA_CONTEXT_EVENT + tenantId;
        this.cel = new ClusterEventListener(){

            @Override
            public void onMessage(Message message) {
                String type = message.getParameter(MetaDataContext.CLUSTER_MESSAGE_TYPE);
                String path = message.getParameter(MetaDataContext.CLUSTER_MESSAGE_PATH);
                String pathBefore = message.getParameter(MetaDataContext.CLUSTER_MESSAGE_PATH_BEFORE);
                switch (type) {
                    case "c": {
                        if (MetaDataContext.this.listenerList.size() <= 0) break;
                        for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                            l.created(path);
                        }
                        break;
                    }
                    case "u": {
                        if (MetaDataContext.this.listenerList.size() <= 0) break;
                        for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                            l.updated(path, pathBefore);
                        }
                        break;
                    }
                    case "r": {
                        if (MetaDataContext.this.listenerList.size() <= 0) break;
                        for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                            l.removed(path);
                        }
                        break;
                    }
                }
            }
        };
        ServiceRegistry.getRegistry().getService(ClusterService.class).registerListener(new String[]{this.clusterEventName}, this.cel);
    }

    private void sendClusterEvent(String type, String path, String pathBefore) {
        Message msg = new Message(this.clusterEventName);
        msg.addParameter(CLUSTER_MESSAGE_TYPE, type);
        msg.addParameter(CLUSTER_MESSAGE_PATH, path);
        if (pathBefore != null) {
            msg.addParameter(CLUSTER_MESSAGE_PATH_BEFORE, pathBefore);
        }
        ServiceRegistry.getRegistry().getService(ClusterService.class).sendMessage(msg);
    }

    public void addMetaDataContextListener(MetaDataContextListener listener) {
        this.listenerList.add(listener);
    }

    public void removeMetaDataContextListener(MetaDataContextListener listener) {
        if (this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
    }

    public <H extends MetaDataRuntime> H getMetaDataHandler(Class<H> type, String path) {
        MetaDataEntry ent = this.getMetaDataEntry(path);
        if (ent != null) {
            return (H)ent.getRuntime();
        }
        return null;
    }

    public <H extends MetaDataRuntime> H getMetaDataHandlerById(Class<H> type, String id) {
        MetaDataEntry ent = this.getMetaDataEntryById(id);
        if (ent != null) {
            return (H)ent.getRuntime();
        }
        return null;
    }

    public <H extends MetaDataRuntime> H getMetaDataHandlerById(Class<H> type, String id, int version) {
        MetaDataEntry ent = this.getMetaDataEntryById(id, version);
        if (ent != null) {
            return (H)ent.getRuntime();
        }
        return null;
    }

    public MetaDataEntry getMetaDataEntry(String path) {
        MetaDataEntry entry = this.cache.getByIndex(0, path);
        if (entry == null && this.tcService.getSharedTenantId() != this.tenantId) {
            MetaDataContext sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext();
            entry = sharedContext.getMetaDataEntry(path);
            if (entry != null && entry.isSharable()) {
                entry = entry.copy();
                entry.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
            } else {
                entry = null;
            }
        }
        return entry;
    }

    public MetaDataEntry getMetaDataEntryById(String id) {
        MetaDataEntry entry = this.cache.get(id);
        if (entry == null && this.tcService.getSharedTenantId() != this.tenantId) {
            MetaDataContext sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext();
            entry = sharedContext.getMetaDataEntryById(id);
            if (entry != null && entry.isSharable()) {
                entry = entry.copy();
                entry.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
            } else {
                entry = null;
            }
        }
        return entry;
    }

    public MetaDataEntry getMetaDataEntryById(String id, int version) {
        MetaDataEntry entry = this.repository.loadById(this.tenantId, id, version, false);
        if (entry != null) {
            entry.initRuntime();
        }
        if (entry == null && this.tcService.getSharedTenantId() != this.tenantId) {
            MetaDataContext sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext();
            entry = sharedContext.getMetaDataEntryById(id, version);
            if (entry != null && entry.isSharable()) {
                entry = entry.copy();
                entry.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
            } else {
                entry = null;
            }
        }
        return entry;
    }

    public void store(String path, RootMetaData metaData) {
        this.doStore(path, metaData, null, true, false);
    }

    public void store(String path, RootMetaData metaData, MetaDataConfig config, boolean doAutoReload) {
        this.doStore(path, metaData, config, doAutoReload, true);
    }

    private void doStore(final String path, RootMetaData metaData, MetaDataConfig config, final boolean doAutoReload, final boolean doReloadAfterCommit) {
        Transaction.required(transaction -> {
            MetaDataEntry current;
            MetaDataConfig storeConfig = config;
            if (storeConfig == null) {
                storeConfig = new MetaDataConfig(false, false, false, false);
            }
            if ((current = this.repository.load(this.tenantId, path, true)) != null) {
                throw new MetaDataDuplicatePathException(this.tenantId + "'s " + path + " MetaData is currently exsits");
            }
            MetaDataEntry toStore = new MetaDataEntry(path, metaData, MetaDataEntry.State.VALID, 0, storeConfig.isOverwritable(), storeConfig.isSharable(), storeConfig.isDataSharable(), storeConfig.isPermissionSharable());
            this.repository.store(this.tenantId, toStore);
            if (doAutoReload && !doReloadAfterCommit) {
                this.doAfterStoreProccess(path);
            }
            transaction.addTransactionListener(new TransactionListener(){

                @Override
                public void afterCommit(Transaction t) {
                    if (doAutoReload && doReloadAfterCommit) {
                        MetaDataContext.this.doAfterStoreProccess(path);
                    }
                    if (MetaDataContext.this.listenerList.size() > 0) {
                        for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                            l.created(path);
                        }
                    }
                    MetaDataContext.this.sendClusterEvent(MetaDataContext.CLUSTER_MESSAGE_TYPE_CREATED, path, null);
                }
            });
            return null;
        });
    }

    private void doAfterStoreProccess(String path) {
        MetaDataEntry reload = this.repository.load(this.tenantId, path, false);
        reload.initRuntime();
        this.cache.notifyCreate(reload);
        this.updateNodeCache(path);
    }

    public void update(String path, RootMetaData metaData) {
        this.doUpdate(path, metaData, null, true, false);
    }

    public void update(String path, RootMetaData metaData, MetaDataConfig config, boolean doAutoReload) {
        this.doUpdate(path, metaData, config, doAutoReload, true);
    }

    private void doUpdate(final String path, RootMetaData metaData, MetaDataConfig config, final boolean doAutoReload, final boolean doReloadAfterCommit) {
        String pathBefore;
        final MetaDataEntry current = this.getMetaDataEntryByIdDirect(metaData.getId());
        if (current == null) {
            throw new MetaDataRuntimeException(this.tenantId + "'s " + path + "(" + metaData.getId() + ") MetaData is currently no exsits.");
        }
        String string = pathBefore = path.equals(current.getPath()) ? null : current.getPath();
        if (current.getRepositryType() == MetaDataEntry.RepositoryType.SHARED && !current.isOverwritable()) {
            throw new MetaDataRuntimeException(path + "(" + metaData.getId() + ") MetaData not allowed overwrite.");
        }
        Transaction.required(transaction -> {
            MetaDataEntry toStore = current.copy();
            toStore.setMetaData(metaData);
            toStore.setPath(path);
            this.repository.update(this.tenantId, toStore);
            if (config != null) {
                if (current.getRepositryType() == MetaDataEntry.RepositoryType.SHARED) {
                    toStore.setRepositryType(MetaDataEntry.RepositoryType.SHARED_OVERWRITE);
                }
                this.updateConfigRepository(toStore, config, false);
            }
            if (doAutoReload && !doReloadAfterCommit) {
                this.doAfterUpdateProccess(path, current, pathBefore);
            }
            transaction.addTransactionListener(new TransactionListener(){

                @Override
                public void afterCommit(Transaction t) {
                    if (doAutoReload && doReloadAfterCommit) {
                        MetaDataContext.this.doAfterUpdateProccess(path, current, pathBefore);
                    }
                    if (MetaDataContext.this.listenerList.size() > 0) {
                        for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                            l.updated(path, pathBefore);
                        }
                    }
                    MetaDataContext.this.sendClusterEvent(MetaDataContext.CLUSTER_MESSAGE_TYPE_UPDATED, path, pathBefore);
                }
            });
        });
    }

    private MetaDataEntry getMetaDataEntryByIdDirect(String id) {
        boolean isShared = this.tcService.getSharedTenantId() == this.tenantId;
        MetaDataEntry entry = this.repository.loadById(this.tenantId, id, isShared);
        this.checkShared(entry);
        if (entry == null && this.tcService.getSharedTenantId() != this.tenantId) {
            MetaDataContext sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext();
            entry = sharedContext.getMetaDataEntryById(id);
            if (entry != null && entry.isSharable()) {
                entry = entry.copy();
                entry.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
            } else {
                entry = null;
            }
        }
        return entry;
    }

    public void reloadById(String id) {
        MetaDataEntry reload = this.repository.loadById(this.tenantId, id, false);
        if (reload != null) {
            reload.initRuntime();
            this.cache.notifyUpdate(reload);
            this.updateNodeCache(reload.getPath());
        }
    }

    private void doAfterUpdateProccess(String path, MetaDataEntry current, String pathBefore) {
        MetaDataContext sharedContext;
        MetaDataEntry entry;
        MetaDataEntry reload = this.repository.load(this.tenantId, path, false);
        if (current.getRepositryType() == MetaDataEntry.RepositoryType.SHARED) {
            reload.setRepositryType(MetaDataEntry.RepositoryType.SHARED_OVERWRITE);
        } else if (this.tcService.getSharedTenantId() != this.tenantId && (entry = (sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext()).getMetaDataEntryById(current.getMetaData().getId())) != null) {
            reload.setRepositryType(MetaDataEntry.RepositoryType.SHARED_OVERWRITE);
        }
        reload.initRuntime();
        this.cache.notifyUpdate(reload);
        this.updateNodeCache(path);
        if (pathBefore != null) {
            this.updateNodeCache(pathBefore);
        }
    }

    public void remove(String path) {
        this.doRemove(path, true, false);
    }

    public void remove(String path, boolean doAutoReload) {
        this.doRemove(path, doAutoReload, true);
    }

    private void doRemove(final String path, final boolean doAutoReload, final boolean doReloadAfterCommit) {
        final MetaDataEntry current = this.repository.load(this.tenantId, path, true);
        Transaction.required(transaction -> {
            if (current != null && current.getRepositryType() != MetaDataEntry.RepositoryType.SHARED) {
                this.repository.remove(this.tenantId, path);
            }
            if (doAutoReload && !doReloadAfterCommit) {
                this.doAfterRemoveProccess(path, current);
            }
            transaction.addTransactionListener(new TransactionListener(){

                @Override
                public void afterCommit(Transaction t) {
                    if (doAutoReload && doReloadAfterCommit) {
                        MetaDataContext.this.doAfterRemoveProccess(path, current);
                    }
                    if (MetaDataContext.this.listenerList.size() > 0) {
                        for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                            l.removed(path);
                        }
                    }
                    MetaDataContext.this.sendClusterEvent(MetaDataContext.CLUSTER_MESSAGE_TYPE_REMOVED, path, null);
                }
            });
        });
    }

    private void doAfterRemoveProccess(String path, MetaDataEntry current) {
        try {
            if (current != null) {
                this.cache.notifyDelete(current);
            }
        }
        catch (Exception e) {
            logger.error("can not load MetaData cause Exception... So, Do force delete Operation... Clear all Cache...", (Throwable)e);
            this.cache.clearAll();
        }
        this.updateNodeCache(path);
    }

    public void updateConfig(String path, MetaDataConfig config) {
        MetaDataEntry meta = this.getMetaDataEntry(path);
        if (meta == null) {
            throw new MetaDataRuntimeException(this.tenantId + "'s " + path + " MetaData is currently no exsits.");
        }
        this.updateConfigRepository(meta, config, true);
    }

    private void updateConfigRepository(final MetaDataEntry meta, MetaDataConfig config, boolean doAutoReload) {
        if (meta.getRepositryType() == MetaDataEntry.RepositoryType.SHARED) {
            throw new MetaDataRuntimeException(meta.getPath() + "(" + meta.getMetaData().getId() + ") MetaData not allowed change config.");
        }
        Transaction.required(transaction -> {
            if (doAutoReload) {
                transaction.addTransactionListener(new TransactionListener(){

                    @Override
                    public void afterCommit(Transaction t) {
                        MetaDataEntry reload = MetaDataContext.this.repository.loadById(MetaDataContext.this.tenantId, meta.getMetaData().getId(), false);
                        reload.setRepositryType(meta.getRepositryType());
                        reload.initRuntime();
                        MetaDataContext.this.cache.notifyUpdate(reload);
                        MetaDataContext.this.updateNodeCache(meta.getPath());
                        if (MetaDataContext.this.listenerList.size() > 0) {
                            for (MetaDataContextListener l : MetaDataContext.this.listenerList) {
                                l.updated(meta.getPath(), null);
                            }
                        }
                        MetaDataContext.this.sendClusterEvent(MetaDataContext.CLUSTER_MESSAGE_TYPE_UPDATED, meta.getPath(), null);
                    }
                });
            }
            if (this.tcService.getSharedTenantId() == this.tenantId) {
                if ((meta.isSharable() && !config.isSharable() || meta.isSharable() && meta.isOverwritable() && !config.isOverwritable()) && this.hasOverwriteMetaData(meta)) {
                    throw new MetaDataRuntimeException(meta.getPath() + " MetaData is already shared and overwrote.so can not change config to no share or no overwrite.");
                }
                if (config.isSharable() && config.isOverwritable() && (config.isDataSharable() || config.isPermissionSharable())) {
                    throw new MetaDataRuntimeException(meta.getPath() + " MetaData can not set to overwrite and dataShare/permissionShare at the same time.");
                }
                MetaDataEntry localMeta = this.repository.loadById(this.tenantId, meta.getMetaData().getId(), false);
                if (localMeta == null) {
                    this.repository.store(this.tenantId, localMeta);
                }
            }
            this.repository.updateConfigById(this.tenantId, meta.getMetaData().getId(), config);
        });
    }

    private boolean hasOverwriteMetaData(MetaDataEntry meta) {
        List<Integer> list = this.repository.getTenantIdsOf(meta.getMetaData().getId());
        if (list.size() == 0) {
            return false;
        }
        return !list.contains(this.tcService.getSharedTenantId()) || list.size() != 1;
    }

    public void checkState(String path) throws MetaDataIllegalStateException {
        MetaDataRuntime metaData = this.getMetaDataHandler(MetaDataRuntime.class, path);
        if (metaData == null) {
            throw new MetaDataIllegalStateException("path:" + path + " MetaDataRuntime not found");
        }
        metaData.checkState();
    }

    public List<String> pathList(String prefixPath) {
        List<MetaDataEntryInfo> infoList = this.definitionList(prefixPath);
        if (infoList == null) {
            return null;
        }
        ArrayList<String> pathList = new ArrayList<String>(infoList.size());
        for (MetaDataEntryInfo info : infoList) {
            pathList.add(info.getPath());
        }
        return pathList;
    }

    public List<MetaDataEntryInfo> definitionList(String prefixPath) {
        Object path = prefixPath;
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        ArrayList<MetaDataEntryInfo> list = null;
        if (this.tcService.getSharedTenantId() != this.tenantId) {
            Map<String, MetaDataEntryInfo> localMap;
            MetaDataDefinitionCacheEntry nodeEntry;
            HashMap<String, MetaDataEntryInfo> map = new HashMap<String, MetaDataEntryInfo>();
            List<MetaDataEntryInfo> sharedList = this.tcService.getSharedTenantContext().getMetaDataContext().definitionList((String)path);
            if (sharedList != null) {
                for (MetaDataEntryInfo info : sharedList) {
                    if (!info.isSharable()) continue;
                    info = info.copy();
                    info.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
                    map.put(info.getPath(), info);
                }
            }
            if ((nodeEntry = this.defListCache.get((String)path)) != null && (localMap = nodeEntry.map) != null) {
                for (MetaDataEntryInfo info : localMap.values()) {
                    if (map.containsKey(info.getPath())) {
                        info = info.copy();
                        info.setRepositryType(MetaDataEntry.RepositoryType.SHARED_OVERWRITE);
                    }
                    map.put(info.getPath(), info);
                }
            }
            list = new ArrayList(map.values());
        } else {
            Map<String, MetaDataEntryInfo> localMap;
            MetaDataDefinitionCacheEntry nodeEntry = this.defListCache.get((String)path);
            if (nodeEntry != null && (localMap = nodeEntry.map) != null) {
                list = new ArrayList<MetaDataEntryInfo>(localMap.values());
            }
        }
        Collections.sort(list, new Comparator<MetaDataEntryInfo>(this){

            @Override
            public int compare(MetaDataEntryInfo o1, MetaDataEntryInfo o2) {
                return o1.getPath().toLowerCase().compareTo(o2.getPath().toLowerCase());
            }
        });
        return list;
    }

    public List<MetaDataEntryInfo> invalidDefinitionList(String prefixPath) {
        Object path = prefixPath;
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        boolean isShared = this.tcService.getSharedTenantId() == this.tenantId;
        MetaDataContext sharedContext = null;
        if (!isShared) {
            sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext();
        }
        List<MetaDataEntryInfo> localList = this.repository.definitionList(this.tenantId, (String)path, isShared, true);
        LinkedList<MetaDataEntryInfo> invalidList = new LinkedList<MetaDataEntryInfo>();
        for (MetaDataEntryInfo e : localList) {
            if (e.getState() != MetaDataEntry.State.INVALID) continue;
            if (!isShared) {
                MetaDataEntry entry = sharedContext.getMetaDataEntryById(e.getId());
                if (entry != null && entry.isSharable()) continue;
                invalidList.add(e);
                continue;
            }
            invalidList.add(e);
        }
        return invalidList;
    }

    public boolean exists(String prefixPath, String subPath) {
        boolean shareExists;
        if (!((String)prefixPath).endsWith("/")) {
            prefixPath = (String)prefixPath + "/";
        }
        if (this.tcService.getSharedTenantId() != this.tenantId && (shareExists = this.tcService.getSharedTenantContext().getMetaDataContext().exists((String)prefixPath, subPath))) {
            return true;
        }
        MetaDataDefinitionCacheEntry nodeEntry = this.defListCache.get((String)prefixPath);
        if (nodeEntry != null) {
            String fullPath = (String)prefixPath + subPath;
            return nodeEntry.map.containsKey(fullPath);
        }
        return false;
    }

    public List<Integer> getOverwriteTenantIdList(String metaDataId) {
        List<Integer> res = this.repository.getTenantIdsOf(metaDataId);
        res.removeIf(tid -> tid.equals(this.tcService.getSharedTenantId()));
        return res;
    }

    public void invalidate() {
        this.cache.invalidateCacheStore();
        this.defListCache.invalidateCacheStore();
        ServiceRegistry.getRegistry().getService(ClusterService.class).removeListener(new String[]{this.clusterEventName}, this.cel);
    }

    public void clearAllCache() {
        this.cache.clearAll();
        this.defListCache.clearAll();
    }

    public void traceCache() {
        this.cache.trace();
    }

    public void refreshTransactionLocalCache(String id) {
        String beforePath = null;
        MetaDataEntry before = this.getMetaDataEntryById(id);
        if (before != null) {
            beforePath = before.getPath();
        }
        this.cache.refreshTransactionLocalStore(id);
        String afterPath = null;
        MetaDataEntry after = this.getMetaDataEntryById(id);
        if (after != null) {
            afterPath = after.getPath();
        }
        if (beforePath != null && !beforePath.equals(afterPath)) {
            this.updateNodeCache(beforePath);
        }
        if (afterPath != null) {
            this.updateNodeCache(afterPath);
        }
    }

    private void updateNodeCache(String prefixPath) {
        boolean isShared;
        Object listPath = prefixPath;
        if (!((String)listPath).endsWith("/")) {
            listPath = (String)listPath + "/";
        }
        boolean bl = isShared = this.tcService.getSharedTenantId() == this.tenantId;
        while (((String)listPath).length() != 0) {
            String pathWithSlash = (String)(listPath = ((String)listPath).substring(0, ((String)listPath).lastIndexOf(47))) + "/";
            List<MetaDataEntryInfo> list = this.repository.definitionList(this.tenantId, pathWithSlash, isShared);
            if (list == null || list.size() == 0) {
                list = Collections.emptyList();
            }
            this.defListCache.notifyUpdate(new MetaDataDefinitionCacheEntry(pathWithSlash, list));
        }
    }

    private void checkShared(MetaDataEntry entry) {
        if (entry != null) {
            if (this.tcService.getSharedTenantId() != this.tenantId) {
                MetaDataContext sharedContext = this.tcService.getSharedTenantContext().getMetaDataContext();
                MetaDataEntry sharedEntry = sharedContext.getMetaDataEntry(entry.getPath());
                if (sharedEntry != null && sharedEntry.isSharable()) {
                    entry.setRepositryType(MetaDataEntry.RepositoryType.SHARED_OVERWRITE);
                }
            } else {
                entry.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
            }
        }
    }

    private class MetaDataCacheLogic
    implements LoadingAdapter<String, MetaDataEntry> {
        private MetaDataCacheLogic() {
        }

        @Override
        public Object getIndexVal(int index, MetaDataEntry val) {
            return val.getPath();
        }

        @Override
        public String getKey(MetaDataEntry val) {
            return val.getMetaData().getId();
        }

        @Override
        public MetaDataEntry load(String key) {
            boolean isShared = MetaDataContext.this.tcService.getSharedTenantId() == MetaDataContext.this.tenantId;
            final MetaDataEntry ent = MetaDataContext.this.repository.loadById(MetaDataContext.this.tenantId, key, isShared);
            MetaDataContext.this.checkShared(ent);
            if (ent != null) {
                if (ExecuteContext.getCurrentContext().getClientTenantId() != MetaDataContext.this.tenantId) {
                    ExecuteContext.executeAs(MetaDataContext.this.tcService.getTenantContext(MetaDataContext.this.tenantId), new Executable<Void>(){

                        @Override
                        public Void execute() {
                            ent.initRuntime();
                            return null;
                        }
                    });
                } else {
                    ent.initRuntime();
                }
                return ent;
            }
            return null;
        }

        @Override
        public List<MetaDataEntry> loadByIndex(int index, Object indexVal) {
            boolean isShared = MetaDataContext.this.tcService.getSharedTenantId() == MetaDataContext.this.tenantId;
            final MetaDataEntry ent = MetaDataContext.this.repository.load(MetaDataContext.this.tenantId, (String)indexVal, isShared);
            MetaDataContext.this.checkShared(ent);
            if (ent != null) {
                if (ExecuteContext.getCurrentContext().getClientTenantId() != MetaDataContext.this.tenantId) {
                    ExecuteContext.executeAs(MetaDataContext.this.tcService.getTenantContext(MetaDataContext.this.tenantId), new Executable<Void>(){

                        @Override
                        public Void execute() {
                            ent.initRuntime();
                            return null;
                        }
                    });
                } else {
                    ent.initRuntime();
                }
                return Arrays.asList(ent);
            }
            return null;
        }

        @Override
        public long getVersion(MetaDataEntry value) {
            return value.getVersion();
        }
    }

    private class MetaDataDefinitionCacheLogic
    implements LoadingAdapter<String, MetaDataDefinitionCacheEntry> {
        private MetaDataDefinitionCacheLogic() {
        }

        @Override
        public Object getIndexVal(int index, MetaDataDefinitionCacheEntry val) {
            return null;
        }

        @Override
        public String getKey(MetaDataDefinitionCacheEntry val) {
            return val.repositoryPath;
        }

        @Override
        public MetaDataDefinitionCacheEntry load(String key) {
            boolean isShared = MetaDataContext.this.tcService.getSharedTenantId() == MetaDataContext.this.tenantId;
            List<MetaDataEntryInfo> list = MetaDataContext.this.repository.definitionList(MetaDataContext.this.tenantId, key, isShared);
            if (list != null) {
                return new MetaDataDefinitionCacheEntry(key, list);
            }
            return null;
        }

        @Override
        public List<MetaDataDefinitionCacheEntry> loadByIndex(int index, Object indexVal) {
            return null;
        }

        @Override
        public long getVersion(MetaDataDefinitionCacheEntry value) {
            return 0L;
        }
    }

    public static class MetaDataDefinitionCacheEntry {
        private String repositoryPath;
        private Map<String, MetaDataEntryInfo> map;

        public MetaDataDefinitionCacheEntry() {
        }

        public MetaDataDefinitionCacheEntry(String repositoryPath, List<MetaDataEntryInfo> list) {
            this.repositoryPath = repositoryPath;
            this.map = new HashMap<String, MetaDataEntryInfo>();
            for (MetaDataEntryInfo e : list) {
                this.map.put(e.getPath(), e);
            }
        }

        public String toString() {
            return "MetaDataDefinitionCacheEntry(path=" + this.repositoryPath + ",map=" + String.valueOf(this.map) + ")";
        }
    }
}

