/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata;

import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.metadata.RootMetaData;

public class MetaDataEntry {
    private String path;
    private RootMetaData metaData;
    private State state;
    private int version;
    private boolean overwritable;
    private boolean sharable;
    private boolean dataSharable;
    private boolean permissionSharable;
    private RepositoryType repositryType;
    private MetaDataRuntime runtime;

    public MetaDataEntry() {
    }

    public MetaDataEntry(String path, RootMetaData metaData, State state, int version, boolean overwritable, boolean sharable, boolean dataSharable, boolean permissionSharable) {
        this.path = path;
        this.metaData = metaData;
        this.state = state;
        this.version = version;
        this.overwritable = overwritable;
        this.sharable = sharable;
        this.dataSharable = dataSharable;
        this.permissionSharable = permissionSharable;
    }

    public MetaDataEntry copy() {
        MetaDataEntry copy = new MetaDataEntry();
        copy.path = this.path;
        copy.metaData = this.metaData;
        copy.state = this.state;
        copy.version = this.version;
        copy.overwritable = this.overwritable;
        copy.sharable = this.sharable;
        copy.dataSharable = this.dataSharable;
        copy.permissionSharable = this.permissionSharable;
        copy.repositryType = this.repositryType;
        copy.runtime = this.runtime;
        return copy;
    }

    public void initRuntime() {
        this.runtime = this.metaData.createRuntime(new MetaDataConfig(this.sharable, this.overwritable, this.dataSharable, this.permissionSharable));
    }

    public MetaDataRuntime getRuntime() {
        return this.runtime;
    }

    public RepositoryType getRepositryType() {
        return this.repositryType;
    }

    public void setRepositryType(RepositoryType repositryType) {
        this.repositryType = repositryType;
    }

    public boolean isOverwritable() {
        return this.overwritable;
    }

    public void setOverwritable(boolean overwritable) {
        this.overwritable = overwritable;
    }

    public boolean isSharable() {
        return this.sharable;
    }

    public void setSharable(boolean sharable) {
        this.sharable = sharable;
    }

    public boolean isDataSharable() {
        return this.dataSharable;
    }

    public void setDataSharable(boolean dataSharable) {
        this.dataSharable = dataSharable;
    }

    public boolean isPermissionSharable() {
        return this.permissionSharable;
    }

    public void setPermissionSharable(boolean permissionSharable) {
        this.permissionSharable = permissionSharable;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RootMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(RootMetaData metaData) {
        this.metaData = metaData;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static enum State {
        VALID,
        INVALID;

    }

    public static enum RepositoryType {
        SHARED,
        TENANT_LOCAL,
        SHARED_OVERWRITE;

    }
}

