/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataJAXBService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(MetaDataJAXBService.class);
    private JAXBContext context;
    private List<String> classesToBeBound;

    @Override
    public void init(Config config) {
        try {
            this.classesToBeBound = config.getValues("classToBeBound");
            Class[] classes = new Class[this.classesToBeBound.size()];
            for (int i = 0; i < this.classesToBeBound.size(); ++i) {
                classes[i] = Class.forName(this.classesToBeBound.get(i));
                logger.debug("Add to JAXBContext:" + String.valueOf(classes[i]));
            }
            this.context = JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    @Override
    public void destroy() {
        this.context = null;
    }

    public JAXBContext getJAXBContext() {
        return this.context;
    }

    public String marshal(RootMetaData metaData) {
        StringWriter w = new StringWriter();
        try {
            Marshaller m = this.context.createMarshaller();
            m.marshal((Object)metaData, (Writer)w);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        return w.toString();
    }

    public RootMetaData unmarshal(String marshaledString) {
        try {
            Unmarshaller um = this.context.createUnmarshaller();
            return (RootMetaData)um.unmarshal((Reader)new StringReader(marshaledString));
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    public JAXBContext createJAXBContext(Class<?> ... additionalClass) {
        try {
            int i;
            Class[] classes = new Class[this.classesToBeBound.size() + additionalClass.length];
            for (i = 0; i < this.classesToBeBound.size(); ++i) {
                classes[i] = Class.forName(this.classesToBeBound.get(i));
                logger.debug("Add to JAXBContext:" + String.valueOf(classes[i]));
            }
            for (i = 0; i < additionalClass.length; ++i) {
                classes[this.classesToBeBound.size() + i] = additionalClass[i];
            }
            return JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MetaDataRuntimeException(e);
        }
    }
}

