/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.command.annotation.MetaDataSeeAlso;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRepositoryKind;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.MetaDataStore;
import org.iplass.mtp.impl.metadata.annotation.AnnotatableMetaDataFactory;
import org.iplass.mtp.impl.metadata.annotation.AnnotateMetaDataEntry;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationMetaDataStore
implements MetaDataStore {
    private static Logger logger = LoggerFactory.getLogger(AnnotationMetaDataStore.class);
    private List<AnnotatableMetaDataFactory> annotatableMetaDataFactory;
    private Map<String, AnnotateMetaDataEntry> pathMetaMap;

    public List<AnnotatableMetaDataFactory> getAnnotatableMetaDataFactory() {
        return this.annotatableMetaDataFactory;
    }

    public void setAnnotatableMetaDataFactory(List<AnnotatableMetaDataFactory> annotatableMetaDataFactory) {
        this.annotatableMetaDataFactory = annotatableMetaDataFactory;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        return this.load(tenantId, id);
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id, int version) {
        return this.loadById(tenantId, id);
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath) throws MetaDataRuntimeException {
        return this.definitionList(tenantId, prefixPath, false);
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath, boolean withInvalid) throws MetaDataRuntimeException {
        Object path = prefixPath;
        if (path != null && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        ArrayList<MetaDataEntryInfo> res = new ArrayList<MetaDataEntryInfo>();
        for (Map.Entry<String, AnnotateMetaDataEntry> e : this.pathMetaMap.entrySet()) {
            if (!e.getKey().startsWith((String)path)) continue;
            MetaDataEntryInfo node = new MetaDataEntryInfo();
            node.setPath(e.getKey());
            node.setId(e.getValue().getMetaData().getId());
            node.setDisplayName(e.getValue().getMetaData().getDisplayName());
            node.setDescription(e.getValue().getMetaData().getDescription());
            node.setRepository(MetaDataRepositoryKind.ANNOTATION.getDisplayName());
            node.setState(MetaDataEntry.State.VALID);
            node.setSharable(true);
            node.setDataSharable(false);
            node.setOverwritable(e.getValue().isOverwritable());
            node.setPermissionSharable(e.getValue().isPermissionSharable());
            res.add(node);
        }
        Collections.sort(res, new Comparator<MetaDataEntryInfo>(this){

            @Override
            public int compare(MetaDataEntryInfo o1, MetaDataEntryInfo o2) {
                return o1.getPath().toLowerCase().compareTo(o2.getPath().toLowerCase());
            }
        });
        return res;
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
        this.pathMetaMap = new HashMap<String, AnnotateMetaDataEntry>();
        Map<Class<Annotation>, AnnotatableMetaDataFactory> factories = this.createFactories(this.annotatableMetaDataFactory);
        try {
            ArrayList<Class> checkedList = new ArrayList<Class>();
            List<String> annotatedClassNames = config.getValues("annotatedClass");
            if (annotatedClassNames != null) {
                for (String n : annotatedClassNames) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("check " + n + " 's Annotation...");
                    }
                    Class<?> c = Class.forName(n);
                    this.checkAndCreateMetaData(c, checkedList, factories);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new MetaDataRuntimeException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("created metaData from Annotation.");
            if (logger.isTraceEnabled()) {
                for (Map.Entry<String, AnnotateMetaDataEntry> e : this.pathMetaMap.entrySet()) {
                    logger.trace(e.getKey() + ", id=" + e.getValue().getMetaData().getId());
                }
            }
        }
    }

    @Override
    public void destroyed() {
    }

    private void checkAndCreateMetaData(Class annotatedClass, List<Class> checkedList, Map<Class<Annotation>, AnnotatableMetaDataFactory> factories) {
        if (checkedList.contains(annotatedClass)) {
            return;
        }
        checkedList.add(annotatedClass);
        Annotation[] annotations = annotatedClass.getAnnotations();
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (a instanceof MetaDataSeeAlso) {
                    Class<?>[] seeAlso = ((MetaDataSeeAlso)a).value();
                    if (seeAlso == null) continue;
                    for (Class<?> c : seeAlso) {
                        this.checkAndCreateMetaData(c, checkedList, factories);
                    }
                    continue;
                }
                AnnotatableMetaDataFactory amdf = factories.get(a.annotationType());
                if (amdf == null || !amdf.getAnnotatedClass().isAssignableFrom(annotatedClass)) continue;
                Map<String, AnnotateMetaDataEntry> metaMap = amdf.toMetaData(annotatedClass);
                for (Map.Entry<String, AnnotateMetaDataEntry> e : metaMap.entrySet()) {
                    String path = e.getKey();
                    if (this.pathMetaMap.containsKey(path) && logger.isDebugEnabled()) {
                        logger.debug("already use the path:" + path + " metaData:" + String.valueOf(this.pathMetaMap.get(path).getClass()) + " annotatedClass:" + String.valueOf(annotatedClass));
                    }
                    AnnotateMetaDataEntry metaData = e.getValue();
                    metaData.getMetaData().setId(path);
                    this.pathMetaMap.put(path, metaData);
                }
            }
        }
    }

    private Map<Class<Annotation>, AnnotatableMetaDataFactory> createFactories(List<AnnotatableMetaDataFactory> factoryList) {
        HashMap<Class<Annotation>, AnnotatableMetaDataFactory> factories = new HashMap<Class<Annotation>, AnnotatableMetaDataFactory>();
        for (AnnotatableMetaDataFactory factory : factoryList) {
            factories.put(factory.getAnnotationClass(), factory);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("regist AnnotatableMetaDataFactory:" + factory.getClass().getName() + " for " + factory.getAnnotationClass().getName());
        }
        return factories;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) throws MetaDataRuntimeException {
        AnnotateMetaDataEntry meta = this.pathMetaMap.get(path);
        if (meta == null) {
            return null;
        }
        MetaDataEntry instance = new MetaDataEntry();
        instance.setMetaData(meta.getMetaData().copy());
        instance.setVersion(0);
        instance.setState(MetaDataEntry.State.VALID);
        instance.setPath(path);
        instance.setSharable(true);
        instance.setDataSharable(false);
        instance.setOverwritable(meta.isOverwritable());
        instance.setPermissionSharable(meta.isPermissionSharable());
        return instance;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        return this.load(tenantId, path);
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        throw new MetaDataRuntimeException(metaDataEntry.getPath() + "'s meta data is read only.");
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        throw new MetaDataRuntimeException(metaDataEntry.getPath() + "'s meta data is read only.");
    }

    @Override
    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        throw new MetaDataRuntimeException(path + "'s meta data is read only.");
    }

    @Override
    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        throw new MetaDataRuntimeException(id + "'s meta data is read only.");
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String id) {
        return null;
    }

    @Override
    public List<Integer> getTenantIdsOf(String id) {
        return null;
    }

    @Override
    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
    }
}

