/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.binary;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.definition.binary.ArchiveBinaryDefinition;
import org.iplass.mtp.definition.binary.BinaryDefinition;
import org.iplass.mtp.impl.metadata.MetaDataIllegalStateException;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaDataService;
import org.iplass.mtp.impl.metadata.binary.RefArchiveBinaryDefinition;
import org.iplass.mtp.impl.metadata.binary.SimpleBinaryMetaData;
import org.iplass.mtp.spi.ServiceRegistry;

public class ArchiveBinaryMetaData
implements BinaryMetaData,
Externalizable {
    private String name;
    private long size;
    private Path tempPath;
    protected BinaryMetaDataService service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);
    private final ConcurrentHashMap<String, Entry> entryCache;

    public ArchiveBinaryMetaData() {
        this.entryCache = new ConcurrentHashMap();
    }

    public ArchiveBinaryMetaData(String name) {
        this.name = name;
        this.entryCache = new ConcurrentHashMap();
    }

    public ArchiveBinaryMetaData(String name, Path source) {
        this.name = name;
        this.entryCache = new ConcurrentHashMap();
        try (OutputStream os = this.getOutputStream();){
            Files.copy(source, os);
            this.readZipEntry();
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't copy ArchiveBinaryMetaData's source/tempFile:" + String.valueOf(source) + "/" + String.valueOf(this.tempPath), e);
        }
    }

    public ArchiveBinaryMetaData(ArchiveBinaryDefinition def) {
        this.name = def.getName();
        this.entryCache = new ConcurrentHashMap();
        try (OutputStream os = this.getOutputStream();
             InputStream is = def.getInputStream();){
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
            this.readZipEntry();
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't copy ArchiveBinaryMetaData's definition/tempFile:" + def.getName() + "/" + String.valueOf(this.tempPath), e);
        }
    }

    @Override
    public BinaryDefinition currentConfig() {
        return new RefArchiveBinaryDefinition(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Path getTempPath() {
        return this.tempPath;
    }

    public boolean hasEntry(String path) {
        return this.entryCache.containsKey(path);
    }

    public InputStream getEntryAsStream(String path) {
        Entry entry = this.entryCache.get(path);
        if (entry == null) {
            return null;
        }
        if (entry.binData == null) {
            this.loadZipEntry(path);
            entry = this.entryCache.get(path);
            if (entry == null || entry.binData == null) {
                return null;
            }
        }
        return entry.binData.getInputStream();
    }

    public long getEntrySize(String path) {
        Entry entry = this.entryCache.get(path);
        if (entry == null) {
            return -1L;
        }
        return entry.size;
    }

    private void loadZipEntry(String path) {
        this.entryCache.compute(path, (k, v) -> {
            if (v.binData == null) {
                Entry entry;
                SimpleBinaryMetaData newV = new SimpleBinaryMetaData(path);
                ZipFile zip = new ZipFile(this.tempPath.toFile());
                try {
                    try (InputStream is = zip.getInputStream(zip.getEntry(path));
                         OutputStream os = newV.getOutputStream();){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    Entry newE = new Entry();
                    newE.size = newV.getSize();
                    newE.binData = newV;
                    entry = newE;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            zip.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MetaDataIllegalStateException("can't open/read ArchiveBinaryMetaData's tempFile:" + String.valueOf(this.tempPath), e);
                    }
                }
                zip.close();
                return entry;
            }
            return v;
        });
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() {
        if (this.tempPath == null) {
            return null;
        }
        try {
            return Files.newInputStream(this.tempPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't open/read ArchiveBinaryMetaData's tempFile:" + String.valueOf(this.tempPath), e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new ZipMetaDataOutputStream();
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't open/write ArchiveBinaryMetaData's tempFile:" + String.valueOf(this.tempPath), e);
        }
    }

    private Path initTempFile() throws IOException {
        if (this.tempPath != null) {
            Files.deleteIfExists(this.tempPath);
        }
        Path tempDir = this.service.getTempFileDir();
        this.tempPath = Files.createTempFile(tempDir, "abmd_", ".tmp", new FileAttribute[0]);
        return this.tempPath;
    }

    private void readZipEntry() throws IOException {
        this.entryCache.clear();
        try (ZipFile zip = new ZipFile(this.tempPath.toFile());){
            zip.stream().forEach(e -> {
                String name = e.getName();
                Entry entry = new Entry();
                entry.size = e.getSize();
                this.entryCache.put(name, entry);
            });
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        try (InputStream is = this.getInputStream();){
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.size);
        try (InputStream is = this.getInputStream();){
            byte[] buff = new byte[8192];
            long count = 0L;
            int n = 0;
            while (-1 != (n = is.read(buff))) {
                out.write(buff, 0, n);
                count += (long)n;
            }
            if (this.size != count) {
                throw new IOException("unmatch size:" + this.size + " != InputStream length:" + count);
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);
        this.name = in.readUTF();
        this.size = in.readLong();
        try (OutputStream os = Files.newOutputStream(this.initTempFile(), new OpenOption[0]);){
            int ren;
            byte[] buff = new byte[8192];
            for (long remain = this.size; remain > 0L; remain -= (long)ren) {
                ren = remain >= (long)buff.length ? in.read(buff) : in.read(buff, 0, (int)remain);
                if (ren < 0) {
                    throw new EOFException("cant read data correctly");
                }
                os.write(buff, 0, ren);
            }
        }
        this.readZipEntry();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tempPath != null) {
            Files.deleteIfExists(this.tempPath);
        }
    }

    private static class Entry {
        long size;
        SimpleBinaryMetaData binData;

        private Entry() {
        }
    }

    private class ZipMetaDataOutputStream
    extends FilterOutputStream {
        private ZipMetaDataOutputStream() throws IOException {
            super(Files.newOutputStream(ArchiveBinaryMetaData.this.initTempFile(), new OpenOption[0]));
        }

        @Override
        public void write(int b) throws IOException {
            ++ArchiveBinaryMetaData.this.size;
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if ((off | len | b.length - (len + off) | off + len) < 0) {
                throw new IndexOutOfBoundsException();
            }
            ArchiveBinaryMetaData.this.size += (long)len;
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            ArchiveBinaryMetaData.this.readZipEntry();
        }
    }
}

