/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.binary.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaDataService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chunk {
    private static Logger logger = LoggerFactory.getLogger(Chunk.class);
    private final boolean marshalMode;
    private int length;
    private long offset;
    private BinaryMetaData binMeta;
    private Path tempFile;
    private byte[] bin;

    Chunk(long offset, int length, BinaryMetaData binMeta) {
        this.marshalMode = true;
        this.offset = offset;
        this.length = length;
        this.binMeta = binMeta;
    }

    public Chunk() {
        this.marshalMode = false;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) throws IOException {
        this.offset = offset;
        if (!this.marshalMode && offset > 0L && this.bin != null) {
            this.toFile();
        }
    }

    public byte[] getBin() throws IOException {
        if (this.marshalMode) {
            try (InputStream is = this.binMeta.getInputStream();){
                is.skip(this.offset);
                byte[] retBin = new byte[this.length];
                IOUtils.readFully((InputStream)is, (byte[])retBin, (int)0, (int)this.length);
                byte[] byArray = retBin;
                return byArray;
            }
        }
        if (this.tempFile != null) {
            return Files.readAllBytes(this.tempFile);
        }
        return this.bin;
    }

    public void setBin(byte[] bin) throws IOException {
        this.bin = bin;
        if (!this.marshalMode && this.offset > 0L && bin != null) {
            this.toFile();
        }
    }

    private void toFile() throws IOException {
        BinaryMetaDataService service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);
        Path dir = service.getTempFileDir();
        this.tempFile = Files.createTempFile(dir, "cr_", ".tmp", new FileAttribute[0]);
        Files.write(this.tempFile, this.bin, new OpenOption[0]);
        this.bin = null;
    }

    void dispose() {
        if (this.tempFile != null) {
            try {
                Files.deleteIfExists(this.tempFile);
            }
            catch (IOException e) {
                logger.warn("can't delete temp file:" + String.valueOf(this.tempFile));
            }
            this.tempFile = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

