/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.typeconversion;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.MetaDataStore;
import org.iplass.mtp.impl.metadata.typeconversion.TypeConverter;
import org.iplass.mtp.spi.Config;

public class TypeConversionMetaDataStore
implements MetaDataStore {
    private MetaDataStore store;
    private List<TypeConverter> converters;

    public MetaDataStore getStore() {
        return this.store;
    }

    public void setStore(MetaDataStore store) {
        this.store = store;
    }

    public List<TypeConverter> getConverters() {
        return this.converters;
    }

    public void setConverters(List<TypeConverter> converters) {
        this.converters = converters;
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        MetaDataEntry entry = this.store.loadById(tenantId, id);
        if (entry != null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                if (!c.isConvertTarget(entry)) continue;
                c.convert(entry);
                break;
            }
        }
        return entry;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id, int version) {
        MetaDataEntry entry = this.store.loadById(tenantId, id, version);
        if (entry != null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                if (!c.isConvertTarget(entry)) continue;
                c.convert(entry);
                break;
            }
        }
        return entry;
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath) throws MetaDataRuntimeException {
        return this.definitionList(tenantId, prefixPath, false);
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath, boolean withInvalid) throws MetaDataRuntimeException {
        List<MetaDataEntryInfo> list = this.store.definitionList(tenantId, prefixPath, withInvalid);
        if (this.converters != null) {
            ArrayList<MetaDataEntryInfo> newList = null;
            for (TypeConverter c : this.converters) {
                String fallbackPath;
                List<MetaDataEntryInfo> fallbackList;
                if (!c.hasFallbackPath(prefixPath) || (fallbackList = this.store.definitionList(tenantId, fallbackPath = c.fallbackPath(prefixPath), withInvalid)).size() <= 0) continue;
                if (newList == null) {
                    newList = new ArrayList<MetaDataEntryInfo>(list);
                }
                newList.addAll(fallbackList);
            }
            if (newList != null) {
                list = newList;
            }
            block1: for (MetaDataEntryInfo mi : list) {
                for (TypeConverter c : this.converters) {
                    if (!c.isConvertTarget(mi)) continue;
                    c.convert(mi);
                    continue block1;
                }
            }
        }
        return list;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) throws MetaDataRuntimeException {
        MetaDataEntry entry = this.store.load(tenantId, path);
        if (path != null && entry == null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                String fallbackPath;
                MetaDataEntry fallbackEntry;
                if (!c.hasFallbackPath(path) || (fallbackEntry = this.store.load(tenantId, fallbackPath = c.fallbackPath(path))) == null) continue;
                fallbackEntry.setPath(path);
                entry = fallbackEntry;
                break;
            }
        }
        if (entry != null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                if (!c.isConvertTarget(entry)) continue;
                c.convert(entry);
                break;
            }
        }
        return entry;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        MetaDataEntry entry = this.store.load(tenantId, path, version);
        if (path != null && entry == null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                String fallbackPath;
                MetaDataEntry fallbackEntry;
                if (!c.hasFallbackPath(path) || (fallbackEntry = this.store.load(tenantId, fallbackPath = c.fallbackPath(path), version)) == null) continue;
                fallbackEntry.setPath(path);
                entry = fallbackEntry;
                break;
            }
        }
        if (entry != null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                if (!c.isConvertTarget(entry)) continue;
                c.convert(entry);
                break;
            }
        }
        return entry;
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.store.store(tenantId, metaDataEntry);
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.store.update(tenantId, metaDataEntry);
    }

    @Override
    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        boolean removeFallback = false;
        if (path != null && this.converters != null) {
            for (TypeConverter c : this.converters) {
                String fallbackPath;
                MetaDataEntry fallbackEntry;
                if (!c.hasFallbackPath(path) || (fallbackEntry = this.store.load(tenantId, fallbackPath = c.fallbackPath(path))) == null) continue;
                this.store.remove(tenantId, fallbackPath);
                removeFallback = true;
                break;
            }
        }
        if (removeFallback && this.store.load(tenantId, path) == null) {
            return;
        }
        this.store.remove(tenantId, path);
    }

    @Override
    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
        this.store.purgeById(tenantId, id);
    }

    @Override
    public List<Integer> getTenantIdsOf(String id) {
        return this.store.getTenantIdsOf(id);
    }

    @Override
    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        this.store.updateConfigById(tenantId, id, config);
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String id) {
        List<MetaDataEntryInfo> list = this.store.getHistoryById(tenantId, id);
        block0: for (MetaDataEntryInfo mi : list) {
            for (TypeConverter c : this.converters) {
                if (!c.isConvertTarget(mi)) continue;
                c.convert(mi);
                continue block0;
            }
        }
        return list;
    }
}

