/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlfile;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.iplass.mtp.impl.metadata.AbstractXmlMetaDataStore;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataJAXBService;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRepositoryKind;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.xmlfile.VersioningMetaDataEntryThinWrapper;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningXmlFileMetaDataStore
extends AbstractXmlMetaDataStore {
    private static Logger logger = LoggerFactory.getLogger(VersioningXmlFileMetaDataStore.class);
    private static final String DEFAULT_VERSION_FORMAT = "000";
    private String versionFormat = "000";
    private String fileStorePath;
    private String suffix = ".xml";

    public String getFileStorePath() {
        return this.fileStorePath;
    }

    public void setFileStorePath(String fileStorePath) {
        if (fileStorePath != null && !((String)(fileStorePath = ((String)fileStorePath).replaceAll("\\\\", "/"))).endsWith("/")) {
            fileStorePath = (String)fileStorePath + "/";
        }
        this.fileStorePath = fileStorePath;
    }

    public String getVersionFormat() {
        return this.versionFormat;
    }

    public void setVersionFormat(String versionFormat) {
        this.versionFormat = versionFormat;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        return this.loadById(tenantId, id, -1);
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id, int version) {
        String prefixpath = this.getFileStorePath() + tenantId;
        MetaDataEntry e = this.searchFileById(tenantId, id.trim(), new File(prefixpath), version);
        if (e == null) {
            return null;
        }
        return e;
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath, boolean withInvalid) throws MetaDataRuntimeException {
        boolean readHistorical = false;
        return this.definitionListImpl(tenantId, prefixPath, readHistorical, withInvalid);
    }

    private List<MetaDataEntryInfo> definitionListImpl(int tenantId, String prefixPath, boolean readHistorical, boolean withInvalid) throws MetaDataRuntimeException {
        Object path = prefixPath;
        if (prefixPath != null) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            if (((String)path).contains("..")) {
                throw new MetaDataRuntimeException("invalid path:" + (String)path);
            }
        }
        HashMap<String, MetaDataEntryInfo> res = new HashMap<String, MetaDataEntryInfo>();
        File dir = new File(this.getFileStorePath() + "/" + tenantId + "/" + (String)path);
        this.readMetaDataEntryInfoRecursive(res, tenantId, dir, readHistorical, withInvalid);
        return new ArrayList<MetaDataEntryInfo>(res.values());
    }

    private void readMetaDataEntryInfoRecursive(HashMap<String, MetaDataEntryInfo> res, int tenantId, File f, boolean readHistorical, boolean withInvalid) {
        if (f.exists()) {
            if (f.isDirectory()) {
                String[] list;
                for (String l : list = f.list()) {
                    File subdirFile = new File(f, l);
                    this.readMetaDataEntryInfoRecursive(res, tenantId, subdirFile, readHistorical, withInvalid);
                }
            } else if (withInvalid) {
                MetaDataFileAttribute atr = new MetaDataFileAttribute(f.getName());
                MetaDataEntryInfo node = this.makeMetaDataEntryInfo(tenantId, f, atr);
                MetaDataEntryInfo preNode = res.get(node.getPath());
                if (preNode == null) {
                    res.put(node.getPath(), node);
                } else if (preNode.getVersion() < node.getVersion()) {
                    res.put(node.getPath(), node);
                }
            } else {
                MetaDataFileAttribute atr = new MetaDataFileAttribute(f.getName());
                if (readHistorical) {
                    MetaDataEntryInfo node = this.makeMetaDataEntryInfo(tenantId, f, atr);
                    res.put(node.getPath() + "." + node.getVersion(), node);
                } else {
                    int latestVersion = -1;
                    if (this.isTargetVersion(atr, -1)) {
                        MetaDataEntryInfo node = this.makeMetaDataEntryInfo(tenantId, f, atr);
                        res.put(node.getPath(), node);
                    }
                }
            }
        }
    }

    private MetaDataEntryInfo makeMetaDataEntryInfo(int tenantId, File file, MetaDataFileAttribute atr) {
        MetaDataEntry e = this.readMetaDataEntry(tenantId, file);
        MetaDataEntryInfo node = new MetaDataEntryInfo();
        node.setPath(e.getPath());
        node.setId(e.getMetaData().getId());
        node.setDisplayName(e.getMetaData().getDisplayName());
        node.setDescription(e.getMetaData().getDescription());
        node.setSharable(e.isSharable());
        node.setDataSharable(e.isDataSharable());
        node.setPermissionSharable(e.isPermissionSharable());
        node.setOverwritable(e.isOverwritable());
        node.setRepository(MetaDataRepositoryKind.XMLFILE.getDisplayName());
        if (atr.status == FileNameStatePart.DELETED) {
            node.setState(MetaDataEntry.State.INVALID);
        } else {
            node.setState(MetaDataEntry.State.VALID);
        }
        node.setVersion(atr.getVersionNum());
        return node;
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
        super.inited(service, config);
        if (this.fileStorePath != null) {
            this.fileStorePath = this.fileStorePath.replaceAll("\\\\", "/");
            if (!this.fileStorePath.endsWith("/")) {
                this.fileStorePath = this.fileStorePath + "/";
            }
            logger.debug("XmlFileRepository." + new File(this.fileStorePath).getAbsolutePath());
            MetaDataJAXBService jaxbService = config.getDependentService(MetaDataJAXBService.class);
            this.context = jaxbService.createJAXBContext(VersioningMetaDataEntryThinWrapper.class);
        }
    }

    private MetaDataEntry readMetaDataEntry(int tenantId, File file) {
        MetaDataEntry instance = null;
        try {
            MetaDataFileAttribute atr;
            instance = new MetaDataEntry();
            VersioningMetaDataEntryThinWrapper meta = this.unmarshal(file);
            instance.setMetaData(meta.getMetaData());
            if (meta.getVersion() != null) {
                instance.setVersion(meta.getVersion());
            }
            instance.setState((atr = new MetaDataFileAttribute(file.getName())).getStatus().equals((Object)FileNameStatePart.VALID) ? MetaDataEntry.State.VALID : MetaDataEntry.State.INVALID);
            String filePath = file.getPath();
            String pathDirpart = filePath.substring(this.getFileStorePath().length() + String.valueOf(tenantId).length(), filePath.lastIndexOf(atr.getBaseName()));
            String path = (pathDirpart + atr.getBaseName()).replaceAll("\\\\", "/");
            instance.setPath(path);
            instance.setSharable(meta.isSharable());
            instance.setDataSharable(meta.isDataSharable());
            instance.setPermissionSharable(meta.isPermissionSharable());
            instance.setOverwritable(meta.isOverwritable());
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        return instance;
    }

    private MetaDataEntry searchFileById(int tenantId, String id, File dir, int version) {
        if (dir.isDirectory()) {
            String[] list;
            for (String l : list = dir.list()) {
                MetaDataEntry e;
                File f = new File(dir, l);
                if (f.isDirectory()) {
                    MetaDataEntry subDirMeta = this.searchFileById(tenantId, id, f, version);
                    if (subDirMeta == null) continue;
                    return subDirMeta;
                }
                MetaDataFileAttribute atr = new MetaDataFileAttribute(l);
                if (!this.isTargetVersion(atr, version) || !id.equals((e = this.readMetaDataEntry(tenantId, f)).getMetaData().getId())) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) throws MetaDataRuntimeException {
        int version = -1;
        return this.loadInternal(tenantId, path, -1);
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        return this.loadInternal(tenantId, path, version);
    }

    public MetaDataEntry loadInternal(int tenantId, String path, int version) throws MetaDataRuntimeException {
        if (path.contains("..")) {
            throw new MetaDataRuntimeException("invalid path:" + path);
        }
        try {
            String[] list;
            String filePath = tenantId + path;
            String dirPath = this.getFileStorePath() + filePath.substring(0, filePath.lastIndexOf("/"));
            String baseName = path.substring(path.lastIndexOf("/") + 1);
            if (baseName.length() == 0) {
                return null;
            }
            File dir = new File(dirPath);
            if (!dir.exists()) {
                return null;
            }
            for (String l : list = dir.list()) {
                MetaDataFileAttribute atr;
                File file = new File(dir, l);
                if (file.isDirectory() || !(atr = new MetaDataFileAttribute(l)).getBaseName().equals(baseName) || !this.isTargetVersion(atr, version)) continue;
                MetaDataEntry instance = new MetaDataEntry();
                VersioningMetaDataEntryThinWrapper meta = this.unmarshal(file);
                instance.setMetaData(meta.getMetaData());
                if (meta.getVersion() != null) {
                    instance.setVersion(meta.getVersion());
                }
                instance.setState(atr.getStatus().equals((Object)FileNameStatePart.VALID) ? MetaDataEntry.State.VALID : MetaDataEntry.State.INVALID);
                instance.setPath(path);
                return instance;
            }
            return null;
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    private int getStoreVersion(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        String[] list;
        if (metaDataEntry == null) {
            return 0;
        }
        String filePath = "/" + tenantId + metaDataEntry.getPath();
        String dirPath = this.getFileStorePath() + filePath.substring(0, filePath.lastIndexOf("/"));
        String baseName = filePath.substring(filePath.lastIndexOf("/") + 1);
        File dir = new File(dirPath);
        if (baseName.length() == 0 || !dir.exists()) {
            return 0;
        }
        int maxVersion = -1;
        for (String l : list = dir.list()) {
            MetaDataFileAttribute atr = new MetaDataFileAttribute(l);
            if (!atr.getBaseName().equals(baseName) || atr.getVersionNum() <= maxVersion) continue;
            maxVersion = atr.getVersionNum();
        }
        return maxVersion + 1;
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        int ver = this.getStoreVersion(tenantId, metaDataEntry);
        this.storeImpl(tenantId, metaDataEntry, ver);
    }

    private void storeImpl(int tenantId, MetaDataEntry metaDataEntry, int version) {
        String id = metaDataEntry.getMetaData().getId();
        String path = metaDataEntry.getPath();
        int newVersion = 0;
        if (path.contains("..")) {
            throw new MetaDataRuntimeException("invalid path:" + path);
        }
        MetaDataEntryInfo existing = null;
        for (MetaDataEntryInfo ei : this.definitionList(tenantId, "/", true)) {
            if (!ei.getId().equals(id)) continue;
            existing = ei;
        }
        String dirPath = this.getFileStorePath() + "/" + tenantId;
        if (existing != null) {
            String existingFilePath = dirPath + "/" + existing.getPath();
            if (existing.getState().equals((Object)MetaDataEntry.State.VALID)) {
                String versionStr = ".v" + new DecimalFormat(this.versionFormat).format(existing.getVersion());
                File valid = new File(existingFilePath + ".V" + versionStr + this.suffix);
                File file = new File(existingFilePath + ".D" + versionStr + this.suffix);
                valid.renameTo(file);
                newVersion = existing.getVersion() + 1;
            }
            if (!existing.getPath().equals(metaDataEntry.getPath())) {
                File existingVersionsDir = new File(existingFilePath.substring(0, existingFilePath.lastIndexOf("/")));
                String existingBaseName = existingFilePath.substring(existingFilePath.lastIndexOf("/") + 1);
                for (File l : existingVersionsDir.listFiles()) {
                    MetaDataFileAttribute atr;
                    if (!l.isFile() || !(atr = new MetaDataFileAttribute(l.getName())).getBaseName().equals(existingBaseName)) continue;
                    String newPathDir = path.substring(0, path.lastIndexOf("/"));
                    String newBaseName = path.substring(path.lastIndexOf("/") + 1);
                    String metaDataNameAttribute = newPathDir.substring(newPathDir.indexOf("/"));
                    atr.setBaseName(newBaseName);
                    String newFileName = atr.getFileName();
                    File to = new File(dirPath + newPathDir + "/" + newFileName);
                    File toDir = to.getParentFile();
                    if (!toDir.exists()) {
                        toDir.mkdirs();
                    }
                    l.renameTo(to);
                    MetaDataEntry existingMeta = this.readMetaDataEntry(tenantId, to);
                    existingMeta.getMetaData().setName(metaDataNameAttribute);
                    VersioningMetaDataEntryThinWrapper meta = new VersioningMetaDataEntryThinWrapper(existingMeta.getMetaData());
                    this.marshal(meta, to);
                }
                if (existingVersionsDir.listFiles() != null && existingVersionsDir.listFiles().length == 0) {
                    existingVersionsDir.delete();
                }
            }
        }
        VersioningMetaDataEntryThinWrapper meta = new VersioningMetaDataEntryThinWrapper(metaDataEntry.getMetaData());
        meta.setVersion(newVersion);
        String newPathDir = path.substring(0, path.lastIndexOf("/"));
        String newBaseName = path.substring(path.lastIndexOf("/") + 1);
        String string = ".v" + new DecimalFormat(this.versionFormat).format(newVersion);
        File xml = new File(dirPath + "/" + newPathDir + "/" + newBaseName + "." + FileNameStatePart.VALID.getValue() + string + this.suffix);
        this.marshal(meta, xml);
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.storeImpl(tenantId, metaDataEntry, -1);
    }

    @Override
    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        if (path.contains("..")) {
            throw new MetaDataRuntimeException("invalid path:" + path);
        }
        String baseName = path.substring(path.lastIndexOf("/") + 1);
        String filePath = "/" + tenantId + path;
        String dirPath = this.getFileStorePath() + filePath.substring(0, filePath.lastIndexOf("/"));
        for (File l : new File(dirPath).listFiles()) {
            MetaDataFileAttribute atr;
            if (!l.isFile() || !(atr = new MetaDataFileAttribute(l.getName())).getBaseName().equals(baseName) || !atr.status.equals((Object)FileNameStatePart.VALID)) continue;
            atr.setStatus(FileNameStatePart.DELETED);
            String fileNameAsDeleted = atr.getFileName();
            File to = new File(dirPath + "/" + fileNameAsDeleted);
            l.renameTo(to);
            break;
        }
    }

    @Override
    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
        for (MetaDataEntryInfo e : this.definitionListImpl(tenantId, "/", true, true)) {
            if (!e.getId().equals(id)) continue;
            String ver = ".v" + new DecimalFormat(this.versionFormat).format(e.getVersion());
            String state = e.getState() == MetaDataEntry.State.VALID ? FileNameStatePart.VALID.getValue() : FileNameStatePart.DELETED.getValue();
            File xml = new File(this.getFileStorePath() + tenantId + "/" + e.getPath() + "." + state + ver + this.suffix);
            xml.delete();
        }
    }

    @Override
    public List<Integer> getTenantIdsOf(String id) {
        String[] list;
        ArrayList<Integer> tids = new ArrayList<Integer>();
        File dir = new File(this.getFileStorePath());
        if (!dir.exists()) {
            return tids;
        }
        for (String l : list = dir.list()) {
            int tid = Integer.parseInt(l);
            if (this.loadById(tid, id) == null) continue;
            tids.add(tid);
        }
        return tids;
    }

    @Override
    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        MetaDataEntry e = this.loadById(tenantId, id, -1);
        VersioningMetaDataEntryThinWrapper meta = new VersioningMetaDataEntryThinWrapper(e.getMetaData());
        meta.setVersion(e.getVersion());
        meta.setSharable(config.isSharable());
        meta.setDataSharable(config.isDataSharable());
        meta.setPermissionSharable(config.isPermissionSharable());
        meta.setOverwritable(config.isOverwritable());
        String ver = ".v" + new DecimalFormat(this.versionFormat).format(e.getVersion());
        File xml = new File(this.getFileStorePath() + tenantId + "/" + e.getPath() + "." + FileNameStatePart.VALID.getValue() + ver + this.suffix);
        this.marshal(meta, xml);
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String id) {
        ArrayList<MetaDataEntryInfo> result = new ArrayList<MetaDataEntryInfo>();
        boolean readHistorical = true;
        for (MetaDataEntryInfo e : this.definitionListImpl(tenantId, "/", readHistorical, false)) {
            if (!e.getId().equals(id)) continue;
            result.add(e);
        }
        return result;
    }

    private void marshal(VersioningMetaDataEntryThinWrapper meta, File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.marshal((Object)meta, file);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    private VersioningMetaDataEntryThinWrapper unmarshal(File f) throws JAXBException {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        return (VersioningMetaDataEntryThinWrapper)unmarshaller.unmarshal(f);
    }

    private boolean isTargetVersion(MetaDataFileAttribute atr, int version) {
        return version < 0 && atr.getStatus() == FileNameStatePart.VALID || atr.getVersionNum() == version;
    }

    private class MetaDataFileAttribute {
        private FileNameStatePart status;
        private int versionNum;
        private String baseName;

        public MetaDataFileAttribute(String fileName) {
            String bn = fileName.substring(0, fileName.lastIndexOf("."));
            this.versionNum = Integer.valueOf(bn.substring(bn.lastIndexOf(".") + ".v".length()));
            bn = bn.substring(0, bn.lastIndexOf("."));
            this.status = FileNameStatePart.getStatus(bn.substring(bn.lastIndexOf(".") + ".".length()));
            this.baseName = bn.substring(0, bn.lastIndexOf("."));
        }

        public FileNameStatePart getStatus() {
            return this.status;
        }

        public void setStatus(FileNameStatePart status) {
            this.status = status;
        }

        public int getVersionNum() {
            return this.versionNum;
        }

        public void setVersionNum(int versionNum) {
            this.versionNum = versionNum;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public String getFileName() {
            return this.baseName + "." + this.status.getValue() + ".v" + this.getVersion() + VersioningXmlFileMetaDataStore.this.suffix;
        }

        public String getVersion() {
            return new DecimalFormat(VersioningXmlFileMetaDataStore.this.versionFormat).format(this.versionNum);
        }
    }

    private static enum FileNameStatePart {
        VALID("V"),
        DELETED("D");

        private String value;

        private FileNameStatePart(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static FileNameStatePart getStatus(String value) {
            for (FileNameStatePart s : FileNameStatePart.values()) {
                if (!value.equals(s.getValue())) continue;
                return s;
            }
            return null;
        }
    }
}

