/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlfile.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.mtp.impl.metadata.xmlfile.dom.ExternalRefPath;
import org.iplass.mtp.impl.metadata.xmlfile.dom.ExternalRefPathAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractExternalRefPath
implements ExternalRefPath {
    private static final int FILE_SEQ_DIGIT_DEFAULT = 3;
    private int fileSequenceDigit = 3;
    private String fileExt = null;

    public void setFileExt(String fileExt) {
        this.fileExt = fileExt;
    }

    public void setFileSequenceDigit(int fileSequenceDigit) {
        this.fileSequenceDigit = fileSequenceDigit;
    }

    @Override
    public final List<Node> getNodeList(Document doc) {
        Element node = doc.getDocumentElement();
        ArrayList<Node> result = new ArrayList<Node>();
        int idx = 0;
        this.traceNode(node, idx, result);
        return result;
    }

    @Override
    public final String getTagName() {
        return this.getPathLastElement();
    }

    @Override
    public String getFileExtention(Node node) {
        Object ret = null;
        if (this.fileExt != null) {
            ret = this.fileExt;
            if (!((String)ret).startsWith(".")) {
                ret = "." + (String)ret;
            }
        } else {
            ExternalRefPathAttribute pathAttr = this.getClass().getAnnotation(ExternalRefPathAttribute.class);
            ret = pathAttr.fileExtension().getExt();
        }
        return ret;
    }

    @Override
    public String getTemplateType(Node node) {
        ExternalRefPathAttribute pathAttr = this.getClass().getAnnotation(ExternalRefPathAttribute.class);
        return pathAttr.templateType().getType();
    }

    @Override
    public boolean isBase64Tag(Node node) {
        ExternalRefPathAttribute pathAttr = this.getClass().getAnnotation(ExternalRefPathAttribute.class);
        return pathAttr.base64Tag();
    }

    @Override
    public String getLocaleName(Node node) {
        return null;
    }

    @Override
    public String getSequenceNumber(int num) {
        if (this.getClass().getAnnotation(ExternalRefPathAttribute.class).useFileSequence()) {
            String seqFormat = "%1$0" + this.fileSequenceDigit + "d";
            return String.format(seqFormat, ++num);
        }
        return "";
    }

    protected final String getChildNodeValue(Node parent, String childNodeName) {
        NodeList nl = parent.getChildNodes();
        String value = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            if (childNode == null || !childNode.getNodeName().equals(childNodeName)) continue;
            value = childNode.getFirstChild().getNodeValue();
            break;
        }
        return value;
    }

    private void traceNode(Node node, int idx, List<Node> result) {
        String tagName = this.getPathList().get(++idx);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(tagName)) continue;
            if (!this.getPathLastElement().equals(tagName)) {
                this.traceNode(child, idx, result);
            }
            if (!child.getNodeName().equals(this.getPathLastElement())) continue;
            result.add(child);
        }
    }

    private List<String> getPathList() {
        return Arrays.asList(this.getPath().split("/"));
    }

    private String getPathLastElement() {
        return this.getPath().replaceFirst(".*/", "");
    }

    private String getPath() {
        ExternalRefPathAttribute pathAttr = this.getClass().getAnnotation(ExternalRefPathAttribute.class);
        String path = pathAttr.path();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

