/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlfile.dom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.xmlfile.dom.DomHandler;
import org.iplass.mtp.impl.metadata.xmlfile.dom.ExternalRefPath;
import org.iplass.mtp.impl.metadata.xmlfile.dom.ExternalRefPathAttribute;
import org.iplass.mtp.impl.metadata.xmlfile.dom.XsiType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XsiTypeDomHandler
implements DomHandler {
    private static final String TMPL_PREFIX = "#{";
    private static final String TMPL_SUFFIX = "}";
    private File xml;
    private File fileRootDir;
    private File groovySourceRootDir;
    private String charset;
    private List<String> refFiles = new ArrayList<String>();
    private XsiType xsiType;

    public XsiTypeDomHandler(File xml, File fileRootDir, File groovySourceRootDir, String charset, XsiType xsiType) {
        this.xml = xml;
        this.fileRootDir = fileRootDir;
        this.groovySourceRootDir = groovySourceRootDir;
        this.charset = charset;
        this.xsiType = xsiType;
    }

    @Override
    public void putUnescapedExtFiles(Document doc) {
        for (ExternalRefPath targetPath : this.xsiType.getExternalRefPaths()) {
            this.toUnescapedExtFile(targetPath, doc);
        }
    }

    @Override
    public void restoreFromUnescapedExtFiles(Document doc) {
        for (ExternalRefPath targetPath : this.xsiType.getExternalRefPaths()) {
            this.readFromUnescapedExtFile(targetPath, doc);
        }
    }

    @Override
    public List<String> refFiles() {
        return this.refFiles;
    }

    private String getMidExtension(ExternalRefPath targetPath, Node node) {
        String localeName;
        ArrayList<String> midExt = new ArrayList<String>();
        String groovyTemplateType = targetPath.getTemplateType(node);
        if (groovyTemplateType != null) {
            midExt.add(groovyTemplateType);
        }
        if ((localeName = targetPath.getLocaleName(node)) != null) {
            midExt.add(localeName);
        }
        return midExt.size() > 0 ? "." + String.join((CharSequence)".", midExt) : "";
    }

    private void toUnescapedExtFile(ExternalRefPath targetPath, Document doc) {
        List<Node> scriptTags = targetPath.getNodeList(doc);
        String tagetTagName = targetPath.getTagName();
        for (int i = 0; i < scriptTags.size(); ++i) {
            Node childNode = scriptTags.get(i).getFirstChild();
            if (childNode == null) continue;
            String unescapedContent = childNode.getNodeValue();
            String lastExt = targetPath.getFileExtention(childNode);
            String fileExtension = this.getMidExtension(targetPath, childNode) + lastExt;
            String refName = tagetTagName + this.sequenceNumber(i, targetPath);
            String refFile = this.getRefFileName(refName, fileExtension, targetPath);
            String key = TMPL_PREFIX + refFile + TMPL_SUFFIX;
            childNode.setNodeValue(key);
            if (targetPath.isBase64Tag(childNode)) {
                this.writeBase64ContentToFile(unescapedContent, new File(this.resolveDir(targetPath, this.xml.getParentFile()), refFile));
            } else {
                this.writeContentToFile(unescapedContent, new File(this.resolveDir(targetPath, this.xml.getParentFile()), refFile));
            }
            this.refFiles.add(refFile);
        }
    }

    private void readFromUnescapedExtFile(ExternalRefPath targetPath, Document doc) {
        List<Node> scriptTags = targetPath.getNodeList(doc);
        for (int i = 0; i < scriptTags.size(); ++i) {
            String val;
            Node childNode = scriptTags.get(i).getFirstChild();
            if (childNode == null || (val = childNode.getNodeValue()) == null || !(val = val.trim()).startsWith(TMPL_PREFIX) || !val.endsWith(TMPL_SUFFIX)) continue;
            val = val.replace(TMPL_PREFIX, "").replace(TMPL_SUFFIX, "");
            File extFile = new File(this.resolveDir(targetPath, this.xml.getParentFile()), val);
            String content = null;
            content = targetPath.isBase64Tag(childNode) ? this.readBase64FromBinFile(extFile) : this.readContentFromFile(extFile);
            childNode.setNodeValue(content);
        }
    }

    private void writeContentToFile(String content, File file) {
        try (FileOutputStream fo = new FileOutputStream(file);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fo, this.charset);
             PrintWriter out = new PrintWriter(ow);){
            out.print(content);
        }
        catch (IOException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    private String readContentFromFile(File file) {
        String content = "";
        try {
            byte[] b = Files.readAllBytes(file.toPath());
            content = new String(b, this.charset);
        }
        catch (IOException e) {
            throw new MetaDataRuntimeException(e);
        }
        return content;
    }

    private void writeBase64ContentToFile(String base64, File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(Base64.getDecoder().decode(base64));
            out.close();
        }
        catch (IOException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    private String readBase64FromBinFile(File file) {
        String base64 = null;
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            base64 = Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            throw new MetaDataRuntimeException(e);
        }
        return base64;
    }

    private String getRefFileName(String refName, String ext, ExternalRefPath path) {
        if (path.getClass().getAnnotation(ExternalRefPathAttribute.class).useGroovyDir()) {
            String fileName = this.xml.getName().substring(0, this.xml.getName().lastIndexOf(".xml"));
            return fileName + ExternalRefPathAttribute.FileExtention.GROOVY.getExt();
        }
        return this.xml.getName() + "." + refName + ext;
    }

    private String sequenceNumber(int index, ExternalRefPath path) {
        return path.getSequenceNumber(index);
    }

    private File resolveDir(ExternalRefPath path, File parentDir) {
        if (this.groovySourceRootDir != null && path.getClass().getAnnotation(ExternalRefPathAttribute.class).useGroovyDir()) {
            String fRoot = this.fileRootDir.getAbsolutePath().replace(File.separator, "/");
            String grvyRoot = this.groovySourceRootDir.getAbsolutePath().replace(File.separator, "/");
            String parent = parentDir.getAbsolutePath().replace(File.separator, "/");
            Object scriptPath = parent.replace(fRoot, grvyRoot);
            String relativeFromRoot = ((String)scriptPath).replace(grvyRoot + "/", "");
            ArrayList<String> relativeDelimited = new ArrayList<String>(Arrays.asList(relativeFromRoot.split("/")));
            int dirToPackage = 1;
            for (int i = 0; i < dirToPackage; ++i) {
                relativeDelimited.remove(0);
            }
            relativeFromRoot = String.join((CharSequence)"/", relativeDelimited);
            scriptPath = grvyRoot + "/" + relativeFromRoot;
            File dir = new File((String)scriptPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
        return parentDir;
    }
}

