/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlresource;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.metadata.AbstractXmlMetaDataStore;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRepositoryKind;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.xmlresource.ContextPath;
import org.iplass.mtp.impl.metadata.xmlresource.MetaDataEntryList;
import org.iplass.mtp.impl.metadata.xmlresource.XmlResourceMetaDataEntryThinWrapper;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlResourceMetaDataStore
extends AbstractXmlMetaDataStore {
    private static Logger logger = LoggerFactory.getLogger(XmlResourceMetaDataStore.class);
    private List<String> resourcePathList;
    private List<String> filePathList;
    private Map<String, XmlResourceMetaDataEntryThinWrapper> pathMetaMap;
    private Map<String, String> idPathMap;

    public Map<String, XmlResourceMetaDataEntryThinWrapper> getPathMetaMap() {
        return this.pathMetaMap;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        String path = this.idPathMap.get(id);
        if (path == null) {
            return null;
        }
        XmlResourceMetaDataEntryThinWrapper meta = this.pathMetaMap.get(path);
        MetaDataEntry instance = new MetaDataEntry();
        if (meta.getMetaData() != null) {
            instance.setMetaData(meta.getMetaData().copy());
        }
        instance.setVersion(0);
        instance.setState(MetaDataEntry.State.VALID);
        instance.setPath(path);
        instance.setSharable(true);
        instance.setDataSharable(meta.isDataSharable());
        instance.setPermissionSharable(meta.isPermissionSharable());
        instance.setOverwritable(meta.isOverwritable());
        return instance;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id, int version) {
        return this.loadById(tenantId, id);
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath, boolean withInvalid) throws MetaDataRuntimeException {
        Object path = prefixPath;
        if (path != null && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        ArrayList<MetaDataEntryInfo> res = new ArrayList<MetaDataEntryInfo>();
        for (Map.Entry<String, XmlResourceMetaDataEntryThinWrapper> e : this.pathMetaMap.entrySet()) {
            if (!e.getKey().startsWith((String)path)) continue;
            MetaDataEntryInfo node = new MetaDataEntryInfo();
            node.setPath(e.getKey());
            node.setId(e.getValue().getMetaData().getId());
            node.setDisplayName(e.getValue().getMetaData().getDisplayName());
            node.setDescription(e.getValue().getMetaData().getDescription());
            node.setSharable(true);
            node.setDataSharable(e.getValue().isDataSharable());
            node.setPermissionSharable(e.getValue().isPermissionSharable());
            node.setOverwritable(e.getValue().isOverwritable());
            node.setRepository(MetaDataRepositoryKind.XMLRESOURCE.getDisplayName());
            node.setState(MetaDataEntry.State.VALID);
            res.add(node);
        }
        Collections.sort(res, new Comparator<MetaDataEntryInfo>(this){

            @Override
            public int compare(MetaDataEntryInfo o1, MetaDataEntryInfo o2) {
                return o1.getPath().toLowerCase().compareTo(o2.getPath().toLowerCase());
            }
        });
        return res;
    }

    @Override
    public void destroyed() {
        super.destroyed();
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
        InputStream is;
        Unmarshaller um;
        super.inited(service, config);
        this.pathMetaMap = new HashMap<String, XmlResourceMetaDataEntryThinWrapper>();
        this.idPathMap = new HashMap<String, String>();
        try {
            um = this.context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        this.resourcePathList = config.getValues("resourcePath");
        logger.debug("XmlResourceMetaDataRepository:load resource. " + String.valueOf(this.resourcePathList));
        if (this.resourcePathList != null) {
            for (String path : this.resourcePathList) {
                is = this.getClass().getResourceAsStream(path);
                if (is != null) {
                    this.parse(is, um, path);
                    continue;
                }
                throw new MetaDataRuntimeException("can not find resource file:" + path);
            }
        }
        this.filePathList = config.getValues("filePath");
        logger.debug("XmlResourceMetaDataRepository:load file. " + String.valueOf(this.filePathList));
        if (this.filePathList != null) {
            for (String path : this.filePathList) {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new MetaDataRuntimeException("can not find file:" + path, e);
                }
                this.parse(is, um, path);
            }
        }
    }

    private void parse(InputStream is, Unmarshaller um, String resoucePath) {
        try {
            MetaDataEntryList metaList = (MetaDataEntryList)um.unmarshal(is);
            if (metaList.getContextPath() != null) {
                for (ContextPath context : metaList.getContextPath()) {
                    this.parseContextPath(context, "", context.getName(), resoucePath);
                }
            }
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("can not close resource.maybe resource leak.", (Throwable)e);
                }
            }
        }
    }

    private void parseContextPath(ContextPath context, String prefixPath, String rootPath, String resoucePath) {
        if (context.getContextPath() != null) {
            for (ContextPath child : context.getContextPath()) {
                this.parseContextPath(child, prefixPath + context.getName() + "/", rootPath, resoucePath);
            }
        }
        if (context.getEntry() != null) {
            for (XmlResourceMetaDataEntryThinWrapper ent : context.getEntry()) {
                if (ent.getMetaData() == null) {
                    logger.warn("Cannot unmarshal metadata from XmlResource. resourcePath:" + resoucePath + ", contextpath:" + rootPath);
                    continue;
                }
                Object path = ent.getName();
                if (path == null) {
                    path = prefixPath + context.getName() + "/" + ent.getMetaData().getName();
                } else if (((String)path).length() > 0 && ((String)path).charAt(0) != '/') {
                    path = prefixPath + context.getName() + "/" + (String)path;
                }
                this.pathMetaMap.put((String)path, ent);
                if (ent.getMetaData().getId() == null) {
                    ent.getMetaData().setId((String)path);
                }
                this.idPathMap.put(ent.getMetaData().getId(), (String)path);
            }
        }
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) {
        XmlResourceMetaDataEntryThinWrapper meta = this.pathMetaMap.get(path);
        if (meta == null) {
            return null;
        }
        MetaDataEntry instance = new MetaDataEntry();
        if (meta.getMetaData() != null) {
            instance.setMetaData(meta.getMetaData().copy());
        }
        instance.setVersion(0);
        instance.setState(MetaDataEntry.State.VALID);
        instance.setPath(path);
        instance.setSharable(true);
        instance.setDataSharable(meta.isDataSharable());
        instance.setPermissionSharable(meta.isPermissionSharable());
        instance.setOverwritable(meta.isOverwritable());
        return instance;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        return this.load(tenantId, path);
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        throw new MetaDataRuntimeException(metaDataEntry.getPath() + "'s meta data is read only.");
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        throw new MetaDataRuntimeException(metaDataEntry.getPath() + "'s meta data is read only.");
    }

    @Override
    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        throw new MetaDataRuntimeException(path + "'s meta data is read only.");
    }

    @Override
    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        throw new MetaDataRuntimeException(id + "'s meta data is read only.");
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String id) {
        return Collections.emptyList();
    }

    @Override
    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
    }

    @Override
    public List<Integer> getTenantIdsOf(String id) {
        return Collections.emptyList();
    }
}

