/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.prefs;

import java.util.Collections;
import java.util.Map;
import org.iplass.mtp.impl.definition.AbstractTypedDefinitionManager;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.prefs.MetaPreference;
import org.iplass.mtp.impl.prefs.PreferenceService;
import org.iplass.mtp.prefs.Preference;
import org.iplass.mtp.prefs.PreferenceManager;
import org.iplass.mtp.prefs.PreferenceSet;
import org.iplass.mtp.spi.ServiceRegistry;

public class PreferenceManagerImpl
extends AbstractTypedDefinitionManager<Preference>
implements PreferenceManager {
    private PreferenceService service = ServiceRegistry.getRegistry().getService(PreferenceService.class);

    @Override
    public Preference get(String name) {
        return this.get(name, true);
    }

    @Override
    public Preference get(String name, boolean nullAsDefault) {
        Preference definition = (Preference)super.get(name);
        if (definition == null) {
            if (nullAsDefault) {
                return new PreferenceSet(name, new Preference[0]);
            }
            return null;
        }
        return definition;
    }

    @Override
    public Map<String, Object> getAsMap(String name) {
        MetaPreference.PreferenceRuntime runtime = (MetaPreference.PreferenceRuntime)this.service.getRuntimeByName(name);
        if (runtime == null) {
            return Collections.emptyMap();
        }
        return runtime.getMap();
    }

    @Override
    public Object getRuntime(String name) {
        MetaPreference.PreferenceRuntime runtime = (MetaPreference.PreferenceRuntime)this.service.getRuntimeByName(name);
        if (runtime == null) {
            return null;
        }
        return runtime.getRuntime();
    }

    @Override
    public Class<Preference> getDefinitionType() {
        return Preference.class;
    }

    @Override
    protected RootMetaData newInstance(Preference definition) {
        return MetaPreference.newMeta(definition);
    }

    @Override
    protected TypedMetaDataService getService() {
        return this.service;
    }
}

