/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.extend;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringTokenizer;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.controlflow.Case;
import org.iplass.mtp.entity.query.value.expr.Polynomial;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobHandler;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperTypeLoadAdapter;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.spi.ServiceRegistry;

public class BinaryType
extends ComplexWrapperType {
    private static final long serialVersionUID = -3079789714739573857L;
    private static final int hash = 25;
    public static final String LOB_STORE_NAME = "binaryStore";
    private PropertyType actualType = new StringType();

    @Override
    public int hashCode() {
        return 25;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public boolean isCompatibleTo(PropertyType another) {
        return this.equals(another);
    }

    @Override
    public BinaryProperty createPropertyDefinitionInstance() {
        return new BinaryProperty();
    }

    @Override
    public Object createRuntime(MetaProperty metaProperty, MetaEntity metaEntity) {
        return null;
    }

    @Override
    public BinaryType copy() {
        return new BinaryType();
    }

    @Override
    public PropertyType actualType() {
        return this.actualType;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.BINARY;
    }

    @Override
    public PropertyDefinitionType getDataStoreEnumType() {
        return PropertyDefinitionType.STRING;
    }

    @Override
    public boolean isNeedPrevStoreTypeValueOnToStoreTypeValue() {
        return true;
    }

    @Override
    public Object toStoreTypeValue(Object extendTypeValue, Object prevStoreTypeValue, PropertyHandler ph, EntityHandler eh, String oid, Long version, Entity entity) {
        LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
        Binary prevBin = null;
        if (prevStoreTypeValue != null && prevStoreTypeValue != null) {
            prevBin = new Binary((String)prevStoreTypeValue);
            if (extendTypeValue == null || ((BinaryReference)extendTypeValue).getLobId() != prevBin.lobId) {
                lm.removeBinaryData(prevBin.lobId);
            }
        }
        if (extendTypeValue == null) {
            return null;
        }
        BinaryReference newBinRef = (BinaryReference)extendTypeValue;
        Lob binData = lm.getBinaryData(newBinRef.getLobId());
        if (binData == null) {
            return null;
        }
        if (prevBin == null || prevBin.lobId != binData.getLobId()) {
            String sessionId = ServiceRegistry.getRegistry().getService(SessionService.class).getSession(true).getId();
            if ("T".equals(binData.getStatus())) {
                if (!lm.markPersistenceBinaryData(binData.getLobId(), sessionId, eh.getMetaData().getId(), ph.getId(), oid, version)) {
                    throw new EntityRuntimeException("new lob must user's temporary lob");
                }
            } else if (lm.canAccess(binData)) {
                binData = lm.copyFor(binData.getLobId(), eh.getMetaData().getId(), ph.getId(), oid, version);
            } else {
                throw new EntityRuntimeException("cant reference lob cause security reason.lobId:" + binData.getLobId());
            }
        }
        Binary bin = new Binary(binData.getLobId(), binData.getName(), binData.getType(), binData.getSize(), eh.getMetaData().getId(), ph.getId(), oid, version);
        return bin.toStringExpression();
    }

    @Override
    public void notifyAfterDelete(Object storeTypeValue, PropertyHandler ph, EntityHandler eh, String oid, Long rbid) {
        if (storeTypeValue != null) {
            Binary bin = new Binary((String)storeTypeValue);
            LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
            if (rbid == null) {
                lm.removeBinaryData(bin.lobId);
            } else {
                lm.markToRecycleBin(bin.lobId, rbid);
            }
        }
    }

    @Override
    public void notifyAfterPurge(EntityHandler eh, Long rbid) {
        LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
        lm.removeBinaryDataByRbid(rbid);
    }

    @Override
    public void notifyAfterRestore(EntityHandler eh, Long rbid) {
        LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
        lm.markRestoreFromRecycleBin(rbid);
    }

    @Override
    public Class<?> extendType() {
        return BinaryReference.class;
    }

    @Override
    public ComplexWrapperTypeLoadAdapter createLoadAdapter() {
        return new BinaryTypeLoadAdapter(this);
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        return Long.toString(((BinaryReference)value).getLobId());
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        Binary bin = new Binary(strValue);
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler eh = context.getHandlerById(bin.entityDefinitionId);
        String entityName = null;
        String propertyName = null;
        if (eh != null) {
            entityName = eh.getMetaData().getName();
            PropertyHandler ph = eh.getPropertyById(bin.propertyId, context);
            if (ph != null) {
                propertyName = ph.getName();
            }
        }
        return new BinaryReference(bin.lobId, bin.name, bin.type, bin.size, entityName, propertyName, bin.oid);
    }

    @Override
    public ValueExpression translate(EntityField field) {
        return new Case().when(new Greater(new Function("INSTR", field, new Literal("\t")), new Literal(0L)), new Function("SUBSTR", field, new Polynomial(new Function("INSTR", field, new Literal("\t"))).add(new Literal(1L)))).elseClause(new Literal(null));
    }

    public static class Binary {
        private long lobId;
        private String name;
        private String type;
        private long size;
        private String entityDefinitionId;
        private String propertyId;
        private String oid;
        private Long version;

        public Binary() {
        }

        public Binary(long lobId, String name, String type, long size, String entityDefinitionId, String propertyId, String oid, Long version) {
            this.lobId = lobId;
            this.name = name;
            this.type = type;
            this.size = size;
            this.entityDefinitionId = entityDefinitionId;
            this.propertyId = propertyId;
            this.oid = oid;
            this.version = version;
            if (name != null && name.indexOf(9) >= 0) {
                throw new IllegalArgumentException("Binary name can't contains tab");
            }
            if (type != null && type.indexOf(9) >= 0) {
                throw new IllegalArgumentException("Binary type can't contains tab");
            }
        }

        public Binary(String stringExpression) {
            int tIndex = stringExpression.indexOf(9);
            if (tIndex >= 0) {
                stringExpression = stringExpression.substring(0, tIndex);
            }
            StringTokenizer st = StringTokenizer.getCSVInstance((String)stringExpression);
            List line = null;
            line = st.getTokenList();
            if (line != null) {
                for (String l : line) {
                    if (l == null) continue;
                    if (l.startsWith("lobId=")) {
                        this.lobId = Long.parseLong(l.substring("lobId=".length()));
                        continue;
                    }
                    if (l.startsWith("name=")) {
                        this.name = l.substring("name=".length());
                        if (this.name.length() != 0) continue;
                        this.name = null;
                        continue;
                    }
                    if (l.startsWith("type=")) {
                        this.type = l.substring("type=".length());
                        if (this.type.length() != 0) continue;
                        this.type = null;
                        continue;
                    }
                    if (l.startsWith("size=")) {
                        this.size = Long.parseLong(l.substring("size=".length()));
                        continue;
                    }
                    if (l.startsWith("entityDefinitionId=")) {
                        this.entityDefinitionId = l.substring("entityDefinitionId=".length());
                        if (this.entityDefinitionId.length() != 0) continue;
                        this.entityDefinitionId = null;
                        continue;
                    }
                    if (l.startsWith("propertyId=")) {
                        this.propertyId = l.substring("propertyId=".length());
                        if (this.propertyId.length() != 0) continue;
                        this.propertyId = null;
                        continue;
                    }
                    if (l.startsWith("oid=")) {
                        this.oid = l.substring("oid=".length());
                        if (this.oid.length() != 0) continue;
                        this.oid = null;
                        continue;
                    }
                    if (!l.startsWith("version=")) continue;
                    String verStr = l.substring("version=".length());
                    if (verStr.length() == 0) {
                        this.version = null;
                        continue;
                    }
                    this.version = Long.parseLong(verStr);
                }
            }
        }

        public long getLobId() {
            return this.lobId;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public String getEntityDefinitionId() {
            return this.entityDefinitionId;
        }

        public String getPropertyId() {
            return this.propertyId;
        }

        public String getOid() {
            return this.oid;
        }

        public Long getVersion() {
            return this.version;
        }

        public String toStringExpression() {
            StringBuilder sb = new StringBuilder();
            sb.append(StringEscapeUtils.escapeCsv((String)("lobId=" + this.lobId)));
            sb.append(",");
            if (this.name == null) {
                sb.append("name=");
            } else {
                sb.append(StringEscapeUtils.escapeCsv((String)("name=" + this.name)));
            }
            sb.append(",");
            if (this.type == null) {
                sb.append("type=");
            } else {
                sb.append(StringEscapeUtils.escapeCsv((String)("type=" + this.type)));
            }
            sb.append(",");
            sb.append(StringEscapeUtils.escapeCsv((String)("size=" + this.size)));
            sb.append(",");
            if (this.entityDefinitionId == null) {
                sb.append("entityDefinitionId=");
            } else {
                sb.append(StringEscapeUtils.escapeCsv((String)("entityDefinitionId=" + this.entityDefinitionId)));
            }
            sb.append(",");
            if (this.propertyId == null) {
                sb.append("propertyId=");
            } else {
                sb.append(StringEscapeUtils.escapeCsv((String)("propertyId=" + this.propertyId)));
            }
            sb.append(",");
            if (this.oid == null) {
                sb.append("oid=");
            } else {
                sb.append(StringEscapeUtils.escapeCsv((String)("oid=" + this.oid)));
            }
            sb.append(",");
            if (this.version == null) {
                sb.append("version=");
            } else {
                sb.append(StringEscapeUtils.escapeCsv((String)("version=" + this.version)));
            }
            sb.append('\t');
            if (this.name != null) {
                sb.append(this.name);
            }
            return sb.toString();
        }
    }

    public class BinaryTypeLoadAdapter
    implements ComplexWrapperTypeLoadAdapter {
        protected LobHandler lobHandler;
        protected EntityContext context;

        public BinaryTypeLoadAdapter(BinaryType this$0) {
        }

        @Override
        public void setContext(EntityContext context) {
            this.context = context;
            this.lobHandler = LobHandler.getInstance(BinaryType.LOB_STORE_NAME);
        }

        @Override
        public void nextCalled(List<Object> values) {
        }

        @Override
        public Object toComplexWrapperTypeValue(Object value) {
            if (value == null) {
                return null;
            }
            Binary bin = new Binary((String)value);
            EntityHandler eh = this.context.getHandlerById(bin.entityDefinitionId);
            String entityName = null;
            String propertyName = null;
            if (eh != null) {
                entityName = eh.getMetaData().getName();
                PropertyHandler ph = eh.getPropertyById(bin.propertyId, this.context);
                if (ph != null) {
                    propertyName = ph.getName();
                }
            }
            return new BinaryReference(bin.lobId, bin.name, bin.type, bin.size, entityName, propertyName, bin.oid);
        }

        @Override
        public void close() {
        }

        @Override
        public Object[] newComplexWrapperTypeArray(int size) {
            return new BinaryReference[size];
        }
    }
}

