/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.extend;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyService;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.entity.versioning.VersionedQueryNormalizer;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.properties.extend.SelectType;
import org.iplass.mtp.impl.properties.extend.VirtualType;
import org.iplass.mtp.impl.query.QueryServiceHolder;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class ExpressionType
extends VirtualType {
    private static final long serialVersionUID = -7890554839217349016L;
    private String expression;
    private PropertyDefinitionType resultType;
    private PropertyType resultTypeSpec;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.resultType == null ? 0 : this.resultType.hashCode());
        result = 31 * result + (this.resultTypeSpec == null ? 0 : this.resultTypeSpec.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionType other = (ExpressionType)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.resultType != other.resultType) {
            return false;
        }
        return !(this.resultTypeSpec == null ? other.resultTypeSpec != null : !this.resultTypeSpec.equals(other.resultTypeSpec));
    }

    public PropertyType getResultTypeSpec() {
        return this.resultTypeSpec;
    }

    public void setResultTypeSpec(PropertyType resultTypeSpec) {
        this.resultTypeSpec = resultTypeSpec;
    }

    public PropertyDefinitionType getResultType() {
        return this.resultType;
    }

    public void setResultType(PropertyDefinitionType resultType) {
        this.resultType = resultType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public PropertyType copy() {
        ExpressionType copy = new ExpressionType();
        copy.expression = this.expression;
        copy.resultType = this.resultType;
        if (this.resultTypeSpec != null) {
            copy.resultTypeSpec = this.resultTypeSpec.copy();
        }
        return copy;
    }

    @Override
    public PropertyDefinition createPropertyDefinitionInstance() {
        ExpressionProperty prop = new ExpressionProperty();
        prop.setExpression(this.expression);
        if (this.resultType != null) {
            prop.setResultType(this.resultType);
        }
        if (this.resultTypeSpec != null) {
            prop.setResultTypeSpec(this.resultTypeSpec.createPropertyDefinitionInstance());
        }
        return prop;
    }

    @Override
    public void applyDefinition(PropertyDefinition def) {
        super.applyDefinition(def);
        ExpressionProperty exDef = (ExpressionProperty)def;
        this.expression = exDef.getExpression();
        this.resultType = exDef.getResultType();
        this.resultTypeSpec = this.resultType != null && exDef.getResultTypeSpec() != null ? ServiceRegistry.getRegistry().getService(PropertyService.class).newPropertyType(exDef.getResultTypeSpec()) : null;
    }

    @Override
    public Object createRuntime(MetaProperty metaProperty, MetaEntity metaEntity) {
        return null;
    }

    @Override
    public Object fromDataStore(Object fromDataStore) {
        return fromDataStore;
    }

    @Override
    public Class<?> storeType() {
        return null;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.EXPRESSION;
    }

    @Override
    public Object toDataStore(Object toDataStore) {
        throw new UnsupportedOperationException("ExpressionType is ReadOnly");
    }

    @Override
    public ValueExpression translate(EntityField field) {
        ValueExpression ve;
        try {
            ve = (ValueExpression)QueryServiceHolder.getInstance().getQueryParser().parse(this.expression, PolynomialSyntax.class);
        }
        catch (ParseException e) {
            throw new QueryException(e.getMessage(), e);
        }
        String parentPath = field.getPropertyName().contains(".") ? field.getPropertyName().substring(0, field.getPropertyName().lastIndexOf(46)) : null;
        ExpressionVisitor qvs = new ExpressionVisitor(parentPath);
        ve.accept(qvs);
        return ve;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Object toVirtualTypeValue(Object value, PrimitivePropertyHandler ph) {
        if (this.resultType == null) {
            return value;
        }
        switch (this.resultType) {
            case BOOLEAN: {
                return ConvertUtil.convert(Boolean.class, value);
            }
            case DATE: {
                return ConvertUtil.convert(Date.class, value);
            }
            case DATETIME: {
                return ConvertUtil.convert(Timestamp.class, value);
            }
            case DECIMAL: {
                return ConvertUtil.convert(BigDecimal.class, value);
            }
            case FLOAT: {
                return ConvertUtil.convert(Double.class, value);
            }
            case INTEGER: {
                return ConvertUtil.convert(Long.class, value);
            }
            case SELECT: {
                if (this.resultTypeSpec != null) {
                    SelectType st = (SelectType)this.resultTypeSpec;
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof SelectValue) {
                        return st.fromDataStore(((SelectValue)value).getValue());
                    }
                    return st.fromDataStore(value.toString());
                }
                return ConvertUtil.convert(SelectValue.class, value);
            }
            case STRING: {
                return ConvertUtil.convert(String.class, value);
            }
            case TIME: {
                return ConvertUtil.convert(Time.class, value);
            }
        }
        return value;
    }

    @Override
    public Object[] newVirtualTypeArray(int size) {
        if (this.resultType == null) {
            return new Object[size];
        }
        switch (this.resultType) {
            case BOOLEAN: {
                return new Boolean[size];
            }
            case DATE: {
                return new Date[size];
            }
            case DATETIME: {
                return new Timestamp[size];
            }
            case DECIMAL: {
                return new BigDecimal[size];
            }
            case FLOAT: {
                return new Double[size];
            }
            case INTEGER: {
                return new Long[size];
            }
            case SELECT: {
                return new SelectValue[size];
            }
            case STRING: {
                return new String[size];
            }
            case TIME: {
                return new Time[size];
            }
        }
        return new Object[size];
    }

    @Override
    public Object fromString(String strValue) {
        if (this.resultType == null) {
            return strValue;
        }
        switch (this.resultType) {
            case BOOLEAN: {
                return ConvertUtil.convert(Boolean.class, strValue);
            }
            case DATE: {
                return ConvertUtil.convert(Date.class, strValue);
            }
            case DATETIME: {
                return ConvertUtil.convert(Timestamp.class, strValue);
            }
            case DECIMAL: {
                return ConvertUtil.convert(BigDecimal.class, strValue);
            }
            case FLOAT: {
                return ConvertUtil.convert(Double.class, strValue);
            }
            case INTEGER: {
                return ConvertUtil.convert(Long.class, strValue);
            }
            case SELECT: {
                if (this.resultTypeSpec != null) {
                    SelectType st = (SelectType)this.resultTypeSpec;
                    if (strValue == null) {
                        return null;
                    }
                    return st.fromDataStore(strValue);
                }
                return ConvertUtil.convert(SelectValue.class, strValue);
            }
            case STRING: {
                return strValue;
            }
            case TIME: {
                return ConvertUtil.convert(Time.class, strValue);
            }
        }
        return strValue;
    }

    private class ExpressionVisitor
    extends QueryVisitorSupport {
        ExpressionVisitor upper;
        String parentPath;
        boolean inSubqueryOnClause;

        ExpressionVisitor(String parentPath) {
            this.parentPath = parentPath;
        }

        @Override
        public boolean visit(EntityField entityField) {
            if (this.inSubqueryOnClause) {
                ExpressionVisitor forMain = this;
                int unnestCount = entityField.unnestCount();
                if (unnestCount > 0) {
                    for (int i = 0; i <= unnestCount; ++i) {
                        if (forMain == null) {
                            throw new QueryException("subQuery's on clause invalid. not found correlation property:" + String.valueOf(entityField));
                        }
                        forMain = forMain.upper;
                    }
                    if (forMain == null && this.parentPath != null) {
                        String pre = entityField.getPropertyName().substring(0, unnestCount);
                        String prop = entityField.getPropertyName().substring(unnestCount);
                        if (!"this".equalsIgnoreCase(prop)) {
                            entityField.setPropertyName(pre + this.parentPath + "." + prop);
                        } else {
                            entityField.setPropertyName(pre + this.parentPath);
                        }
                    }
                    return super.visit(entityField);
                }
            }
            if (this.upper == null && this.parentPath != null) {
                entityField.setPropertyName(this.parentPath + "." + entityField.getPropertyName());
            }
            return super.visit(entityField);
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            Query q = subQuery.getQuery();
            if (this.upper == null && !q.isVersioned()) {
                EntityContext context = EntityContext.getCurrentContext();
                EntityService ehService = ServiceRegistry.getRegistry().getService(EntityService.class);
                EntityHandler eh = ehService.getRuntimeByName(q.getFrom().getEntityName());
                if (eh == null) {
                    throw new EntityRuntimeException(q.getFrom().getEntityName() + " is undefined. at expression property of " + ExpressionType.this.expression);
                }
                q = (Query)new VersionedQueryNormalizer(ehService.getVersionController(eh), eh, context, null).visit(q);
                subQuery.setQuery(q);
            }
            ExpressionVisitor nest = new ExpressionVisitor(this.parentPath);
            nest.upper = this;
            q.accept(nest);
            Condition on = subQuery.getOn();
            if (on != null) {
                nest.inSubqueryOnClause = true;
                subQuery.getOn().accept(nest);
                nest.inSubqueryOnClause = false;
            }
            return false;
        }
    }
}

