/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.pushnotification;

import java.util.Map;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.pushnotification.PushNotificationService;
import org.iplass.mtp.impl.pushnotification.template.MetaPushNotificationTemplate;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationManager;
import org.iplass.mtp.pushnotification.PushNotificationResult;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class PushNotificationManagerImpl
implements PushNotificationManager {
    private PushNotificationService pnService = ServiceRegistry.getRegistry().getService(PushNotificationService.class);

    @Override
    public PushNotification createNotification(String tmplDefName, Map<String, Object> bindings) {
        MetaPushNotificationTemplate.PushNotificationTemplateRuntime tr = (MetaPushNotificationTemplate.PushNotificationTemplateRuntime)this.pnService.getRuntimeByName(tmplDefName);
        if (tr == null) {
            throw new SystemException("Can not find template:" + tmplDefName);
        }
        return tr.createPushNotification(bindings);
    }

    @Override
    public PushNotificationResult push(PushNotification notification) {
        Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        return this.pnService.push(tenant, notification);
    }
}

