/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.pushnotification;

import java.util.HashMap;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.pushnotification.template.MetaPushNotificationTemplate;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationException;
import org.iplass.mtp.pushnotification.PushNotificationListener;
import org.iplass.mtp.pushnotification.PushNotificationResult;
import org.iplass.mtp.pushnotification.template.definition.PushNotificationTemplateDefinition;
import org.iplass.mtp.pushnotification.template.definition.PushNotificationTemplateDefinitionManager;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushNotificationService
extends AbstractTypedMetaDataService<MetaPushNotificationTemplate, MetaPushNotificationTemplate.PushNotificationTemplateRuntime>
implements Service {
    public static final String PUSH_NOTIFICATION_TEMPLATE_META_PATH = "/pushNotification/template/";
    private static Logger logger = LoggerFactory.getLogger(PushNotificationService.class);
    private List<PushNotificationListener> listener;

    public static String getFixedPath() {
        return PUSH_NOTIFICATION_TEMPLATE_META_PATH;
    }

    @Override
    public void init(Config config) {
        if (config.getBeans("listener") != null) {
            this.listener = config.getBeans("listener");
        }
    }

    @Override
    public void destroy() {
    }

    public final PushNotificationResult push(Tenant tenant, PushNotification notification) {
        try {
            if (this.listener != null) {
                for (PushNotificationListener l : this.listener) {
                    if (l.beforePush(notification)) continue;
                    logger.info("Push notification canceled by Listener:" + String.valueOf(l));
                    HashMap<String, Object> details = new HashMap<String, Object>();
                    details.put("listener", l.getClass());
                    details.put("canceled", true);
                    return new PushNotificationResult(false, details);
                }
            }
            PushNotificationResult res = this.pushImpl(tenant, notification);
            if (this.listener != null) {
                for (PushNotificationListener l : this.listener) {
                    l.onSuccess(notification, res);
                }
            }
            return res;
        }
        catch (Exception e) {
            if (this.listener != null) {
                for (PushNotificationListener l : this.listener) {
                    if (l.onFailure(notification, e)) continue;
                    HashMap<String, Object> details = new HashMap<String, Object>();
                    details.put("listener", l.getClass());
                    details.put("exceptionConsumed", true);
                    details.put("exception", e);
                    return new PushNotificationResult(true, details);
                }
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new PushNotificationException(e.getMessage(), e);
        }
    }

    protected PushNotificationResult pushImpl(Tenant tenant, PushNotification notification) {
        logger.warn("can't push notification, use FCMPushNotificationService or own implementation of PushNotificationService. toList:" + String.valueOf(notification.getToList()) + ", notification:" + String.valueOf(notification.getNotification()) + ", data:" + String.valueOf(notification.getData()));
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("noop", true);
        return new PushNotificationResult(true, details);
    }

    @Override
    public Class<MetaPushNotificationTemplate> getMetaDataType() {
        return MetaPushNotificationTemplate.class;
    }

    @Override
    public Class<MetaPushNotificationTemplate.PushNotificationTemplateRuntime> getRuntimeType() {
        return MetaPushNotificationTemplate.PushNotificationTemplateRuntime.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<PushNotificationTemplateDefinition, MetaPushNotificationTemplate> {
        public TypeMap() {
            super(PushNotificationService.getFixedPath(), MetaPushNotificationTemplate.class, PushNotificationTemplateDefinition.class);
        }

        @Override
        public TypedDefinitionManager<PushNotificationTemplateDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(PushNotificationTemplateDefinitionManager.class);
        }
    }
}

