/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.pushnotification.template;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.pushnotification.template.MetaLocalizedNotification;
import org.iplass.mtp.impl.script.GroovyScript;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.pushnotification.NotificationPayload;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.template.definition.LocalizedNotificationDefinition;
import org.iplass.mtp.pushnotification.template.definition.PushNotificationTemplateDefinition;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;

@XmlRootElement
public class MetaPushNotificationTemplate
extends BaseRootMetaData
implements DefinableMetaData<PushNotificationTemplateDefinition> {
    private static final long serialVersionUID = 7600704862048295319L;
    public static final String PUSH_NOTIFICATION_BINDING_NAME = "pn";
    private String title;
    private String body;
    private String icon;
    private List<MetaLocalizedNotification> localizedNotificationList;
    private String configScript;
    private String langOrUserBindingName;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<MetaLocalizedNotification> getLocalizedNotificationList() {
        return this.localizedNotificationList;
    }

    public void setLocalizedNotificationList(List<MetaLocalizedNotification> localizedNotificationList) {
        this.localizedNotificationList = localizedNotificationList;
    }

    public String getConfigScript() {
        return this.configScript;
    }

    public void setConfigScript(String configScript) {
        this.configScript = configScript;
    }

    public String getLangOrUserBindingName() {
        return this.langOrUserBindingName;
    }

    public void setLangOrUserBindingName(String langOrUserBindingName) {
        this.langOrUserBindingName = langOrUserBindingName;
    }

    @Override
    public PushNotificationTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new PushNotificationTemplateRuntime();
    }

    @Override
    public MetaPushNotificationTemplate copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(PushNotificationTemplateDefinition d) {
        this.name = d.getName();
        this.displayName = d.getDisplayName();
        this.description = d.getDescription();
        this.title = d.getTitle();
        this.body = d.getBody();
        this.icon = d.getIcon();
        if (d.getLocalizedNotificationList() != null) {
            this.localizedNotificationList = new ArrayList<MetaLocalizedNotification>();
            for (LocalizedNotificationDefinition lnd : d.getLocalizedNotificationList()) {
                MetaLocalizedNotification mn = new MetaLocalizedNotification();
                mn.setLocaleName(lnd.getLocaleName());
                mn.setTitle(lnd.getTitle());
                mn.setBody(lnd.getBody());
                this.localizedNotificationList.add(mn);
            }
        } else {
            this.localizedNotificationList = null;
        }
        this.configScript = d.getConfigScript();
        this.langOrUserBindingName = d.getLangOrUserBindingName();
    }

    @Override
    public PushNotificationTemplateDefinition currentConfig() {
        PushNotificationTemplateDefinition d = new PushNotificationTemplateDefinition();
        d.setName(this.name);
        d.setDisplayName(this.displayName);
        d.setDescription(this.description);
        d.setTitle(this.title);
        d.setBody(this.body);
        d.setIcon(this.icon);
        if (this.localizedNotificationList != null) {
            for (MetaLocalizedNotification mn : this.localizedNotificationList) {
                LocalizedNotificationDefinition lnd = new LocalizedNotificationDefinition();
                lnd.setLocaleName(mn.getLocaleName());
                lnd.setTitle(mn.getTitle());
                lnd.setBody(mn.getBody());
                d.addLocalizedNotification(lnd);
            }
        }
        d.setConfigScript(this.configScript);
        d.setLangOrUserBindingName(this.langOrUserBindingName);
        return d;
    }

    public class PushNotificationTemplateRuntime
    extends BaseMetaDataRuntime {
        private GroovyTemplate titleTemplate;
        private GroovyTemplate bodyTemplate;
        private GroovyTemplate iconTemplate;
        private Map<String, TemplateSet> templateSetMap = new HashMap<String, TemplateSet>();
        private GroovyScript configScriptScript;

        public PushNotificationTemplateRuntime() {
            try {
                GroovyScriptEngine se = (GroovyScriptEngine)ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                if (MetaPushNotificationTemplate.this.title != null) {
                    this.titleTemplate = GroovyTemplateCompiler.compile(MetaPushNotificationTemplate.this.title, "PNTemplate_Title" + MetaPushNotificationTemplate.this.getName(), se);
                }
                if (MetaPushNotificationTemplate.this.body != null) {
                    this.bodyTemplate = GroovyTemplateCompiler.compile(MetaPushNotificationTemplate.this.body, "PNTemplate_Body" + MetaPushNotificationTemplate.this.getName(), se);
                }
                if (MetaPushNotificationTemplate.this.icon != null) {
                    this.iconTemplate = GroovyTemplateCompiler.compile(MetaPushNotificationTemplate.this.icon, "PNTemplate_Icon" + MetaPushNotificationTemplate.this.getName(), se);
                }
                if (MetaPushNotificationTemplate.this.localizedNotificationList != null && MetaPushNotificationTemplate.this.localizedNotificationList.size() > 0) {
                    for (MetaLocalizedNotification m : MetaPushNotificationTemplate.this.localizedNotificationList) {
                        String localeName = m.getLocaleName();
                        TemplateSet templateSet = new TemplateSet(this);
                        if (m.getTitle() != null) {
                            templateSet.titleTemplate = GroovyTemplateCompiler.compile(m.getTitle(), "PNTemplate_Title" + MetaPushNotificationTemplate.this.getName() + "__" + localeName, se);
                        }
                        if (m.getBody() != null) {
                            templateSet.bodyTemplate = GroovyTemplateCompiler.compile(m.getBody(), "PNTemplate_Body" + MetaPushNotificationTemplate.this.getName() + "__" + localeName, se);
                        }
                        this.templateSetMap.put(localeName, templateSet);
                    }
                }
                if (MetaPushNotificationTemplate.this.configScript != null) {
                    this.configScriptScript = (GroovyScript)se.createScript(MetaPushNotificationTemplate.this.configScript, "PNTemplate_Config" + MetaPushNotificationTemplate.this.getName());
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        @Override
        public MetaPushNotificationTemplate getMetaData() {
            return MetaPushNotificationTemplate.this;
        }

        public PushNotification createPushNotification(Map<String, Object> bindings) {
            GroovyTemplateBinding gtb;
            StringWriter sw;
            this.checkState();
            String lang = ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class).getLocale();
            if (StringUtil.isNotEmpty(MetaPushNotificationTemplate.this.langOrUserBindingName) && bindings.get(MetaPushNotificationTemplate.this.langOrUserBindingName) != null) {
                User user;
                String userLang;
                if (bindings.get(MetaPushNotificationTemplate.this.langOrUserBindingName) instanceof String) {
                    lang = (String)bindings.get(MetaPushNotificationTemplate.this.langOrUserBindingName);
                } else if (bindings.get(MetaPushNotificationTemplate.this.langOrUserBindingName) instanceof User && StringUtil.isNotEmpty(userLang = (user = (User)bindings.get(MetaPushNotificationTemplate.this.langOrUserBindingName)).getLanguage())) {
                    lang = userLang;
                }
            }
            GroovyTemplate _titleTemplate = this.titleTemplate;
            GroovyTemplate _bodyTemplate = this.bodyTemplate;
            TemplateSet ts = this.templateSetMap.get(lang);
            if (ts != null) {
                _titleTemplate = ts.titleTemplate;
                _bodyTemplate = ts.bodyTemplate;
            }
            PushNotification pn = new PushNotification();
            NotificationPayload np = new NotificationPayload();
            pn.setNotification(np);
            if (_titleTemplate != null) {
                sw = new StringWriter();
                gtb = new GroovyTemplateBinding(sw, bindings);
                try {
                    _titleTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                np.put("title", sw.toString());
            }
            if (_bodyTemplate != null) {
                sw = new StringWriter();
                gtb = new GroovyTemplateBinding(sw, bindings);
                try {
                    _bodyTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                np.put("body", sw.toString());
            }
            if (this.iconTemplate != null) {
                sw = new StringWriter();
                gtb = new GroovyTemplateBinding(sw, bindings);
                try {
                    this.iconTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                np.put("icon", sw.toString());
            }
            if (this.configScriptScript != null) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                ScriptEngine ss = tc.getScriptEngine();
                ScriptContext sc = ss.newScriptContext();
                if (bindings != null) {
                    for (Map.Entry<String, Object> e : bindings.entrySet()) {
                        sc.setAttribute(e.getKey(), e.getValue());
                    }
                }
                sc.setAttribute(MetaPushNotificationTemplate.PUSH_NOTIFICATION_BINDING_NAME, pn);
                this.configScriptScript.eval(sc);
            }
            return pn;
        }

        private class TemplateSet {
            private GroovyTemplate titleTemplate;
            private GroovyTemplate bodyTemplate;

            private TemplateSet(PushNotificationTemplateRuntime pushNotificationTemplateRuntime) {
            }
        }
    }
}

