/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class GroupBySyntax
implements Syntax<GroupBy>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public GroupBy parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("GROUP", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("GROUP BY expected.", this, str));
        }
        str.consumeChars("GROUP".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("BY", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("BY expected.", this, str));
        }
        str.consumeChars("BY".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        GroupBy groupBy = new GroupBy();
        boolean isFirst = true;
        while (true) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.startsWith(",")) break;
                str.consumeChars(",".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            ValueExpression groupingField = this.polynomial.parse(str);
            groupBy.add(groupingField);
        }
        int current = str.getCurrentIndex();
        String token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if ("ROLLUP".equalsIgnoreCase(token)) {
            groupBy.setRollType(GroupBy.RollType.ROLLUP);
        } else if ("CUBE".equalsIgnoreCase(token)) {
            groupBy.setRollType(GroupBy.RollType.CUBE);
        } else {
            str.setCurrentIndex(current);
        }
        return groupBy;
    }

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }
}

