/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;

public class LimitSyntax
implements Syntax<Limit>,
QueryConstants {
    @Override
    public Limit parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("LIMIT", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("LIMIT expected.", this, str));
        }
        str.consumeChars("LIMIT".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        Limit limit = new Limit();
        boolean isBind = true;
        if (str.startsWith("/*+")) {
            str.consumeChars("/*+".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
            if (!str.equalsNextToken("NO_BIND", ParseContext.TOKEN_DELIMITERS)) {
                throw new ParseException(new EvalError("only no_bind hint is valid.", this, str));
            }
            str.consumeChars("NO_BIND".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
            isBind = false;
            if (str.startsWith("*/")) {
                str.consumeChars("*/".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            } else {
                throw new ParseException(new EvalError("hint clause not terminated.", this, str));
            }
        }
        int currentIndex = str.getCurrentIndex();
        String limitVal = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        try {
            limit.setLimit(Integer.parseInt(limitVal));
        }
        catch (NumberFormatException e) {
            str.setCurrentIndex(currentIndex);
            throw new ParseException(new EvalError("limit count unspecified.", this, str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.equalsNextToken("OFFSET", ParseContext.TOKEN_DELIMITERS)) {
            str.consumeChars("OFFSET".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
            currentIndex = str.getCurrentIndex();
            String offsetVal = str.nextToken(ParseContext.TOKEN_DELIMITERS);
            try {
                limit.setOffset(Integer.parseInt(offsetVal));
            }
            catch (NumberFormatException e) {
                str.setCurrentIndex(currentIndex);
                throw new ParseException(new EvalError("offset index unspecified.", this, str));
            }
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        limit.setBindable(isBind);
        return limit;
    }

    @Override
    public void init(SyntaxContext context) {
    }
}

