/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.SortSpecSyntax;

public class OrderBySyntax
implements Syntax<OrderBy>,
QueryConstants {
    private SortSpecSyntax sortSpec;

    @Override
    public OrderBy parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("ORDER", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("ORDER BY expected.", this, str));
        }
        str.consumeChars("ORDER".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("BY", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("BY expected.", this, str));
        }
        str.consumeChars("BY".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        OrderBy orderBy = new OrderBy();
        boolean isFirst = true;
        while (true) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.startsWith(",")) break;
                str.consumeChars(",".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            SortSpec sortSpecNode = this.sortSpec.parse(str);
            orderBy.add(sortSpecNode);
        }
        return orderBy;
    }

    @Override
    public void init(SyntaxContext context) {
        this.sortSpec = context.getSyntax(SortSpecSyntax.class);
    }
}

