/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.QuerySyntax;
import org.iplass.mtp.impl.query.condition.expr.OrSyntax;

public class SubQuerySyntax
implements Syntax<SubQuery>,
QueryConstants {
    private QuerySyntax query;
    private OrSyntax or;

    @Override
    public void init(SyntaxContext context) {
        this.query = context.getSyntax(QuerySyntax.class);
        this.or = context.getSyntax(OrSyntax.class);
    }

    @Override
    public SubQuery parse(ParseContext str) throws ParseException {
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars(1);
        str.consumeChars(ParseContext.WHITE_SPACES);
        Query q = this.query.parse(str);
        SubQuery sq = new SubQuery(q);
        if (str.equalsNextToken("ON", ParseContext.TOKEN_DELIMITERS)) {
            str.consumeChars("ON".length());
            if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
                throw new ParseException(new EvalError("space expected.", this, str));
            }
            Condition on = this.or.parse(str);
            sq.setOn(on);
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(1);
        str.consumeChars(ParseContext.WHITE_SPACES);
        return sq;
    }
}

