/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.aggregate;

import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroup;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QueryConstants;

public class WithinGroupSyntax
implements Syntax<WithinGroup>,
QueryConstants {
    private OrderBySyntax orderBy;

    @Override
    public WithinGroup parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("WITHIN", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("WITHIN GROUP expected.", this, str));
        }
        str.consumeChars("WITHIN".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("GROUP", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("GROUP expected.", this, str));
        }
        str.consumeChars("GROUP".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars("(".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        OrderBy ob = this.orderBy.parse(str);
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        WithinGroup withinGroup = new WithinGroup();
        for (SortSpec ss : ob.getSortSpecList()) {
            WithinGroupSortSpec wgss = new WithinGroupSortSpec(ss.getSortKey(), ss.getType(), ss.getNullOrderingSpec());
            withinGroup.add(wgss);
        }
        return withinGroup;
    }

    @Override
    public void init(SyntaxContext context) {
        this.orderBy = context.getSyntax(OrderBySyntax.class);
    }
}

