/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.expr;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.expr.Polynomial;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.TermSyntax;

public class PolynomialSyntax
implements Syntax<ValueExpression>,
QueryConstants {
    private static final int TYPE_PLUS = 1;
    private static final int TYPE_MINUS = 2;
    private static final int TYPE_OTHER = 3;
    private TermSyntax term;

    private int checkOp(ParseContext str) {
        if (str.startsWith("+")) {
            return 1;
        }
        if (str.startsWith("-")) {
            return 2;
        }
        return 3;
    }

    @Override
    public ValueExpression parse(ParseContext str) throws ParseException {
        ValueExpression firstExp = this.term.parse(str);
        ArrayList<ValueExpression> addExp = null;
        ArrayList<ValueExpression> subExp = null;
        int type = 3;
        while ((type = this.checkOp(str)) != 3) {
            str.consumeChars(1);
            str.consumeChars(ParseContext.WHITE_SPACES);
            ValueExpression exp = this.term.parse(str);
            switch (type) {
                case 1: {
                    if (addExp == null) {
                        addExp = new ArrayList();
                        addExp.add(firstExp);
                    }
                    addExp.add(exp);
                    break;
                }
                case 2: {
                    if (subExp == null) {
                        subExp = new ArrayList<ValueExpression>();
                    }
                    subExp.add(exp);
                    break;
                }
            }
        }
        if (addExp == null && subExp == null) {
            return firstExp;
        }
        if (addExp == null) {
            addExp = new ArrayList<ValueExpression>();
            addExp.add(firstExp);
        }
        Polynomial pol = new Polynomial();
        pol.setAddValues(addExp);
        pol.setSubValues(subExp);
        return pol;
    }

    @Override
    public void init(SyntaxContext context) {
        this.term = context.getSyntax(TermSyntax.class);
    }
}

