/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.expr;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.expr.Term;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.MinusSignSyntax;

public class TermSyntax
implements Syntax<ValueExpression>,
QueryConstants {
    private static final int TYPE_ASTER = 1;
    private static final int TYPE_SOLID = 2;
    private static final int TYPE_OTHER = 3;
    private MinusSignSyntax minusSign;

    @Override
    public void init(SyntaxContext context) {
        this.minusSign = context.getSyntax(MinusSignSyntax.class);
    }

    private int checkOp(ParseContext str) {
        if (str.startsWith("*")) {
            return 1;
        }
        if (str.startsWith("/")) {
            return 2;
        }
        return 3;
    }

    @Override
    public ValueExpression parse(ParseContext str) throws ParseException {
        ValueExpression firstExp = this.minusSign.parse(str);
        ArrayList<ValueExpression> mulExp = null;
        ArrayList<ValueExpression> divExp = null;
        int type = 3;
        while ((type = this.checkOp(str)) != 3) {
            str.consumeChars(1);
            str.consumeChars(ParseContext.WHITE_SPACES);
            ValueExpression exp = this.minusSign.parse(str);
            switch (type) {
                case 1: {
                    if (mulExp == null) {
                        mulExp = new ArrayList();
                        mulExp.add(firstExp);
                    }
                    mulExp.add(exp);
                    break;
                }
                case 2: {
                    if (divExp == null) {
                        divExp = new ArrayList<ValueExpression>();
                    }
                    divExp.add(exp);
                    break;
                }
            }
        }
        if (mulExp == null && divExp == null) {
            return firstExp;
        }
        if (mulExp == null) {
            mulExp = new ArrayList<ValueExpression>();
            mulExp.add(firstExp);
        }
        Term term = new Term();
        term.setMulValues(mulExp);
        term.setDivValues(divExp);
        return term;
    }
}

